/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.config;

import com.aizistral.nochatreports.common.config.JSONConfig;
import com.aizistral.nochatreports.common.core.SigningMode;

public final class NCRConfigClient
extends JSONConfig {
    protected static final String FILE_NAME = "NoChatReports/NCR-Client.json";
    protected SigningMode defaultSigningMode = SigningMode.PROMPT;
    protected boolean enableMod = true;
    protected boolean showNCRButton = true;
    protected boolean showReloadButton = true;
    protected boolean verifiedIconEnabled = true;
    protected boolean showServerSafety = true;
    protected boolean hideInsecureMessageIndicators = true;
    protected boolean hideModifiedMessageIndicators = true;
    protected boolean hideSystemMessageIndicators = true;
    protected boolean hideWarningToast = true;
    protected boolean hideSigningRequestMessage = false;
    protected boolean alwaysHideReportButton = false;
    protected boolean skipRealmsWarning = false;
    protected boolean disableTelemetry = true;
    protected boolean removeTelemetryButton = true;
    protected boolean demandOnServer = false;
    protected int verifiedIconOffsetX = 0;
    protected int verifiedIconOffsetY = 0;

    protected NCRConfigClient() {
        super(FILE_NAME);
    }

    @Override
    public NCRConfigClient getDefault() {
        return new NCRConfigClient();
    }

    public void toggleMod() {
        this.enableMod = !this.enableMod;
    }

    public boolean demandOnServer() {
        return this.demandOnServer;
    }

    public boolean showServerSafety() {
        return this.showServerSafety;
    }

    public boolean hideInsecureMessageIndicators() {
        return this.hideInsecureMessageIndicators;
    }

    public boolean hideModifiedMessageIndicators() {
        return this.hideModifiedMessageIndicators;
    }

    public boolean hideSystemMessageIndicators() {
        return this.hideSystemMessageIndicators;
    }

    public boolean hideWarningToast() {
        return this.hideWarningToast;
    }

    public boolean alwaysHideReportButton() {
        return this.alwaysHideReportButton;
    }

    public boolean disableTelemetry() {
        return this.disableTelemetry;
    }

    public boolean showReloadButton() {
        return this.showReloadButton;
    }

    public boolean verifiedIconEnabled() {
        return this.verifiedIconEnabled;
    }

    public int getVerifiedIconOffsetX() {
        return 16 + this.verifiedIconOffsetX;
    }

    public int getVerifiedIconOffsetY() {
        return 12 + this.verifiedIconOffsetY;
    }

    public boolean showNCRButton() {
        return this.showNCRButton;
    }

    public boolean enableMod() {
        return this.enableMod;
    }

    public boolean skipRealmsWarning() {
        return this.skipRealmsWarning;
    }

    public void setSkipRealmsWarning(boolean skipRealmsWarning) {
        this.skipRealmsWarning = skipRealmsWarning;
    }

    public boolean hideSigningRequestMessage() {
        return this.hideSigningRequestMessage;
    }

    public SigningMode defaultSigningMode() {
        return this.defaultSigningMode;
    }

    public boolean removeTelemetryButton() {
        return this.removeTelemetryButton;
    }
}

