/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.ModuleInfo;

public abstract class KiwiBlockLoot
extends FabricBlockLootTableProvider {
    protected final ResourceLocation moduleId;
    private final List<Block> knownBlocks;
    private final Map<Class<?>, Function<Block, LootTable.Builder>> handlers = Maps.newIdentityHashMap();
    private final Set<Block> added = Sets.newHashSet();
    private Function<Block, LootTable.Builder> defaultHandler;

    protected KiwiBlockLoot(ResourceLocation moduleId, FabricDataOutput dataOutput) {
        super(dataOutput);
        this.moduleId = moduleId;
        ModuleInfo info = KiwiModules.get(moduleId);
        Objects.requireNonNull(info);
        this.knownBlocks = info.getRegistries(BuiltInRegistries.f_256975_);
    }

    protected <T extends Block> void handle(Class<T> clazz, Function<T, LootTable.Builder> handler) {
        this.handlers.put(clazz, handler);
    }

    protected void handleDefault(Function<Block, LootTable.Builder> handler) {
        this.defaultHandler = handler;
    }

    public void m_245660_() {
        this.addTables();
        for (Block block : this.knownBlocks) {
            LootTable.Builder builder;
            if (this.added.contains(block)) continue;
            this.added.add(block);
            Function<Block, LootTable.Builder> handler = this.handlers.get(block.getClass());
            if (handler == null) {
                handler = this.defaultHandler;
            }
            if (handler == null || (builder = handler.apply(block)) == null) continue;
            this.m_247577_(block, builder);
        }
    }

    protected abstract void addTables();

    public void m_247577_(Block block, LootTable.Builder builder) {
        super.m_247577_(block, builder);
        this.added.add(block);
    }

    public List<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    public String m_6055_() {
        return super.m_6055_() + " - " + this.moduleId;
    }
}

