/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.shape;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.Stream;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import snownee.kiwi.customization.shape.BakingContext;
import snownee.kiwi.customization.shape.ShapeGenerator;
import snownee.kiwi.customization.shape.UnbakedShape;
import snownee.kiwi.customization.shape.UnbakedShapeCodec;
import snownee.kiwi.util.VoxelUtil;
import snownee.kiwi.util.codec.CustomizationCodecs;

public record DirectionalShape(VoxelShape[] shapes, String property) implements ShapeGenerator
{
    public static ShapeGenerator create(ShapeGenerator upGenerator, String property) {
        Preconditions.checkArgument((property.equals("facing") || property.equals("orientation") ? 1 : 0) != 0, (Object)("Unknown property: " + property));
        VoxelShape up = ShapeGenerator.Unit.unboxOrThrow(upGenerator);
        if (Shapes.m_83144_() == up) {
            return upGenerator;
        }
        VoxelShape[] shapes = new VoxelShape[6];
        shapes[Direction.DOWN.m_122411_()] = VoxelUtil.rotate(up, Direction.UP);
        return new DirectionalShape(shapes, property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public VoxelShape getShape(BlockState blockState, CollisionContext context) {
        Direction direction = switch (this.property) {
            case "facing" -> (Direction)blockState.m_61143_((Property)BlockStateProperties.f_61372_);
            case "orientation" -> JigsawBlock.m_54250_((BlockState)blockState);
            default -> throw new IllegalArgumentException("Unknown property: " + this.property);
        };
        int index = direction.m_122411_();
        VoxelShape shape = this.shapes[index];
        if (shape != null) return shape;
        VoxelShape[] voxelShapeArray = this.shapes;
        synchronized (this.shapes) {
            shape = this.shapes[index];
            if (shape != null) return shape;
            this.shapes[index] = shape = VoxelUtil.rotate(this.shapes[Direction.DOWN.m_122411_()], direction);
            // ** MonitorExit[var6_8] (shouldn't be in output)
            return shape;
        }
    }

    public record Unbaked(UnbakedShape wrapped, String property) implements UnbakedShape
    {
        public static Codec<Unbaked> codec(UnbakedShapeCodec parentCodec) {
            return RecordCodecBuilder.create(instance -> instance.group((App)parentCodec.fieldOf("up").forGetter(Unbaked::wrapped), (App)CustomizationCodecs.strictOptionalField(ExtraCodecs.f_263723_, "property", "facing").forGetter(Unbaked::property)).apply((Applicative)instance, Unbaked::new));
        }

        @Override
        public ShapeGenerator bake(BakingContext context) {
            return DirectionalShape.create(this.wrapped.bake(context), this.property);
        }

        @Override
        public Stream<UnbakedShape> dependencies() {
            return Stream.of(this.wrapped);
        }
    }
}

