/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.behavior.BlockBehaviorRegistry;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.component.LayeredComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;
import snownee.kiwi.util.codec.CustomizationCodecs;

public record ConsumableComponent(IntegerProperty property, Optional<FoodProperties> food, Optional<ResourceKey<ResourceLocation>> stat) implements KBlockComponent,
LayeredComponent
{
    public static final MapCodec<ConsumableComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.m_269197_((int)0, (int)1).fieldOf("min").forGetter(ConsumableComponent::minValue), (App)ExtraCodecs.f_144629_.fieldOf("max").forGetter(ConsumableComponent::maxValue), (App)CustomizationCodecs.FOOD.optionalFieldOf("food").forGetter(ConsumableComponent::food), (App)ResourceKey.m_195966_((ResourceKey)Registries.f_256887_).optionalFieldOf("stat").forGetter(ConsumableComponent::stat)).apply((Applicative)instance, ConsumableComponent::create));

    public static ConsumableComponent create(int min, int max, Optional<FoodProperties> food, Optional<ResourceKey<ResourceLocation>> stat) {
        return new ConsumableComponent(KBlockUtils.internProperty(IntegerProperty.m_61631_((String)"uses", (int)min, (int)max)), food, stat);
    }

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.CONSUMABLE.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.property});
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        return (BlockState)state.m_61124_((Property)this.property, (Comparable)Integer.valueOf(this.getDefaultLayer()));
    }

    public int minValue() {
        return this.property.f_223000_;
    }

    public int maxValue() {
        return this.property.f_223001_;
    }

    @Override
    public boolean hasAnalogOutputSignal() {
        return true;
    }

    @Override
    public int getAnalogOutputSignal(BlockState state) {
        return Math.min((Integer)state.m_61143_((Property)this.property) - this.minValue() + 1, 15);
    }

    @Override
    public void addBehaviors(BlockBehaviorRegistry registry) {
        registry.addUseHandler((pState, pPlayer, pLevel, pHand, pHit) -> {
            int value = (Integer)pState.m_61143_((Property)this.property);
            if (value == 0) {
                return InteractionResult.PASS;
            }
            this.stat.map(ResourceKey::m_135782_).ifPresent(arg_0 -> ((Player)pPlayer).m_36220_(arg_0));
            BlockPos pos = pHit.m_82425_();
            if (this.food.isPresent()) {
                FoodProperties food = this.food.get();
                if (!pPlayer.m_36391_(food.m_38747_())) {
                    return InteractionResult.FAIL;
                }
                Item item = pState.m_60734_().m_5456_();
                pLevel.m_6263_(pPlayer, pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), item.m_6061_(), SoundSource.NEUTRAL, 1.0f, 1.0f + (pLevel.f_46441_.m_188501_() - pLevel.f_46441_.m_188501_()) * 0.4f);
                if (!pLevel.f_46443_) {
                    pPlayer.m_36324_().m_38707_(food.m_38744_(), food.m_38745_());
                    for (Pair pair : food.m_38749_()) {
                        if (pair.getFirst() == null || !(pLevel.f_46441_.m_188501_() < ((Float)pair.getSecond()).floatValue())) continue;
                        pPlayer.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
                    }
                }
                pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157806_, pos);
            }
            if (value == this.minValue()) {
                pLevel.m_7471_(pos, false);
            } else {
                pLevel.m_46597_(pos, (BlockState)pState.m_61124_((Property)this.property, (Comparable)Integer.valueOf(value - 1)));
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        });
    }

    @Override
    public IntegerProperty getLayerProperty() {
        return this.property;
    }

    @Override
    public int getDefaultLayer() {
        return this.maxValue();
    }
}

