/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.data.gen;

import java.util.List;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.item.CRItems;
import net.brdle.collectorsreap.data.gen.CRBlockStateProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.level.block.WallBlock;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.ForgeSpawnEggItem;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class CRItemModelProvider
extends ItemModelProvider {
    public CRItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "collectorsreap", existingFileHelper);
    }

    protected void registerModels() {
        for (RegistryObject entry : CRItems.ITEMS.getEntries()) {
            ResourceLocation id = entry.getId();
            if (entry == CRItems.URCHIN_DART) continue;
            if (!this.isBasic((RegistryObject<Item>)entry)) {
                if (entry.get() instanceof ForgeSpawnEggItem) {
                    this.spawnEgg(id);
                    continue;
                }
                if (entry == CRItems.PORTOBELLO) {
                    this.itemGeneratedModel((Item)CRItems.PORTOBELLO.get(), CRBlockStateProvider.resourceBlock(Util.name(CRItems.PORTOBELLO)));
                    continue;
                }
                if (entry == CRItems.PORTOBELLO_COLONY) {
                    this.itemGeneratedModel((Item)CRItems.PORTOBELLO_COLONY.get(), CRBlockStateProvider.resourceBlock(Util.name(CRItems.PORTOBELLO_COLONY) + "_stage3"));
                    continue;
                }
                Object object = entry.get();
                if (object instanceof BlockItem) {
                    BlockItem b = (BlockItem)object;
                    if (b.m_40614_() instanceof WallBlock) {
                        this.wallInventory(id.m_135815_(), Util.rl(id.m_135827_(), "block/" + id.m_135815_().replace("_wall", "s")));
                        continue;
                    }
                    if (!(entry.get() instanceof ItemNameBlockItem)) {
                        this.withExistingParent(id.m_135815_(), Util.cr("block/" + id.m_135815_()));
                        continue;
                    }
                }
            }
            this.basicItem(id);
        }
    }

    public ItemModelBuilder itemGeneratedModel(Item item, ResourceLocation texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(Util.name(item), "item/generated")).texture("layer0", texture);
    }

    public ItemModelBuilder handheld(ResourceLocation item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.m_135815_(), "item/handheld")).texture("layer0", Util.cr("item/" + item.m_135815_()));
    }

    public ItemModelBuilder spawnEgg(ResourceLocation item) {
        return (ItemModelBuilder)this.withExistingParent(item.m_135815_(), "item/template_spawn_egg");
    }

    private boolean isBasic(RegistryObject<Item> entry) {
        return List.of(CRItems.PORTOBELLO_QUICHE, CRItems.LIME_PIE, CRItems.LIME_CAKE, CRItems.POMEGRANATE_CAKE, CRItems.LIME_SEEDS, CRItems.POMEGRANATE_SEEDS, CRItems.PLATINUM_BASS_ROE, CRItems.TIGER_PRAWN_ROE).contains(entry);
    }
}

