/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.compat;

import java.util.function.Supplier;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.compat.AtmosphericCompat;
import net.brdle.collectorsreap.compat.FarmersRespiteCompat;
import net.brdle.collectorsreap.compat.NeapolitanCompat;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ModCompat {
    @Nullable
    public static CreativeModeTab ifLoaded(String modid, CreativeModeTab tab) {
        return ModCompat.ifLoaded(modid, () -> tab);
    }

    @Nullable
    public static CreativeModeTab ifLoaded(String modid, Supplier<CreativeModeTab> tab) {
        if (ModList.get().isLoaded(modid)) {
            return tab.get();
        }
        return null;
    }

    public static Supplier<MobEffect> getCaffeinated() {
        return ModList.get().isLoaded("farmersrespite") ? FarmersRespiteCompat.CAFFEINATED : () -> MobEffects.f_19604_;
    }

    public static Supplier<MobEffect> getAgility() {
        return ModList.get().isLoaded("neapolitan") ? NeapolitanCompat.AGILITY : () -> MobEffects.f_19604_;
    }

    public static Supplier<MobEffect> getVanillaScent() {
        return ModList.get().isLoaded("neapolitan") ? NeapolitanCompat.VANILLA_SCENT : () -> MobEffects.f_19604_;
    }

    public static Supplier<MobEffect> getSugarRush() {
        return ModList.get().isLoaded("neapolitan") ? NeapolitanCompat.SUGAR_RUSH : () -> MobEffects.f_19604_;
    }

    public static Supplier<MobEffect> getBerserking() {
        return ModList.get().isLoaded("neapolitan") ? NeapolitanCompat.BERSERKING : () -> MobEffects.f_19604_;
    }

    public static Supplier<MobEffect> getHarmony() {
        return ModList.get().isLoaded("neapolitan") ? NeapolitanCompat.HARMONY : () -> MobEffects.f_19604_;
    }

    public static Supplier<MobEffect> getSpitting() {
        return ModList.get().isLoaded("atmospheric") ? AtmosphericCompat.SPITTING : () -> MobEffects.f_19604_;
    }

    public static Supplier<MobEffect> getPersistence() {
        return ModList.get().isLoaded("atmospheric") ? AtmosphericCompat.PERSISTENCE : () -> MobEffects.f_19604_;
    }

    public static Supplier<MobEffect> getRelief() {
        return ModList.get().isLoaded("atmospheric") ? AtmosphericCompat.RELIEF : () -> MobEffects.f_19604_;
    }

    public static Supplier<MobEffect> getStuffed() {
        return ModList.get().isLoaded("seasonals") ? () -> (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(Util.rl("seasonals", "stuffed")) : () -> MobEffects.f_19604_;
    }

    public static Supplier<MobEffect> getThornResistance() {
        return ModList.get().isLoaded("seasonals") ? () -> (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(Util.rl("seasonals", "thorn_resistance")) : () -> MobEffects.f_19607_;
    }

    public static Supplier<MobEffect> getRooted() {
        return ModList.get().isLoaded("seasonals") ? () -> (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(Util.rl("seasonals", "rooted")) : () -> MobEffects.f_19606_;
    }

    public static Supplier<MobEffect> getVitality() {
        return ModList.get().isLoaded("respiteful") ? () -> (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(Util.rl("respiteful", "vitality")) : () -> MobEffects.f_19598_;
    }

    public static Supplier<MobEffect> getTenacity() {
        return ModList.get().isLoaded("respiteful") ? () -> (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(Util.rl("respiteful", "tenacity")) : () -> MobEffects.f_19606_;
    }

    public static Supplier<MobEffect> getMaturity() {
        return ModList.get().isLoaded("respiteful") ? () -> (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(Util.rl("respiteful", "maturity")) : ModCompat.getCaffeinated();
    }
}

