/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.compat;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.registration.IRecipeRegistration;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.config.CRConfig;
import net.brdle.collectorsreap.common.fluid.CRFluids;
import net.brdle.collectorsreap.common.item.CRItems;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = Util.cr("jei_plugin");

    public void registerRecipes(IRecipeRegistration registration) {
        List<ItemStack> items = CRItems.ITEMS.getEntries().stream().filter(Predicate.not(CRConfig::verify)).map(Util::gs).toList();
        if (!items.isEmpty()) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)VanillaTypes.ITEM_STACK, items);
        }
        registration.addItemStackInfo(Util.gs(CRItems.PORTOBELLO), new Component[]{Component.m_237115_((String)("desc.collectorsreap." + Util.name(CRItems.PORTOBELLO)))});
        if (!ModList.get().isLoaded("farmersrespite")) {
            registration.getIngredientManager().removeIngredientsAtRuntime((IIngredientType)ForgeTypes.FLUID_STACK, List.of(new FluidStack((Fluid)CRFluids.LIME_GREEN_TEA.get(), 1000), new FluidStack((Fluid)CRFluids.POMEGRANATE_BLACK_TEA.get(), 1000)));
        }
        String limeTranslationKey = "desc.collectorsreap." + Util.name(CRItems.LIME);
        List<ItemStack> limeStack = List.of(Util.gs(CRItems.LIME), Util.gs(CRItems.LIME_SLICE));
        if (CRConfig.verify(CRItems.LIME) && ((Boolean)CRConfig.LIME_POLLINATION.get()).booleanValue()) {
            registration.addItemStackInfo(limeStack, new Component[]{Component.m_237115_((String)limeTranslationKey), Component.m_237115_((String)(limeTranslationKey + ".pollination"))});
        } else {
            registration.addItemStackInfo(limeStack, new Component[]{Component.m_237115_((String)limeTranslationKey)});
        }
        String pomTranslationKey = "desc.collectorsreap." + Util.name(CRItems.POMEGRANATE);
        List<ItemStack> pomStack = List.of(Util.gs(CRItems.POMEGRANATE), Util.gs(CRItems.POMEGRANATE_SLICE));
        if (CRConfig.verify(CRItems.POMEGRANATE)) {
            if (((Boolean)CRConfig.POMEGRANATE_POLLINATION.get()).booleanValue()) {
                registration.addItemStackInfo(pomStack, new Component[]{Component.m_237115_((String)pomTranslationKey), Component.m_237115_((String)(pomTranslationKey + ".pollination"))});
            } else {
                registration.addItemStackInfo(pomStack, new Component[]{Component.m_237115_((String)pomTranslationKey)});
            }
        }
        String dartTranslationKey = "desc.collectorsreap." + Util.name(CRItems.URCHIN_DART);
        if (CRConfig.verify(CRItems.URCHIN_DART)) {
            registration.addItemStackInfo(Util.gs(CRItems.URCHIN_DART), new Component[]{Component.m_237115_((String)dartTranslationKey)});
        }
        if (ModList.get().isLoaded("mynethersdelight")) {
            if (CRConfig.verify(CRItems.STYGIAN_POMEGRANATE)) {
                registration.addItemStackInfo(Util.gs(CRItems.STYGIAN_POMEGRANATE), new Component[]{Component.m_237115_((String)("desc.collectorsreap." + Util.name(CRItems.STYGIAN_POMEGRANATE)))});
            }
            registration.addItemStackInfo(Util.gs(CRItems.PORTOBELLO_COLONY), new Component[]{Component.m_237115_((String)"mynethersdelight.jei.info.mushroom_colony")});
        }
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

