/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.item.food;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.brdle.collectorsreap.common.item.PearlItem;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ShimmeringAppleItem
extends PearlItem {
    public ShimmeringAppleItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public Rarity m_41460_(@NotNull ItemStack stack) {
        return Rarity.UNCOMMON;
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity) {
        if (!level.m_5776_()) {
            HashMap<MobEffect, MobEffectInstance> active = new HashMap<MobEffect, MobEffectInstance>(entity.m_21221_());
            if (active.isEmpty()) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 400, 1));
            } else {
                RandomSource rand = level.m_213780_();
                ArrayList buffs = new ArrayList();
                ArrayList debuffs = new ArrayList();
                ForgeRegistries.MOB_EFFECTS.getValues().forEach(mobEffect -> {
                    if (!mobEffect.m_8093_()) {
                        if (mobEffect.m_19483_() == MobEffectCategory.BENEFICIAL) {
                            buffs.add(mobEffect);
                        } else if (mobEffect.m_19483_() == MobEffectCategory.HARMFUL) {
                            debuffs.add(mobEffect);
                        }
                    }
                });
                buffs.removeAll(active.keySet().stream().filter(eff -> eff.m_19483_() == MobEffectCategory.BENEFICIAL).toList());
                debuffs.removeAll(active.keySet().stream().filter(eff -> eff.m_19483_() == MobEffectCategory.HARMFUL).toList());
                active.forEach((mobEffect, instance) -> {
                    if (!instance.m_19571_() && !instance.m_267577_() && instance.m_19557_() > 200 && instance.m_19572_() && instance.m_19575_() && !mobEffect.m_8093_()) {
                        List effectList;
                        if (mobEffect.m_19483_() == MobEffectCategory.BENEFICIAL) {
                            effectList = buffs;
                        } else if (mobEffect.m_19483_() == MobEffectCategory.HARMFUL) {
                            effectList = debuffs;
                        } else {
                            return;
                        }
                        if (!effectList.isEmpty()) {
                            MobEffect selectedEffect = (MobEffect)effectList.remove(rand.m_188503_(effectList.size()));
                            int duration = Math.min(instance.m_19557_(), rand.m_216332_(800, 2400));
                            int amp = Math.min(instance.m_19564_(), 2);
                            entity.m_21195_(mobEffect);
                            entity.m_147215_(new MobEffectInstance(selectedEffect, duration, amp), (Entity)entity);
                        }
                    }
                });
            }
        }
        return super.m_5922_(stack, level, entity);
    }
}

