/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.item.food;

import java.util.List;
import joptsimple.internal.Strings;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.item.ConsumableItem;

public class CompatConsumable
extends ConsumableItem {
    private final String[] modid;
    private final float heal;

    public CompatConsumable(Item.Properties properties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip, String ... modid) {
        super(properties, hasFoodEffectTooltip, hasCustomTooltip);
        this.heal = 0.0f;
        this.modid = modid;
    }

    public CompatConsumable(Item.Properties properties, boolean hasFoodEffectTooltip, boolean hasCustomTooltip, float heal, String ... modid) {
        super(properties, hasFoodEffectTooltip, hasCustomTooltip);
        this.heal = heal;
        this.modid = modid;
    }

    public String[] getModid() {
        return this.modid;
    }

    public boolean loaded() {
        for (String mod : this.getModid()) {
            if (!ModList.get().isLoaded(mod)) continue;
            return true;
        }
        return this.getModid().length < 1;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> comps, @NotNull TooltipFlag isAdvanced) {
        if (!this.loaded()) {
            comps.add((Component)Component.m_237115_((String)"tooltip.requires_modid"));
            comps.add((Component)Component.m_237113_((String)Strings.join((String[])this.getModid(), (String)", ")).m_130940_(ChatFormatting.UNDERLINE));
        }
        super.m_7373_(stack, level, comps, isAdvanced);
    }

    public void affectConsumer(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity consumer) {
        super.affectConsumer(stack, level, consumer);
        if (this.loaded() && this.heal > 0.0f) {
            consumer.m_5634_(this.heal);
        }
    }
}

