/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.config;

import java.util.HashMap;
import java.util.Map;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.item.CRItems;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.registries.RegistryObject;

public class CRConfig {
    public static final ForgeConfigSpec COMMON;
    private static final Map<String, ForgeConfigSpec.BooleanValue> ITEMS;
    public static ForgeConfigSpec.BooleanValue LIME_POLLINATION;
    public static ForgeConfigSpec.BooleanValue POMEGRANATE_POLLINATION;
    public static ForgeConfigSpec.BooleanValue FAST_POLLINATE;

    public static boolean verify(String item) {
        return CRConfig.contains(item) && (Boolean)ITEMS.get(item).get() != false;
    }

    public static boolean verify(RegistryObject<Item> item) {
        return CRConfig.verify(item.getId().m_135815_());
    }

    public static boolean verify(Item item) {
        return CRConfig.verify(Util.name(item));
    }

    private static void put(ForgeConfigSpec.Builder builder, String name) {
        ITEMS.put(name, builder.define(name, true));
    }

    private static boolean contains(String item) {
        return ITEMS.containsKey(item);
    }

    static {
        ITEMS = new HashMap<String, ForgeConfigSpec.BooleanValue>();
        ForgeConfigSpec.Builder COMMON_BUILDER = new ForgeConfigSpec.Builder();
        COMMON_BUILDER.comment("Enabled items").push("Items");
        CRItems.ITEMS.getEntries().stream().map(obj -> obj.getId().m_135815_()).sorted().forEach(name -> CRConfig.put(COMMON_BUILDER, name));
        COMMON_BUILDER.pop();
        COMMON_BUILDER.push("Behavior");
        LIME_POLLINATION = COMMON_BUILDER.comment("Whether Lime Bushes require Bee pollination to reach final growth stage.").define("lime_pollination", true);
        POMEGRANATE_POLLINATION = COMMON_BUILDER.comment("Whether Pomegranate Bushes require Bee pollination to reach final growth stage in the Overworld.").define("pomegranate_pollination", true);
        FAST_POLLINATE = COMMON_BUILDER.comment("Whether bee pollination of bushes should occur much quicker (when Bee collides with it) rather than on Bee's AI scheduled timing. Use this if having issues with pollination.").define("fast_pollinate", false);
        COMMON_BUILDER.pop();
        COMMON = COMMON_BUILDER.build();
    }
}

