/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.block;

import net.brdle.collectorsreap.common.block.FruitBushBlock;
import net.brdle.collectorsreap.common.config.CRConfig;
import net.brdle.collectorsreap.common.item.CRItems;
import net.brdle.collectorsreap.data.CRBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.PlantType;
import org.jetbrains.annotations.NotNull;

public class PomegranateBushBlock
extends FruitBushBlock {
    private static final VoxelShape SAPLING_SHAPE = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    private static final VoxelShape MID_GROWTH_SHAPE = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0);
    private static final VoxelShape SHAPE_LOWER = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape SHAPE_UPPER = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public PomegranateBushBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean m_6266_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return state.m_204336_(CRBlockTags.POMEGRANATE_FAST_ON) || super.m_6266_(state, level, pos);
    }

    @Override
    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.NETHER;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        return switch ((Integer)state.m_61143_((Property)AGE)) {
            case 0 -> SAPLING_SHAPE;
            case 1 -> MID_GROWTH_SHAPE;
            default -> state.m_61138_((Property)f_52858_) && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.UPPER ? SHAPE_UPPER : SHAPE_LOWER;
        };
    }

    @Override
    public Item getSeeds() {
        return (Item)CRItems.POMEGRANATE_SEEDS.get();
    }

    @Override
    public Item getFruit() {
        return (Item)CRItems.POMEGRANATE.get();
    }

    @Override
    public ItemStack getSpecialFruit() {
        return new ItemStack((ItemLike)CRItems.STYGIAN_POMEGRANATE.get(), 1);
    }

    @Override
    public int getSpecialChance() {
        return 10;
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if ((Integer)state.m_61143_((Property)AGE) < 4 && state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER) {
            int growthRate;
            int n = growthRate = level.m_8055_(pos.m_7495_()).m_204336_(CRBlockTags.POMEGRANATE_FAST_ON) ? 8 : 12;
            if (level.m_46472_() == Level.f_46429_) {
                growthRate -= 4;
            } else if ((Integer)state.m_61143_((Property)AGE) == 3 && ((Boolean)CRConfig.POMEGRANATE_POLLINATION.get()).booleanValue()) {
                return;
            }
            if (ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(growthRate) == 0 ? 1 : 0) != 0)) {
                this.m_214148_(level, random, pos, state);
                ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    public boolean m_7370_(@NotNull LevelReader pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, boolean pIsClient) {
        return false;
    }

    @Override
    public boolean m_214167_(@NotNull Level pLevel, @NotNull RandomSource pRandom, @NotNull BlockPos pPos, @NotNull BlockState pState) {
        return false;
    }

    public void m_7892_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, @NotNull Entity e) {
        if (!pLevel.m_5776_() && ((Boolean)CRConfig.POMEGRANATE_POLLINATION.get()).booleanValue() && ((Boolean)CRConfig.FAST_POLLINATE.get()).booleanValue() && e instanceof Bee && (Integer)pState.m_61143_((Property)AGE) == 3 && pLevel.m_213780_().m_188503_(150) == 0) {
            this.m_214148_((ServerLevel)pLevel, pLevel.m_213780_(), pPos, pState);
        }
    }

    @NotNull
    public VoxelShape m_5939_(@NotNull BlockState pState, @NotNull BlockGetter pLevel, @NotNull BlockPos pPos, @NotNull CollisionContext pContext) {
        EntityCollisionContext ent;
        if (pContext instanceof EntityCollisionContext && (ent = (EntityCollisionContext)pContext).m_193113_() instanceof Bee && ((Boolean)CRConfig.POMEGRANATE_POLLINATION.get()).booleanValue()) {
            return pState.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER ? Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0) : Shapes.m_83040_();
        }
        return this.m_5940_(pState, pLevel, pPos, pContext);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 0;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 0;
    }
}

