/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.client.model.ClamModel;
import net.brdle.collectorsreap.common.entity.Clam;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class ClamRenderer
extends MobRenderer<Clam, ClamModel> {
    private static final String resource = "clam";
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Util.cr("clam"), "main");
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[4];

    public ClamRenderer(EntityRendererProvider.Context manager) {
        super(manager, (EntityModel)new ClamModel(manager.m_174023_(LAYER_LOCATION)), 0.4f);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull Clam entity) {
        int variant = entity.getVariant();
        if (TEXTURES[variant] == null) {
            ResourceLocation loc = Util.rl("collectorsreap", "textures/entity/clam/clam_" + variant + ".png");
            if (!Minecraft.m_91087_().m_91098_().m_213713_(loc).isPresent()) {
                loc = new ResourceLocation("collectorsreap", "textures/entity/clam/clam_0.png");
            }
            ClamRenderer.TEXTURES[variant] = loc;
            return ClamRenderer.TEXTURES[variant];
        }
        return TEXTURES[variant];
    }

    protected void setupRotations(@NotNull Clam entityLiving, @NotNull PoseStack stack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        super.m_7523_((LivingEntity)entityLiving, stack, pAgeInTicks, pRotationYaw, pPartialTicks);
    }
}

