/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.createfluidstuffs.content.tank;

import com.moepus.createfluidstuffs.content.tank.MultiFluidTankBlockEntity;
import com.moepus.createfluidstuffs.foundation.fluid.SmartMultiFluidTank;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.platform.ForgeCatnipServices;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraftforge.fluids.FluidStack;

public class MultiFluidTankRender
extends SafeBlockEntityRenderer<MultiFluidTankBlockEntity> {
    public MultiFluidTankRender(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(MultiFluidTankBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (!be.isController()) {
            return;
        }
        if (!be.window) {
            return;
        }
        if (be.tankInventory.isEmpty()) {
            return;
        }
        LerpedFloat[] fluidLevel = be.getFluidLevel();
        if (fluidLevel == null) {
            return;
        }
        float capHeight = 0.25f;
        float tankHullWidth = 0.0703125f;
        float minPuddleHeight = 0.0625f;
        float totalHeight = (float)be.height - 2.0f * capHeight - minPuddleHeight;
        SmartMultiFluidTank tank = be.tankInventory;
        if (tank.isEmpty()) {
            return;
        }
        FluidStack[] fluidStacks = tank.getFluids();
        float accheight = 0.0f;
        for (int i = 0; i < fluidStacks.length; ++i) {
            float level;
            FluidStack fluidStack = fluidStacks[i];
            if (fluidStack.isEmpty() || (level = fluidLevel[i].getValue(partialTicks)) < 1.0f / (512.0f * totalHeight)) continue;
            float clampedLevel = Mth.m_14036_((float)(level * totalHeight), (float)0.0f, (float)totalHeight);
            float xMin = tankHullWidth;
            float xMax = xMin + (float)be.width - 2.0f * tankHullWidth;
            float yMin = totalHeight + capHeight + minPuddleHeight - clampedLevel;
            float yMax = yMin + clampedLevel;
            float zMin = tankHullWidth;
            float zMax = zMin + (float)be.width - 2.0f * tankHullWidth;
            ms.m_85836_();
            ms.m_252880_(0.0f, clampedLevel - totalHeight + accheight, 0.0f);
            ForgeCatnipServices.FLUID_RENDERER.renderFluidBox((Object)fluidStack, xMin, yMin, zMin, xMax, yMax, zMax, buffer, ms, light, false, false);
            ms.m_85849_();
            accheight += clampedLevel;
        }
    }

    public boolean shouldRenderOffScreen(MultiFluidTankBlockEntity be) {
        return be.isController();
    }
}

