/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.createfluidstuffs.content.tank;

import com.moepus.createfluidstuffs.api.connectivity.MultiConnectivityHandler;
import com.moepus.createfluidstuffs.content.tank.MultiFluidTankBlock;
import com.moepus.createfluidstuffs.foundation.fluid.SmartMultiFluidTank;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.foundation.blockEntity.IMultiBlockEntityContainer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.createmod.catnip.animation.LerpedFloat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class MultiFluidTankBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation,
IMultiBlockEntityContainer.Fluid {
    private static final int MAX_SIZE = 3;
    private static final int tanks = 8;
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected boolean forceFluidLevelUpdate = true;
    protected SmartMultiFluidTank tankInventory = this.createInventory();
    protected BlockPos controller;
    protected BlockPos lastKnownPos;
    protected boolean updateConnectivity = false;
    public boolean window = true;
    public int luminosity;
    protected int width = 1;
    protected int height = 1;
    private static final int SYNC_RATE = 8;
    protected int syncCooldown;
    protected boolean queuedSync;
    private LerpedFloat[] fluidLevel;

    public MultiFluidTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
        this.refreshCapability();
    }

    protected SmartMultiFluidTank createInventory() {
        return new SmartMultiFluidTank(MultiFluidTankBlockEntity.getCapacityMultiplier(), 8, this::onFluidStackChanged);
    }

    public void updateConnectivity() {
        this.updateConnectivity = false;
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (!this.isController()) {
            return;
        }
        MultiConnectivityHandler.formMulti(this);
    }

    public void tick() {
        super.tick();
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
        if (this.lastKnownPos == null) {
            this.lastKnownPos = this.m_58899_();
        } else if (!this.lastKnownPos.equals((Object)this.f_58858_) && this.f_58858_ != null) {
            this.onPositionChanged();
            return;
        }
        if (this.updateConnectivity) {
            this.updateConnectivity();
        }
        this.chaseFluidLevel();
    }

    void chaseFluidLevel() {
        if (this.fluidLevel == null) {
            return;
        }
        for (int i = 0; i < this.fluidLevel.length; ++i) {
            if (this.fluidLevel[i] == null) continue;
            this.fluidLevel[i].tickChaser();
        }
    }

    void chaseExpFluidLevel() {
        if (this.fluidLevel == null) {
            return;
        }
        for (int i = 0; i < 8; ++i) {
            this.fluidLevel[i].chase((double)this.getFillState(i), 0.5, LerpedFloat.Chaser.EXP);
        }
    }

    void initFluidLevel() {
        this.fluidLevel = new LerpedFloat[8];
        for (int i = 0; i < 8; ++i) {
            this.fluidLevel[i] = LerpedFloat.linear().startWithValue((double)this.getFillState(i));
        }
    }

    void initFluidLevel(boolean force) {
        if (force) {
            this.initFluidLevel();
        } else if (this.fluidLevel == null) {
            this.initFluidLevel();
        }
    }

    public BlockPos getLastKnownPos() {
        return this.lastKnownPos;
    }

    public boolean isController() {
        return this.controller == null || this.f_58858_.m_123341_() == this.controller.m_123341_() && this.f_58858_.m_123342_() == this.controller.m_123342_() && this.f_58858_.m_123343_() == this.controller.m_123343_();
    }

    public void initialize() {
        super.initialize();
        this.sendData();
        if (this.f_58857_.f_46443_) {
            this.invalidateRenderBoundingBox();
        }
    }

    private void onPositionChanged() {
        this.removeController(true);
        this.lastKnownPos = this.f_58858_;
    }

    protected void onFluidStackChanged(FluidStack[] newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        float luminosity_total = 0.0f;
        int tank_total = 0;
        for (int i = 0; i < newFluidStack.length; ++i) {
            if (newFluidStack[i].isEmpty()) continue;
            ++tank_total;
            FluidType attributes = newFluidStack[i].getFluid().getFluidType();
            luminosity_total += (float)attributes.getLightLevel(newFluidStack[i]) / 1.2f;
        }
        int luminosity = tank_total > 0 ? (int)luminosity_total / tank_total : 0;
        int maxY = (int)(this.getFillState() * (float)this.height + 1.0f);
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            boolean isBright;
            boolean bl = isBright = yOffset < maxY;
            int actualLuminosity = isBright ? luminosity : (luminosity > 0 ? 1 : 0);
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    MultiFluidTankBlockEntity tankAt = (MultiFluidTankBlockEntity)((Object)MultiConnectivityHandler.partAt(this.m_58903_(), (BlockGetter)this.f_58857_, pos));
                    if (tankAt == null) continue;
                    this.f_58857_.m_46717_(pos, tankAt.m_58900_().m_60734_());
                    if (tankAt.luminosity == actualLuminosity) continue;
                    tankAt.setLuminosity(actualLuminosity);
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
        if (this.isVirtual()) {
            this.initFluidLevel(false);
            this.chaseExpFluidLevel();
        }
    }

    protected void setLuminosity(int luminosity) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.luminosity == luminosity) {
            return;
        }
        this.luminosity = luminosity;
        this.sendData();
    }

    public MultiFluidTankBlockEntity getControllerBE() {
        if (this.isController()) {
            return this;
        }
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.controller);
        if (blockEntity instanceof MultiFluidTankBlockEntity) {
            return (MultiFluidTankBlockEntity)blockEntity;
        }
        return null;
    }

    public void applyFluidTankSize(int blocks) {
        this.tankInventory.setCapacity(blocks * MultiFluidTankBlockEntity.getCapacityMultiplier());
        int overflow = this.tankInventory.getFluidAmount() - this.tankInventory.getCapacity();
        if (overflow > 0) {
            int drained;
            for (int i = 0; i < 8 && (overflow -= (drained = this.tankInventory.drain(overflow, IFluidHandler.FluidAction.EXECUTE).getAmount())) > 0; ++i) {
            }
        }
        this.forceFluidLevelUpdate = true;
    }

    public void removeController(boolean keepFluids) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.updateConnectivity = true;
        if (!keepFluids) {
            this.applyFluidTankSize(1);
        }
        this.controller = null;
        this.width = 1;
        this.height = 1;
        this.onFluidStackChanged(this.tankInventory.getFluids());
        BlockState state = this.m_58900_();
        if (MultiFluidTankBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)MultiFluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_((Property)MultiFluidTankBlock.TOP, (Comparable)Boolean.valueOf(true));
            state = (BlockState)state.m_61124_(MultiFluidTankBlock.SHAPE, (Comparable)((Object)(this.window ? MultiFluidTankBlock.Shape.WINDOW : MultiFluidTankBlock.Shape.PLAIN)));
            this.m_58904_().m_7731_(this.f_58858_, state, 22);
        }
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    public void toggleWindows() {
        MultiFluidTankBlockEntity be = this.getControllerBE();
        if (be == null) {
            return;
        }
        be.setWindows(!be.window);
    }

    public InteractionResult onCreativeInsertFluid(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        FluidStack fluidInItem = (FluidStack)GenericItemEmptying.emptyItem((Level)this.f_58857_, (ItemStack)stack, (boolean)true).getFirst();
        if (fluidInItem.isEmpty()) {
            return InteractionResult.PASS;
        }
        LazyOptional tankCapability = this.getCapability(ForgeCapabilities.FLUID_HANDLER);
        if (!tankCapability.isPresent()) {
            return InteractionResult.PASS;
        }
        IFluidHandler tank = (IFluidHandler)tankCapability.orElse(null);
        tank.fill(fluidInItem, IFluidHandler.FluidAction.EXECUTE);
        return InteractionResult.SUCCESS;
    }

    public void sendDataImmediately() {
        this.syncCooldown = 0;
        this.queuedSync = false;
        this.sendData();
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        super.sendData();
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void setWindows(boolean window) {
        this.window = window;
        for (int yOffset = 0; yOffset < this.height; ++yOffset) {
            for (int xOffset = 0; xOffset < this.width; ++xOffset) {
                for (int zOffset = 0; zOffset < this.width; ++zOffset) {
                    BlockPos pos = this.f_58858_.m_7918_(xOffset, yOffset, zOffset);
                    BlockState blockState = this.f_58857_.m_8055_(pos);
                    if (!MultiFluidTankBlock.isTank(blockState)) continue;
                    MultiFluidTankBlock.Shape shape = MultiFluidTankBlock.Shape.PLAIN;
                    if (window) {
                        shape = MultiFluidTankBlock.Shape.WINDOW;
                    }
                    this.f_58857_.m_7731_(pos, (BlockState)blockState.m_61124_(MultiFluidTankBlock.SHAPE, (Comparable)((Object)shape)), 22);
                    this.f_58857_.m_7726_().m_7827_().m_7174_(pos);
                }
            }
        }
    }

    public void setController(BlockPos controller) {
        if (this.f_58857_.f_46443_ && !this.isVirtual()) {
            return;
        }
        if (controller.equals((Object)this.controller)) {
            return;
        }
        this.controller = controller;
        this.refreshCapability();
        this.m_6596_();
        this.sendData();
    }

    private void refreshCapability() {
        LazyOptional<IFluidHandler> oldCap = this.fluidCapability;
        this.fluidCapability = LazyOptional.of(() -> this.handlerForCapability());
        oldCap.invalidate();
    }

    private IFluidHandler handlerForCapability() {
        return this.isController() ? this.tankInventory : (this.getControllerBE() != null ? this.getControllerBE().handlerForCapability() : new FluidTank(0));
    }

    public BlockPos getController() {
        return this.isController() ? this.f_58858_ : this.controller;
    }

    protected AABB createRenderBoundingBox() {
        if (this.isController()) {
            return super.createRenderBoundingBox().m_82363_((double)(this.width - 1), (double)(this.height - 1), (double)(this.width - 1));
        }
        return super.createRenderBoundingBox();
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        MultiFluidTankBlockEntity controllerBE = this.getControllerBE();
        if (controllerBE == null) {
            return false;
        }
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, controllerBE.getCapability(ForgeCapabilities.FLUID_HANDLER));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        boolean changeOfController;
        super.read(compound, clientPacket);
        BlockPos controllerBefore = this.controller;
        int prevSize = this.width;
        int prevHeight = this.height;
        int prevLum = this.luminosity;
        this.updateConnectivity = compound.m_128441_("Uninitialized");
        this.luminosity = compound.m_128451_("Luminosity");
        this.controller = null;
        this.lastKnownPos = null;
        if (compound.m_128441_("LastKnownPos")) {
            this.lastKnownPos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("LastKnownPos"));
        }
        if (compound.m_128441_("Controller")) {
            this.controller = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("Controller"));
        }
        if (this.isController()) {
            this.window = compound.m_128471_("Window");
            this.width = compound.m_128451_("Size");
            this.height = compound.m_128451_("Height");
            this.tankInventory.setCapacity(this.getTotalTankSize() * MultiFluidTankBlockEntity.getCapacityMultiplier());
            this.tankInventory.readFromNBT(compound.m_128469_("TankContent"));
            if (this.tankInventory.getSpace() < 0) {
                this.tankInventory.drain(-this.tankInventory.getSpace(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
        if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
            this.initFluidLevel();
        }
        if (!clientPacket) {
            return;
        }
        boolean bl = controllerBefore == null ? this.controller != null : (changeOfController = !controllerBefore.equals((Object)this.controller));
        if (changeOfController || prevSize != this.width || prevHeight != this.height) {
            if (this.m_58898_()) {
                this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 16);
            }
            if (this.isController()) {
                this.tankInventory.setCapacity(MultiFluidTankBlockEntity.getCapacityMultiplier() * this.getTotalTankSize());
            }
            this.invalidateRenderBoundingBox();
        }
        if (this.isController()) {
            float fillState = this.getFillState();
            if (compound.m_128441_("ForceFluidLevel") || this.fluidLevel == null) {
                this.initFluidLevel(true);
            }
            this.chaseExpFluidLevel();
        }
        if (this.luminosity != prevLum && this.m_58898_()) {
            this.f_58857_.m_7726_().m_7827_().m_7174_(this.f_58858_);
        }
        if (compound.m_128441_("LazySync") && this.fluidLevel != null) {
            for (int i = 0; i < 8; ++i) {
                this.fluidLevel[i].chase((double)this.fluidLevel[i].getChaseTarget(), 0.125, LerpedFloat.Chaser.EXP);
            }
        }
    }

    public float getFillState() {
        return (float)this.tankInventory.getFluidAmount() / (float)this.tankInventory.getCapacity();
    }

    public float getFillState(int i) {
        return (float)this.tankInventory.getFluidAmount(i) / (float)this.tankInventory.getCapacity();
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        if (this.updateConnectivity) {
            compound.m_128379_("Uninitialized", true);
        }
        if (this.lastKnownPos != null) {
            compound.m_128365_("LastKnownPos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastKnownPos));
        }
        if (!this.isController()) {
            compound.m_128365_("Controller", (Tag)NbtUtils.m_129224_((BlockPos)this.controller));
        }
        if (this.isController()) {
            compound.m_128379_("Window", this.window);
            compound.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
            compound.m_128405_("Size", this.width);
            compound.m_128405_("Height", this.height);
        }
        compound.m_128405_("Luminosity", this.luminosity);
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        if (this.forceFluidLevelUpdate) {
            compound.m_128379_("ForceFluidLevel", true);
        }
        if (this.queuedSync) {
            compound.m_128379_("LazySync", true);
        }
        this.forceFluidLevelUpdate = false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.fluidCapability.isPresent()) {
            this.refreshCapability();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidate() {
        super.invalidate();
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public int getTotalTankSize() {
        return this.width * this.width * this.height;
    }

    public static int getMaxSize() {
        return 3;
    }

    public static int getCapacityMultiplier() {
        return (Integer)AllConfigs.server().fluids.fluidTankCapacity.get() * 1000;
    }

    public static int getMaxHeight() {
        return (Integer)AllConfigs.server().fluids.fluidTankMaxHeight.get();
    }

    public LerpedFloat[] getFluidLevel() {
        return this.fluidLevel;
    }

    public void preventConnectivityUpdate() {
        this.updateConnectivity = false;
    }

    public void notifyMultiUpdated() {
        BlockState state = this.m_58900_();
        if (MultiFluidTankBlock.isTank(state)) {
            state = (BlockState)state.m_61124_((Property)MultiFluidTankBlock.BOTTOM, (Comparable)Boolean.valueOf(this.getController().m_123342_() == this.m_58899_().m_123342_()));
            state = (BlockState)state.m_61124_((Property)MultiFluidTankBlock.TOP, (Comparable)Boolean.valueOf(this.getController().m_123342_() + this.height - 1 == this.m_58899_().m_123342_()));
            this.f_58857_.m_7731_(this.m_58899_(), state, 6);
        }
        if (this.isController()) {
            this.setWindows(this.window);
        }
        this.onFluidStackChanged(this.tankInventory.getFluids());
        this.m_6596_();
    }

    public void setExtraData(@Nullable Object data) {
        if (data instanceof Boolean) {
            this.window = (Boolean)data;
        }
    }

    @Nullable
    public Object getExtraData() {
        return this.window;
    }

    public Object modifyExtraData(Object data) {
        if (data instanceof Boolean) {
            Boolean windows = (Boolean)data;
            windows = windows | this.window;
            return windows;
        }
        return data;
    }

    public Direction.Axis getMainConnectionAxis() {
        return Direction.Axis.Y;
    }

    public int getMaxLength(Direction.Axis longAxis, int width) {
        if (longAxis == Direction.Axis.Y) {
            return MultiFluidTankBlockEntity.getMaxHeight();
        }
        return this.getMaxWidth();
    }

    public int getMaxWidth() {
        return 3;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public boolean hasTank() {
        return true;
    }

    public int getTankSize(int tank) {
        return MultiFluidTankBlockEntity.getCapacityMultiplier();
    }

    public void setTankSize(int tank, int blocks) {
        this.applyFluidTankSize(blocks);
    }

    public IFluidTank getTank(int tank) {
        return this.tankInventory;
    }

    public FluidStack getFluid(int tank) {
        return this.tankInventory.getFluid().copy();
    }
}

