/*
 * Decompiled with CFR 0.152.
 */
package com.spaceagle17.iris_shader_folder.mixin;

import com.spaceagle17.iris_shader_folder.IrisShaderFolder;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class IrisShaderFolderMixinPlugin
implements IMixinConfigPlugin {
    public static final String LEGACY_IRIS_CLASS = "net.coderbot.iris.gui.element.ShaderPackSelectionList";
    public static final String MODERN_IRIS_CLASS = "net.irisshaders.iris.gui.element.ShaderPackSelectionList";

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (mixinClassName.contains("IrisLegacyHideShaderPacksMixin")) {
            if (IrisShaderFolder.debugLoggingEnabled) {
                IrisShaderFolder.LOGGER.info("Checking for legacy Iris class: net.coderbot.iris.gui.element.ShaderPackSelectionList");
            }
            return this.checkClassExists(LEGACY_IRIS_CLASS);
        }
        if (mixinClassName.contains("IrisModernHideShaderPacksMixin")) {
            if (IrisShaderFolder.debugLoggingEnabled) {
                IrisShaderFolder.LOGGER.info("Checking for modern Iris class: net.irisshaders.iris.gui.element.ShaderPackSelectionList");
            }
            return this.checkClassExists(MODERN_IRIS_CLASS);
        }
        return true;
    }

    private boolean checkClassExists(String className) {
        boolean isPresent;
        String resourceName = className.replace('.', '/') + ".class";
        boolean bl = isPresent = this.getClass().getClassLoader().getResource(resourceName) != null;
        if (IrisShaderFolder.debugLoggingEnabled) {
            if (isPresent) {
                IrisShaderFolder.LOGGER.info("Found class: " + className);
            } else {
                IrisShaderFolder.LOGGER.info("Class not found: " + className);
            }
        }
        return isPresent;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

