/*
 * Decompiled with CFR 0.152.
 */
package com.spaceagle17.iris_shader_folder;

import com.spaceagle17.iris_shader_folder.ConfigManager;
import com.spaceagle17.iris_shader_folder.IrisShaderFolder;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ShaderFilterSystem {
    private static ShaderFilterSystem INSTANCE;
    private static final String DEBUG_FILE = "config/iris_shader_filter_debug.txt";
    private List<Pattern> compiledPatterns = new ArrayList<Pattern>();
    private List<String> lastFilterPatterns = new ArrayList<String>();
    private boolean lastDebugLogSetting = false;

    private ShaderFilterSystem() {
        this.updatePatterns();
    }

    public static ShaderFilterSystem getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ShaderFilterSystem();
        }
        return INSTANCE;
    }

    private void writeDebug(String message, boolean append) {
        if (!IrisShaderFolder.debugLoggingEnabled) {
            return;
        }
        try (FileWriter debugWriter = new FileWriter(DEBUG_FILE, append);){
            debugWriter.write(message);
        }
        catch (IOException e) {
            IrisShaderFolder.LOGGER.error("Failed to write debug info", (Throwable)e);
        }
    }

    public void updatePatterns() {
        List<String> filterPatterns = IrisShaderFolder.filterPatterns;
        boolean debugLogging = IrisShaderFolder.debugLoggingEnabled;
        if (filterPatterns.equals(this.lastFilterPatterns) && debugLogging == this.lastDebugLogSetting) {
            return;
        }
        this.lastFilterPatterns = new ArrayList<String>(filterPatterns);
        this.lastDebugLogSetting = debugLogging;
        StringBuilder debugContent = new StringBuilder();
        debugContent.append("Filter patterns (").append(filterPatterns.size()).append("):\n");
        for (String pattern : filterPatterns) {
            debugContent.append("  - '").append(pattern).append("'\n");
        }
        debugContent.append("\n");
        if (debugLogging) {
            this.writeDebug(debugContent.toString(), false);
        }
        this.compiledPatterns.clear();
        for (String pattern : filterPatterns) {
            if ((pattern = pattern.trim()).isEmpty() || pattern.startsWith("#")) continue;
            try {
                debugContent = new StringBuilder();
                if (debugLogging) {
                    debugContent.append("Processing pattern: '").append(pattern).append("'\n");
                }
                String regexPattern = this.convertToRegex(pattern);
                if (debugLogging) {
                    debugContent.append("  \u2192 Converted to regex: '").append(regexPattern).append("'\n");
                }
                String finalPattern = "^" + regexPattern + "(\\.zip)?$";
                if (debugLogging) {
                    debugContent.append("  \u2192 Final pattern: '").append(finalPattern).append("'\n\n");
                    this.writeDebug(debugContent.toString(), true);
                }
                if (debugLogging) {
                    IrisShaderFolder.LOGGER.info("Creating pattern: " + finalPattern);
                }
                this.compiledPatterns.add(Pattern.compile(finalPattern, 2));
            }
            catch (PatternSyntaxException e) {
                String errorMsg = "Invalid filter pattern: " + pattern + " - " + e.getMessage();
                IrisShaderFolder.LOGGER.error(errorMsg);
                if (!debugLogging) continue;
                this.writeDebug("ERROR: " + errorMsg + "\n", true);
            }
        }
    }

    private String convertToRegex(String pattern) {
        StringBuilder result = new StringBuilder();
        int currentPos = 0;
        while (currentPos < pattern.length()) {
            int closeBrace;
            int openBrace = pattern.indexOf(123, currentPos);
            if (openBrace == -1) {
                result.append(Pattern.quote(pattern.substring(currentPos)));
                break;
            }
            if (openBrace > currentPos) {
                result.append(Pattern.quote(pattern.substring(currentPos, openBrace)));
            }
            if ((closeBrace = this.findMatchingCloseBrace(pattern, openBrace)) == -1) {
                result.append(Pattern.quote(pattern.substring(currentPos)));
                break;
            }
            String braceContent = pattern.substring(openBrace + 1, closeBrace);
            if ("version".equals(braceContent)) {
                result.append("\\d+(\\.\\d+)*");
            } else {
                result.append(braceContent);
            }
            currentPos = closeBrace + 1;
        }
        return result.toString();
    }

    private int findMatchingCloseBrace(String text, int openBracePos) {
        int depth = 1;
        for (int i = openBracePos + 1; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '{') {
                ++depth;
                continue;
            }
            if (c != '}' || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    public boolean shouldFilterShaderPack(String packName) {
        if (ConfigManager.checkForUpdates()) {
            this.updatePatterns();
        }
        for (Pattern pattern : this.compiledPatterns) {
            if (!pattern.matcher(packName).matches()) continue;
            if (IrisShaderFolder.debugLoggingEnabled) {
                IrisShaderFolder.LOGGER.info("Filtering out shader pack: " + packName);
                this.writeDebug("Filtering out shader pack: " + packName + "\n", true);
            }
            return false;
        }
        return true;
    }

    public boolean matchesPattern(String packName, String patternStr) {
        if (patternStr.trim().isEmpty() || patternStr.startsWith("#")) {
            return false;
        }
        try {
            String regexPattern = this.convertToRegex(patternStr);
            String finalPattern = "^" + regexPattern + "(\\.zip)?$";
            Pattern pattern = Pattern.compile(finalPattern, 2);
            Matcher matcher = pattern.matcher(packName);
            return matcher.matches();
        }
        catch (PatternSyntaxException e) {
            String errorMsg = "Invalid pattern: " + patternStr + " - " + e.getMessage();
            IrisShaderFolder.LOGGER.error(errorMsg);
            if (IrisShaderFolder.debugLoggingEnabled) {
                this.writeDebug("ERROR: " + errorMsg + "\n", true);
            }
            return false;
        }
    }
}

