/*
 * Decompiled with CFR 0.152.
 */
package com.spaceagle17.iris_shader_folder;

import com.spaceagle17.iris_shader_folder.ConfigManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="iris_shader_folder")
public class IrisShaderFolder {
    public static final String MOD_ID = "iris_shader_folder";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"iris_shader_folder");
    public static final String VERSION = "1.1.1";
    public static Path shaderpacks = FMLPaths.GAMEDIR.get().resolve("shaderpacks");
    private static IrisShaderFolder INSTANCE;
    public static boolean debugLoggingEnabled;
    public static List<String> filterPatterns;
    public static List<String> reorderPatterns;

    public static IrisShaderFolder getInstance() {
        return INSTANCE;
    }

    public void loadConfigOptions() {
        String defaultContent;
        debugLoggingEnabled = Boolean.parseBoolean(ConfigManager.readWriteConfig("debugLogging", "false", "Enable debug logging (creates a debug file with detailed pattern processing)"));
        if (ConfigManager.getSectionItems("filter").isEmpty()) {
            String filterDescription = "List of shader patterns to filter out, one per line\nExamples:\n  - Exact Match: Test (only \"Test\" will be filtered)\n  - With version placeholder: ComplementaryReimagined_r{version}\n  - With regex: Complementary{.*}\n{version} matches any version number pattern like 1.2.3 or 4.5\nOther {xyz} are treated as regex patterns (very powerful, be careful!)\n.zip extensions are handled automatically\n";
            defaultContent = "# Add filter patterns here, one per line\n# test\n# Complementary\n# BSL{.*}";
            ConfigManager.writeSection("filter", defaultContent, filterDescription);
        }
        filterPatterns = ConfigManager.getSectionItems("filter");
        if (ConfigManager.getSectionItems("reorder").isEmpty()) {
            String reorderDescription = "List of shaderpacks to reorder in the shaderpacks selection menu, one per line\nThe position is determined by line order (first line = position 1, etc.)\nExamples:\n  - First position: {.*}EuphoriaPatches{.*}\n  - Second position: Complementary{.*}_r{version}\n  - Third position: BSL{.*}\nIf multiple shaderpacks match a pattern, they are inserted at the given position, sorted alphabetically.\n{version} matches any version number pattern like 1.2.3 or 4.5\nOther {xyz} are treated as regex patterns (very powerful, be careful!)\n.zip extensions are handled automatically\n";
            defaultContent = "# Add reorder patterns here, one per line\n# {.*}EuphoriaPatches{.*}\n# Complementary{.*}_r{version}\n# BSL{.*}";
            ConfigManager.writeSection("reorder", defaultContent, reorderDescription);
        }
        reorderPatterns = ConfigManager.getSectionItems("reorder");
    }

    public List<String> getFilterPatterns() {
        return filterPatterns;
    }

    public List<String> getReorderPatterns() {
        return reorderPatterns;
    }

    public IrisShaderFolder() {
        INSTANCE = this;
        ConfigManager.loadProperties();
        this.loadConfigOptions();
        ConfigManager.startConfigWatcher();
        LOGGER.info("Hello from Iris Shader Folder Mod v1.1.1");
    }

    public static boolean isSpacEagle() {
        try {
            boolean containsSpacEagle = shaderpacks.toString().contains("SpacEagle");
            Path euphoriaFolder = shaderpacks.resolve("Euphoria-Patches");
            boolean hasEuphoriaFolder = Files.exists(euphoriaFolder, new LinkOption[0]) && Files.isDirectory(euphoriaFolder, new LinkOption[0]);
            return containsSpacEagle && hasEuphoriaFolder;
        }
        catch (Exception ignored) {
            return false;
        }
    }

    static {
        debugLoggingEnabled = false;
        filterPatterns = new ArrayList<String>();
        reorderPatterns = new ArrayList<String>();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                ConfigManager.stopConfigWatcher();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
    }
}

