/*
 * Decompiled with CFR 0.152.
 */
package com.spaceagle17.iris_shader_folder;

import com.spaceagle17.iris_shader_folder.IrisShaderFolder;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ConfigManager {
    private static final String CONFIG_FILENAME = "iris_shader_folder.properties";
    private static final Path CONFIG_PATH = Paths.get("config", "iris_shader_folder.properties");
    private static final Properties properties = new Properties();
    private static FileTime lastModified = null;
    private static boolean watcherActive = false;
    private static ScheduledExecutorService scheduler;

    private static void debugLog(String message) {
        if (IrisShaderFolder.debugLoggingEnabled) {
            IrisShaderFolder.LOGGER.info("[Config] " + message);
        }
    }

    public static void createConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.createFile(CONFIG_PATH, new FileAttribute[0]);
            ConfigManager.writeInitialConfig();
            IrisShaderFolder.LOGGER.info("Successfully created config file");
        }
        catch (IOException e) {
            IrisShaderFolder.LOGGER.error("Error creating config file: " + e.getMessage());
        }
    }

    private static void writeInitialConfig() throws IOException {
        try (FileWriter writer = new FileWriter(CONFIG_PATH.toString(), false);){
            writer.write("# Iris Shader Folder - Configuration File\n");
            writer.write("# Made for version 1.1.1\n");
            writer.write("# Thank you for using Iris Shader Folder\n");
        }
    }

    public static void updateVersionLine() {
        try {
            int headerIndex;
            List<String> lines = Files.readAllLines(CONFIG_PATH, StandardCharsets.UTF_8);
            boolean versionLineFound = false;
            for (int i = 0; i < lines.size(); ++i) {
                if (!lines.get(i).startsWith("# Made for version")) continue;
                if (lines.get(i).contains("1.1.1")) {
                    return;
                }
                lines.set(i, "# Made for version 1.1.1");
                versionLineFound = true;
                break;
            }
            if (!versionLineFound && (headerIndex = lines.indexOf("# Iris Shader Folder - Configuration File")) >= 0) {
                lines.add(headerIndex + 1, "# Made for version 1.1.1");
            }
            Files.write(CONFIG_PATH, lines, StandardCharsets.UTF_8, new OpenOption[0]);
            ConfigManager.debugLog("Successfully updated version info in config file");
        }
        catch (IOException e) {
            IrisShaderFolder.LOGGER.error("Error updating config file with version: " + e.getMessage());
        }
    }

    public static void writeConfig(String option, String value, String description) {
        block12: {
            try {
                if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    ConfigManager.createConfig();
                } else {
                    ConfigManager.updateVersionLine();
                }
                ConfigManager.loadProperties();
                if (properties.containsKey(option)) break block12;
                List<String> lines = Files.readAllLines(CONFIG_PATH, StandardCharsets.UTF_8);
                try (FileWriter writer = new FileWriter(CONFIG_PATH.toString(), false);){
                    for (String line : lines) {
                        writer.write(line + "\n");
                    }
                    writer.write("\n");
                    if (description != null) {
                        String[] descLines;
                        for (String line : descLines = description.split("\n")) {
                            writer.write("# " + line + "\n");
                        }
                    }
                    writer.write(option + "=" + value + "\n");
                    ConfigManager.debugLog("Successfully wrote to config file: " + option + "=" + value);
                }
            }
            catch (IOException e) {
                IrisShaderFolder.LOGGER.error("Error writing to config file: " + e.getMessage());
            }
        }
    }

    public static String readWriteConfig(String optionName, String defaultValue, String description) {
        ConfigManager.writeConfig(optionName, defaultValue, description);
        return properties.getProperty(optionName, defaultValue);
    }

    public static void loadProperties() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                ConfigManager.createConfig();
                return;
            }
            try (InputStream in = Files.newInputStream(CONFIG_PATH, new OpenOption[0]);){
                properties.clear();
                properties.load(in);
                lastModified = Files.getLastModifiedTime(CONFIG_PATH, new LinkOption[0]);
            }
        }
        catch (IOException e) {
            IrisShaderFolder.LOGGER.error("Error loading properties: " + e.getMessage());
        }
    }

    public static void writeSection(String sectionName, String content, String description) {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                ConfigManager.createConfig();
            }
            List<String> lines = Files.readAllLines(CONFIG_PATH, StandardCharsets.UTF_8);
            String startMarker = sectionName + "Start:[";
            String endMarker = "]:" + sectionName + "End";
            int startIndex = -1;
            int endIndex = -1;
            for (int i = 0; i < lines.size(); ++i) {
                if (lines.get(i).trim().equals(startMarker)) {
                    startIndex = i;
                    continue;
                }
                if (!lines.get(i).trim().equals(endMarker) || startIndex == -1) continue;
                endIndex = i;
                break;
            }
            if (startIndex != -1 && endIndex != -1) {
                StringBuilder existingContent = new StringBuilder();
                for (int i = startIndex + 1; i < endIndex; ++i) {
                    if (existingContent.length() > 0) {
                        existingContent.append("\n");
                    }
                    existingContent.append(lines.get(i));
                }
                if (existingContent.toString().equals(String.join((CharSequence)"\n", content.split("\n")))) {
                    return;
                }
            }
            ArrayList<Object> newLines = new ArrayList<Object>();
            if (startIndex != -1 && endIndex != -1) {
                newLines.addAll(lines.subList(0, startIndex));
                newLines.add(startMarker);
                for (String line : content.split("\n")) {
                    newLines.add(line);
                }
                newLines.add(endMarker);
                if (endIndex + 1 < lines.size()) {
                    newLines.addAll(lines.subList(endIndex + 1, lines.size()));
                }
            } else {
                newLines.addAll(lines);
                if (newLines.size() > 0 && !((String)newLines.get(newLines.size() - 1)).trim().isEmpty()) {
                    newLines.add("");
                }
                newLines.add("#--------------------------------------------------------------------------------");
                if (description != null) {
                    for (String line : description.split("\n")) {
                        newLines.add("# " + line);
                    }
                    newLines.add("");
                }
                newLines.add(startMarker);
                for (String line : content.split("\n")) {
                    newLines.add(line);
                }
                newLines.add(endMarker);
            }
            Files.write(CONFIG_PATH, newLines, StandardCharsets.UTF_8, new OpenOption[0]);
            lastModified = Files.getLastModifiedTime(CONFIG_PATH, new LinkOption[0]);
            ConfigManager.debugLog("Successfully wrote section: " + sectionName);
        }
        catch (IOException e) {
            IrisShaderFolder.LOGGER.error("Error writing section to config: " + e.getMessage());
        }
    }

    public static String readSection(String sectionName) {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                return "";
            }
            List<String> lines = Files.readAllLines(CONFIG_PATH, StandardCharsets.UTF_8);
            String startMarker = sectionName + "Start:[";
            String endMarker = "]:" + sectionName + "End";
            boolean inSection = false;
            StringBuilder content = new StringBuilder();
            for (String line : lines) {
                if ((line = line.trim()).equals(startMarker)) {
                    inSection = true;
                    continue;
                }
                if (line.equals(endMarker)) {
                    inSection = false;
                    continue;
                }
                if (!inSection) continue;
                if (content.length() > 0) {
                    content.append("\n");
                }
                content.append(line);
            }
            return content.toString();
        }
        catch (IOException e) {
            IrisShaderFolder.LOGGER.error("Error reading section from config: " + e.getMessage());
            return "";
        }
    }

    public static List<String> getSectionItems(String sectionName) {
        String sectionContent = ConfigManager.readSection(sectionName);
        ArrayList<String> items = new ArrayList<String>();
        for (String line : sectionContent.split("\n")) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            items.add(line);
        }
        return items;
    }

    public static void startConfigWatcher() {
        if (watcherActive) {
            return;
        }
        watcherActive = true;
        scheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, "IrisShaderFolderConfigWatcher");
            thread.setDaemon(true);
            return thread;
        });
        scheduler.scheduleAtFixedRate(() -> {
            try {
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    FileTime currentModified = Files.getLastModifiedTime(CONFIG_PATH, new LinkOption[0]);
                    if (lastModified == null || !currentModified.equals(lastModified)) {
                        ConfigManager.debugLog("Config file changed, reloading settings");
                        ConfigManager.loadProperties();
                        IrisShaderFolder instance = IrisShaderFolder.getInstance();
                        if (instance != null) {
                            instance.loadConfigOptions();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public static void stopConfigWatcher() {
        if (watcherActive && scheduler != null) {
            scheduler.shutdown();
            watcherActive = false;
        }
    }

    public static boolean checkForUpdates() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                FileTime currentModified = Files.getLastModifiedTime(CONFIG_PATH, new LinkOption[0]);
                if (lastModified == null || !currentModified.equals(lastModified)) {
                    ConfigManager.loadProperties();
                    IrisShaderFolder instance = IrisShaderFolder.getInstance();
                    if (instance != null) {
                        instance.loadConfigOptions();
                    }
                    return true;
                }
            }
        }
        catch (IOException e) {
            IrisShaderFolder.LOGGER.error("Error checking for config updates: " + e.getMessage());
        }
        return false;
    }
}

