/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.taczaddon.network;

import com.mafuyu404.taczaddon.compat.SophisticatedBackpacksCompat;
import com.mafuyu404.taczaddon.init.ContainerMaster;
import com.mafuyu404.taczaddon.init.NetworkHandler;
import com.mafuyu404.taczaddon.network.ContainerReaderPacket;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ContainerPositionPacket {
    private final BlockPos blockPos;

    public ContainerPositionPacket(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public static void encode(ContainerPositionPacket msg, FriendlyByteBuf buffer) {
        buffer.m_130064_(msg.blockPos);
    }

    public static ContainerPositionPacket decode(FriendlyByteBuf buffer) {
        return new ContainerPositionPacket(buffer.m_130135_());
    }

    public static void handle(ContainerPositionPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            StringBuilder Cpos = new StringBuilder();
            StringBuilder Bpos = new StringBuilder();
            for (int x = msg.blockPos.m_123341_() - 2; x <= msg.blockPos.m_123341_() + 2; ++x) {
                for (int y = msg.blockPos.m_123342_() - 1; y <= msg.blockPos.m_123342_() + 1; ++y) {
                    for (int z = msg.blockPos.m_123343_() - 2; z <= msg.blockPos.m_123343_() + 2; ++z) {
                        BlockPos blockPos = new BlockPos(x, y, z);
                        ArrayList<ItemStack> containerContent = ContainerMaster.readContainerFromPos(player.m_9236_(), blockPos);
                        Matcher matcher = Pattern.compile("(.*backpack.*){2,}").matcher(player.m_9236_().m_8055_(blockPos).m_60734_().m_7705_());
                        if (matcher.matches()) {
                            ArrayList<ItemStack> backpack = SophisticatedBackpacksCompat.getItemsFromBackpackBLock(blockPos, (Player)player);
                            items.addAll(backpack);
                            Bpos.append(String.format("%s,%s,%s;", x, y, z));
                        }
                        if (containerContent.isEmpty()) continue;
                        items.addAll(containerContent);
                        Cpos.append(String.format("%s,%s,%s;", x, y, z));
                    }
                }
            }
            if (player != null) {
                System.out.print(Bpos + "\n");
                if (!Cpos.isEmpty()) {
                    player.getPersistentData().m_128359_("BetterGunSmithTable.nearbyContainerPos", Cpos.toString());
                }
                if (!Bpos.isEmpty()) {
                    player.getPersistentData().m_128359_("BetterGunSmithTable.nearbyBackpackPos", Bpos.toString());
                }
            }
            NetworkHandler.sendToClient(player, new ContainerReaderPacket(items));
        });
        ctx.get().setPacketHandled(true);
    }
}

