/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.taczaddon.network;

import com.mafuyu404.taczaddon.init.DataStorage;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class BackpackItemsPacket {
    private final ArrayList<ItemStack> backpack;
    private final String contentsUuid;

    public BackpackItemsPacket(String contentsUuid, ArrayList<ItemStack> backpack) {
        this.contentsUuid = contentsUuid;
        this.backpack = backpack;
    }

    public static void encode(BackpackItemsPacket msg, FriendlyByteBuf buffer) {
        int size = msg.backpack.size();
        buffer.ensureWritable(size * 2);
        buffer.writeInt(size);
        msg.backpack.forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130055_(arg_0));
        buffer.m_130070_(msg.contentsUuid);
    }

    public static BackpackItemsPacket decode(FriendlyByteBuf buffer) {
        ArrayList<ItemStack> backpack = new ArrayList<ItemStack>();
        long size = buffer.readInt();
        int i = 0;
        while ((long)i < size) {
            backpack.add(buffer.m_130267_());
            ++i;
        }
        return new BackpackItemsPacket(buffer.m_130277_(), backpack);
    }

    public static void handle(BackpackItemsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DataStorage.setBackpack(msg.contentsUuid, msg.backpack));
        ctx.get().setPacketHandled(true);
    }
}

