/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.taczaddon.mixin;

import com.mafuyu404.taczaddon.init.Config;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.client.tooltip.ClientAttachmentItemTooltip;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AllowAttachmentTagMatcher;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientAttachmentItemTooltip.class}, remap=false)
public class ClientAttachmentItemTooltipMixin {
    @Shadow
    @Final
    private ResourceLocation attachmentId;

    @Inject(method={"getAllAllowGuns"}, at={@At(value="RETURN")}, cancellable=true)
    private static void modifyShowAllowGun(List<ItemStack> output, ResourceLocation attachmentId, CallbackInfoReturnable<List<ItemStack>> cir) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        int amount = Config.getAllowGunAmount();
        for (int i = 0; i < Math.min(amount, output.size()); ++i) {
            result.add(output.get(i).m_41777_());
        }
        cir.setReturnValue(result);
    }

    @Redirect(method={"lambda$addText$4"}, at=@At(value="INVOKE", target="Lcom/tacz/guns/api/modifier/JsonProperty;getComponents()Ljava/util/List;"))
    private List<Component> modifyAttachmentDetail(JsonProperty<?> value) {
        if (!((Boolean)Config.SHOW_ATTACHMENT_ATTRIBUTE.get()).booleanValue()) {
            return value.getComponents();
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return value.getComponents();
        }
        ItemStack gunItem = player.m_21205_().m_41777_();
        IGun iGun = IGun.getIGunOrNull((ItemStack)gunItem);
        if (iGun == null) {
            return value.getComponents();
        }
        boolean allowAttachment = AllowAttachmentTagMatcher.match((ResourceLocation)iGun.getGunId(gunItem), (ResourceLocation)this.attachmentId);
        if (!allowAttachment) {
            return value.getComponents();
        }
        ItemStack attachmentItem = AttachmentItemBuilder.create().setId(this.attachmentId).build();
        IAttachment iAttachment = IAttachment.getIAttachmentOrNull((ItemStack)attachmentItem);
        if (iAttachment == null) {
            return value.getComponents();
        }
        AttachmentType attachmentType = iAttachment.getType(attachmentItem);
        ArrayList<Component> result = new ArrayList<Component>();
        ResourceLocation gunId = iGun.getGunId(gunItem);
        HashMap attr = new HashMap();
        HashMap originAttr = new HashMap();
        HashMap<String, Double> newAttr = new HashMap<String, Double>();
        HashMap defaultAttr = new HashMap();
        TimelessAPI.getCommonGunIndex((ResourceLocation)gunId).ifPresent(i -> {
            GunData gunData = i.getGunData();
            ItemStack attachmentTypeItem = iGun.getAttachment(gunItem, attachmentType);
            if (!attachmentTypeItem.m_41619_()) {
                iGun.unloadAttachment(gunItem, attachmentType);
            }
            AttachmentCacheProperty cacheProperty = new AttachmentCacheProperty();
            cacheProperty.eval(gunItem, gunData);
            AttachmentPropertyManager.getModifiers().forEach((key, Modifier) -> Modifier.getPropertyDiagramsData(gunItem, gunData, cacheProperty).forEach(diagramsData -> originAttr.putAll(this.handleData((IAttachmentModifier.DiagramsData)diagramsData))));
            iGun.installAttachment(gunItem, attachmentItem);
            cacheProperty.eval(gunItem, gunData);
            AttachmentPropertyManager.getModifiers().forEach((key, Modifier) -> Modifier.getPropertyDiagramsData(gunItem, gunData, cacheProperty).forEach(diagramsData -> {
                defaultAttr.put(diagramsData.titleKey().split("\\.")[4], this.extractValue(diagramsData.defaultString()));
                newAttr.putAll(this.handleData((IAttachmentModifier.DiagramsData)diagramsData));
            }));
        });
        newAttr.forEach((titleKey, newVal) -> {
            if (originAttr.containsKey(titleKey)) {
                double originVal = (Double)originAttr.get(titleKey);
                double offset = newVal - originVal;
                double defaultValue = (Double)defaultAttr.get(titleKey);
                Object remark = "";
                if (offset > 0.0) {
                    remark = (String)remark + "+";
                }
                remark = (String)remark + (double)Math.round(offset * 100.0) / 100.0;
                if (titleKey.equals("weight")) {
                    remark = (String)remark + "kg";
                }
                if (titleKey.equals("ads") || titleKey.contains("time")) {
                    remark = (String)remark + "s";
                }
                if (titleKey.equals("aim_inaccuracy") || titleKey.equals("armor_ignore")) {
                    remark = (String)remark + "%";
                }
                if (titleKey.equals("rpm")) {
                    remark = (String)remark + "rpm";
                }
                if (titleKey.equals("effective_range")) {
                    remark = (String)remark + "m";
                }
                if (titleKey.contains("ammo_speed")) {
                    remark = (String)remark + "m/s";
                }
                remark = (String)remark + " (" + (offset > 0.0 ? "+" : "") + Math.ceil(offset / defaultValue * 100.0) + "%)";
                attr.put(titleKey, remark);
            }
        });
        value.getComponents().forEach(component -> {
            String translationKey = ClientAttachmentItemTooltipMixin.getTranslationKey(component);
            if (translationKey == null) {
                return;
            }
            String titleKey = translationKey.split("\\.")[3];
            if (titleKey.equals("inaccuracy")) {
                titleKey = "hipfire_inaccuracy";
            }
            String title = titleKey.equals("hipfire_inaccuracy") ? Component.m_237115_((String)"gui.tacz.gun_refit.property_diagrams.hipfire_inaccuracy").getString() : component.getString().replace("+ ", "").replace("- ", "");
            String remark = attr.containsKey(titleKey) ? (String)attr.get(titleKey) : component.getString().split(" ")[0];
            String text = title + " " + remark;
            text = component.m_7383_().m_131135_().toString().equals("red") ? "\u00a7c" + text : "\u00a7a" + text;
            result.add((Component)Component.m_237115_((String)text));
        });
        return result;
    }

    private HashMap<String, Double> handleData(IAttachmentModifier.DiagramsData diagramsData) {
        String titleKey = diagramsData.titleKey();
        String positivelyString = diagramsData.positivelyString();
        String negativeString = diagramsData.negativeString();
        String text = !positivelyString.split(" ")[1].contains("+-") ? positivelyString : negativeString;
        HashMap<String, Double> result = new HashMap<String, Double>();
        result.put(titleKey.split("\\.")[4], this.extractValue(text));
        return result;
    }

    private double extractValue(String text) {
        String pattern = "[-+]?\\d+(?:\\.\\d+)?";
        Matcher matcher = Pattern.compile(pattern).matcher(text);
        double val = 0.0;
        while (matcher.find()) {
            val = Double.parseDouble(matcher.group());
        }
        return val;
    }

    private static String getTranslationKey(Component component) {
        ComponentContents contents = component.m_214077_();
        if (contents instanceof TranslatableContents) {
            TranslatableContents translatable = (TranslatableContents)contents;
            return translatable.m_237508_();
        }
        return null;
    }
}

