/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.renderjs.painter;

import com.chen1335.renderjs.painter.IRenderJSPainterObject;
import dev.latvian.mods.kubejs.client.painter.Painter;
import dev.latvian.mods.kubejs.client.painter.screen.ScreenPainterObject;
import dev.latvian.mods.rhino.util.HideFromJS;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="renderjs", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RenderJSPainter {
    @HideFromJS
    @SubscribeEvent
    public static void renderGuiPre(RenderGuiEvent.Pre event) {
        RenderJSPainter.render(event.getGuiGraphics(), Layer.hud, Step.belowAll);
    }

    @HideFromJS
    @SubscribeEvent
    public static void renderGuiPost(RenderGuiEvent.Post event) {
        RenderJSPainter.render(event.getGuiGraphics(), Layer.hud, Step.aboveAll);
    }

    @HideFromJS
    @SubscribeEvent
    public static void renderScreenPre(ScreenEvent.Render.Pre event) {
        RenderJSPainter.render(event.getGuiGraphics(), Layer.screen, Step.belowAll);
    }

    @HideFromJS
    @SubscribeEvent
    public static void renderScreenPost(ScreenEvent.Render.Post event) {
        RenderJSPainter.render(event.getGuiGraphics(), Layer.screen, Step.aboveAll);
    }

    @HideFromJS
    private static void render(GuiGraphics guiGraphics, Layer layer, Step step) {
        for (ScreenPainterObject screenObject : Painter.INSTANCE.getScreenObjects()) {
            IRenderJSPainterObject object;
            if (!(screenObject instanceof IRenderJSPainterObject) || !(object = (IRenderJSPainterObject)screenObject).visible() || object.getLayer() != layer || object.getStep() != step) continue;
            object.draw(guiGraphics);
        }
    }

    public static enum Layer {
        hud,
        screen;

    }

    public static enum Step {
        belowAll,
        aboveAll;

    }
}

