/*
 * Decompiled with CFR 0.152.
 */
package com.chen1335.renderjs.client;

import com.chen1335.renderjs.client.renderer.RenderJSRenderType;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="renderjs", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class RenderJSWorldRender {
    private static Minecraft minecraft;
    private static final RenderJSWorldRender instance;
    public static ArrayList<Consumer<RenderContext>> RENDER_LIST;
    public static ArrayList<Consumer<RenderContext>> READY_RENDER_LIST;
    public static boolean needReload;

    @HideFromJS
    public static RenderJSWorldRender getInstance() {
        return instance;
    }

    public static void init() {
        minecraft = Minecraft.m_91087_();
    }

    @SubscribeEvent
    public static void RenderLevelStageEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            RenderSystem.disableDepthTest();
            Iterator<Consumer<RenderContext>> consumerIterator = RENDER_LIST.iterator();
            if (consumerIterator.hasNext()) {
                consumerIterator.next().accept(RenderContext.getInstance().setParam(event, RenderJSWorldRender.getRenderBuffers().m_110104_()));
            }
            if (needReload) {
                needReload = false;
                RENDER_LIST.clear();
                RENDER_LIST.addAll(READY_RENDER_LIST);
                READY_RENDER_LIST.clear();
            }
            RenderSystem.enableDepthTest();
        }
    }

    @HideFromJS
    public static void reload() {
        needReload = true;
    }

    @HideFromJS
    public static void clearRender() {
        RENDER_LIST.clear();
    }

    public static void renderShape(PoseStack pPoseStack, VertexConsumer pConsumer, VoxelShape pShape, double pX, double pY, double pZ, float pRed, float pGreen, float pBlue, float pAlpha) {
        PoseStack.Pose posestack$pose = pPoseStack.m_85850_();
        pShape.m_83224_((p_234280_, p_234281_, p_234282_, p_234283_, p_234284_, p_234285_) -> {
            float f = (float)(p_234283_ - p_234280_);
            float f1 = (float)(p_234284_ - p_234281_);
            float f2 = (float)(p_234285_ - p_234282_);
            float f3 = Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
            pConsumer.m_252986_(posestack$pose.m_252922_(), (float)(p_234280_ + pX), (float)(p_234281_ + pY), (float)(p_234282_ + pZ)).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(posestack$pose.m_252943_(), f /= f3, f1 /= f3, f2 /= f3).m_5752_();
            pConsumer.m_252986_(posestack$pose.m_252922_(), (float)(p_234283_ + pX), (float)(p_234284_ + pY), (float)(p_234285_ + pZ)).m_85950_(pRed, pGreen, pBlue, pAlpha).m_252939_(posestack$pose.m_252943_(), f, f1, f2).m_5752_();
        });
    }

    public void addWorldRender(Consumer<RenderContext> consumer) {
        READY_RENDER_LIST.add(consumer);
    }

    @Info(value="RenderType uses this to make the rendered blocks penetrate the terrain (BlockOutLine, please use getTopLayerLineType())")
    public static RenderType getTopLayerType() {
        return RenderJSRenderType.TOP_LAYER_TARGET;
    }

    @Info(value="The RenderType of BlockOutLine can be used to make the rendered blocks penetrate the terrain")
    public static RenderType getTopLayerLineType() {
        return RenderJSRenderType.TOP_LAYER_LINE_TARGET;
    }

    @Info(value="render block, can only be used in AddWorldRenderEvent", params={@Param(name="renderType", value="@Nullable")})
    public static void renderBlock1(BlockPos blockPos, BlockState blockState, int packedLight, @Nullable RenderType renderType) {
        MultiBufferSource.BufferSource bufferSource = RenderJSWorldRender.getRenderBuffers().m_110104_();
        PoseStack poseStack = RenderContext.instance.poseStack;
        Vec3 playerPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)blockPos.m_123341_() - playerPos.f_82479_, (double)blockPos.m_123342_() - playerPos.f_82480_, (double)blockPos.m_123343_() - playerPos.f_82481_);
        minecraft.m_91289_().renderSingleBlock(blockState, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
        poseStack.m_85849_();
    }

    @Info(value="render block", params={@Param(name="renderType", value="@Nullable")})
    public static void renderBlock2(PoseStack poseStack, BlockState blockState, int packedLight, @Nullable RenderType renderType) {
        minecraft.m_91289_().renderSingleBlock(blockState, poseStack, (MultiBufferSource)RenderJSWorldRender.getRenderBuffers().m_110104_(), packedLight, OverlayTexture.f_118083_, ModelData.EMPTY, renderType);
    }

    @Info(value="render block,with full param", params={@Param(name="renderType", value="@Nullable"), @Param(name="modelData", value="@Nullable")})
    public static void renderSingleBlock(BlockState blockState, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, @Nullable ModelData modelData, RenderType renderType) {
        minecraft.m_91289_().renderSingleBlock(blockState, poseStack, bufferSource, packedLight, packedOverlay, modelData == null ? ModelData.EMPTY : modelData, renderType);
    }

    @Info(value="Drawing block border lines can only be used in AddWorldRenderEvent", params={@Param(name="renderType", value="@Nullable")})
    public static void renderBlockOutLine1(BlockPos blockPos, BlockState blockState, @Nullable RenderType renderType) {
        if (!blockState.m_60795_()) {
            MultiBufferSource.BufferSource bufferSource = RenderJSWorldRender.getRenderBuffers().m_110104_();
            Vec3 playerPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            PoseStack poseStack = RenderContext.instance.poseStack;
            RenderType renderType1 = renderType == null ? RenderType.m_110504_() : renderType;
            VertexConsumer vertexconsumer = bufferSource.m_6299_(renderType1);
            poseStack.m_85836_();
            RenderJSWorldRender.getInstance().renderHitOutline(poseStack, vertexconsumer, Minecraft.m_91087_().f_91063_.m_109153_().m_90592_(), playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, blockPos, blockState);
            poseStack.m_85849_();
            bufferSource.m_109912_(renderType1);
        }
    }

    @Info(value="render block out lines", params={@Param(name="renderType", value="@Nullable")})
    public static void renderBlockOutLine2(PoseStack poseStack, BlockPos blockPos, BlockState blockState, @Nullable RenderType renderType) {
        if (!blockState.m_60795_()) {
            MultiBufferSource.BufferSource bufferSource = RenderJSWorldRender.getRenderBuffers().m_110104_();
            Vec3 playerPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            RenderType renderType1 = renderType == null ? RenderType.m_110504_() : renderType;
            VertexConsumer vertexconsumer = bufferSource.m_6299_(renderType1);
            RenderJSWorldRender.getInstance().renderHitOutline(poseStack, vertexconsumer, Minecraft.m_91087_().f_91063_.m_109153_().m_90592_(), playerPos.f_82479_, playerPos.f_82480_, playerPos.f_82481_, blockPos, blockState);
        }
    }

    @Info(value="renderItem")
    public static void renderItem(PoseStack pMatrixStack, ItemStack itemStack, int packedLight, Level level) {
        MultiBufferSource.BufferSource bufferSource = RenderJSWorldRender.getRenderBuffers().m_110104_();
        minecraft.m_91291_().m_269128_(itemStack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.f_118083_, pMatrixStack, (MultiBufferSource)bufferSource, level, RenderJSWorldRender.minecraft.f_91074_.m_19879_());
    }

    @Info(value="renderItem")
    public static void renderStatic(ItemStack itemStack, ItemDisplayContext itemDisplayContext, int combinedLight, int combinedOverlay, PoseStack poseStack, MultiBufferSource bufferSource, @Nullable Level pLevel, int pSeed) {
        minecraft.m_91291_().m_269128_(itemStack, itemDisplayContext, combinedLight, combinedOverlay, poseStack, bufferSource, pLevel, pSeed);
    }

    public static BakedModel getBlockModel(BlockState blockState) {
        return minecraft.m_91289_().m_110910_(blockState);
    }

    @Info(value="getPackedLight")
    public static int getPackedLight(int BlockLight, int SkyLight) {
        return LightTexture.m_109885_((int)BlockLight, (int)SkyLight);
    }

    public static BlockColors getBlockColors() {
        return minecraft.m_91298_();
    }

    public static RenderBuffers getRenderBuffers() {
        return minecraft.m_91269_();
    }

    public static ModelBlockRenderer getModelRenderer() {
        return minecraft.m_91289_().m_110937_();
    }

    public void renderHitOutline(PoseStack pPoseStack, VertexConsumer pConsumer, Entity pEntity, double pCamX, double pCamY, double pCamZ, BlockPos pPos, BlockState pState) {
        RenderJSWorldRender.renderShape(pPoseStack, pConsumer, pState.m_60651_((BlockGetter)pEntity.m_9236_(), pPos, CollisionContext.m_82750_((Entity)pEntity)), (double)pPos.m_123341_() - pCamX, (double)pPos.m_123342_() - pCamY, (double)pPos.m_123343_() - pCamZ, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    static {
        instance = new RenderJSWorldRender();
        RENDER_LIST = new ArrayList();
        READY_RENDER_LIST = new ArrayList();
        needReload = false;
    }

    public static class RenderContext {
        private static final RenderContext instance = new RenderContext();
        public MultiBufferSource.BufferSource bufferSource;
        public RenderJSWorldRender worldRender = RenderJSWorldRender.getInstance();
        public Camera camera;
        public LevelRenderer levelRenderer;
        public PoseStack poseStack;
        public Matrix4f projectionMatrix;
        public int renderTick;
        public float partialTick;
        public Frustum frustum;

        public static RenderContext getInstance() {
            return instance;
        }

        public RenderContext setParam(RenderLevelStageEvent event, MultiBufferSource.BufferSource bufferSource) {
            this.levelRenderer = event.getLevelRenderer();
            this.poseStack = event.getPoseStack();
            this.projectionMatrix = event.getProjectionMatrix();
            this.renderTick = event.getRenderTick();
            this.partialTick = event.getPartialTick();
            this.camera = event.getCamera();
            this.frustum = event.getFrustum();
            this.bufferSource = bufferSource;
            return this;
        }
    }
}

