/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.morejs.features.villager.events;

import com.almostreliable.morejs.features.villager.IntRange;
import com.almostreliable.morejs.features.villager.TradeFilter;
import com.almostreliable.morejs.features.villager.TradeItem;
import com.almostreliable.morejs.features.villager.VillagerUtils;
import com.almostreliable.morejs.features.villager.trades.CustomTrade;
import com.almostreliable.morejs.features.villager.trades.SimpleTrade;
import com.almostreliable.morejs.features.villager.trades.TransformableTrade;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;

public class VillagerTradingEventJS
extends EventJS {
    private final Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>> trades;

    public VillagerTradingEventJS(Map<VillagerProfession, Int2ObjectMap<List<VillagerTrades.ItemListing>>> trades) {
        this.trades = trades;
    }

    public List<VillagerTrades.ItemListing> getTrades(VillagerProfession profession, int level) {
        Preconditions.checkArgument((1 <= level && level <= 5 ? 1 : 0) != 0, (Object)"Level must be between 1 and 5");
        Preconditions.checkArgument((!profession.equals((Object)VillagerProfession.f_35585_) ? 1 : 0) != 0, (Object)"No or invalid profession specified");
        return (List)this.trades.computeIfAbsent(profession, $ -> new Int2ObjectOpenHashMap()).computeIfAbsent(level, $ -> new ArrayList());
    }

    public SimpleTrade addTrade(VillagerProfession profession, int level, TradeItem[] inputs, TradeItem output) {
        Preconditions.checkArgument((!output.isEmpty() ? 1 : 0) != 0, (Object)"Sell item cannot be empty");
        Preconditions.checkArgument((inputs.length != 0 ? 1 : 0) != 0, (Object)"Buyer items cannot be empty");
        Preconditions.checkArgument((boolean)Arrays.stream(inputs).noneMatch(TradeItem::isEmpty), (Object)"Buyer items cannot be empty");
        SimpleTrade trade = VillagerUtils.createSimpleTrade(inputs, output);
        return this.addTrade(profession, level, trade);
    }

    public <T extends VillagerTrades.ItemListing> T addTrade(VillagerProfession profession, int level, T trade) {
        Objects.requireNonNull(trade);
        this.getTrades(profession, level).add(trade);
        return trade;
    }

    public void addCustomTrade(VillagerProfession profession, int level, TransformableTrade.Transformer transformer) {
        this.getTrades(profession, level).add(new CustomTrade(transformer));
    }

    public void removeTrades(TradeFilter filter) {
        this.forEachTrades((listings, level, profession) -> {
            filter.onMatch((first, second, output) -> ConsoleJS.SERVER.info((Object)("Removing villager ( trade for level " + level + ": " + String.valueOf(first) + " & " + String.valueOf(second) + " -> " + String.valueOf(output))));
            if (!filter.matchProfession(profession)) {
                return;
            }
            if (!filter.matchMerchantLevel(level)) {
                return;
            }
            listings.removeIf(itemListing -> {
                if (itemListing instanceof TradeFilter.Filterable) {
                    TradeFilter.Filterable filterable = (TradeFilter.Filterable)itemListing;
                    return filterable.matchesTradeFilter(filter);
                }
                return false;
            });
        });
    }

    public void removeVanillaTrades() {
        this.forEachTrades((listings, level, profession) -> listings.removeIf(VillagerUtils::isVanillaTrade));
    }

    public void removeVanillaTrades(VillagerProfession[] professions, IntRange intRange) {
        this.forEachTrades(professions, intRange, itemListings -> itemListings.removeIf(VillagerUtils::isVanillaTrade));
    }

    public void removeModdedTrades() {
        this.forEachTrades((listings, level, profession) -> listings.removeIf(VillagerUtils::isModdedTrade));
    }

    public void removeModdedTrades(VillagerProfession[] professions, IntRange intRange) {
        this.forEachTrades(professions, intRange, itemListings -> itemListings.removeIf(VillagerUtils::isModdedTrade));
    }

    public void forEachTrades(ForEachCallback callback) {
        this.trades.forEach((profession, levelTrades) -> levelTrades.forEach((level, itemListings) -> callback.accept((List<VillagerTrades.ItemListing>)itemListings, (int)level, (VillagerProfession)profession)));
    }

    public void forEachTrades(VillagerProfession[] professions, IntRange intRange, Consumer<List<VillagerTrades.ItemListing>> consumer) {
        Set filter = Arrays.stream(professions).collect(Collectors.toSet());
        this.forEachTrades((itemListings, level, profession) -> {
            if (filter.contains(profession) && intRange.test(level)) {
                consumer.accept(itemListings);
            }
        });
    }

    public static interface ForEachCallback {
        public void accept(List<VillagerTrades.ItemListing> var1, int var2, VillagerProfession var3);
    }
}

