/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.neoforge;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;
import rbasamoyai.ritchiesprojectilelib.config.RPLConfigs;
import rbasamoyai.ritchiesprojectilelib.neoforge.RPLForgeClient;

@Mod(value="ritchiesprojectilelib")
public class RitchiesProjectileLibForge {
    public RitchiesProjectileLibForge() {
        RitchiesProjectileLib.init();
        ModLoadingContext mlContext = ModLoadingContext.get();
        RPLConfigs.registerConfigs((arg_0, arg_1) -> ((ModLoadingContext)mlContext).registerConfig(arg_0, arg_1));
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(this::onPlayerLogin);
        forgeBus.addListener(this::onServerLevelTick);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> RPLForgeClient.init(modBus, forgeBus));
    }

    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent evt) {
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer splayer = (ServerPlayer)player;
            RitchiesProjectileLib.onPlayerJoin(splayer);
        }
    }

    public void onServerLevelTick(TickEvent.LevelTickEvent evt) {
        Level level = evt.level;
        if (level instanceof ServerLevel) {
            ServerLevel slevel = (ServerLevel)level;
            if (evt.phase == TickEvent.Phase.END) {
                RitchiesProjectileLib.onServerLevelTickEnd(slevel);
            }
        }
    }
}

