/*
 * Decompiled with CFR 0.152.
 */
package questsadditions.tasks;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.NBTConfig;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftbquests.net.FTBQuestsNetHandler;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.util.NBTUtils;
import dev.latvian.mods.itemfilters.api.ItemFiltersAPI;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import questsadditions.tasks.TasksRegistry;
import questsadditions.utils.TasksUtils;

public class InteractionTask
extends Task {
    public static final ResourceLocation ZOMBIE_VILLAGER = new ResourceLocation("minecraft:zombie_villager");
    public ResourceLocation entity = ZOMBIE_VILLAGER;
    public CompoundTag nbt = new CompoundTag();
    public ItemStack item = ItemStack.f_41583_;
    public boolean checkItem;
    public long value = 100L;

    public InteractionTask(long id, Quest quest) {
        super(id, quest);
    }

    public TaskType getType() {
        return TasksRegistry.INTERACTION;
    }

    public long getMaxProgress() {
        return this.value;
    }

    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128359_("entity", this.entity.toString());
        nbt.m_128365_("nbt", (Tag)this.nbt);
        nbt.m_128356_("value", this.value);
        nbt.m_128379_("checkItem", this.checkItem);
        NBTUtils.write((CompoundTag)nbt, (String)"item", (ItemStack)this.item);
    }

    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.entity = new ResourceLocation(nbt.m_128461_("entity"));
        this.nbt = nbt.m_128469_("nbt");
        this.value = nbt.m_128454_("value");
        this.checkItem = nbt.m_128471_("checkItem");
        this.item = NBTUtils.read((CompoundTag)nbt, (String)"item");
    }

    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130072_(this.entity.toString(), Short.MAX_VALUE);
        buffer.m_130079_(this.nbt);
        buffer.m_130103_(this.value);
        buffer.writeBoolean(this.checkItem);
        FTBQuestsNetHandler.writeItemType((FriendlyByteBuf)buffer, (ItemStack)this.item);
    }

    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.entity = new ResourceLocation(buffer.m_130136_(Short.MAX_VALUE));
        this.nbt = buffer.m_130260_();
        this.value = buffer.m_130242_();
        this.checkItem = buffer.readBoolean();
        this.item = FTBQuestsNetHandler.readItemType((FriendlyByteBuf)buffer);
    }

    public boolean test(ItemStack stack) {
        return ItemFiltersAPI.filter((ItemStack)this.item, (ItemStack)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void fillConfigGroup(ConfigGroup config) {
        super.fillConfigGroup(config);
        ArrayList ids = new ArrayList(ForgeRegistries.ENTITY_TYPES.getKeys());
        config.addEnum("entity", (Object)this.entity, v -> {
            this.entity = v;
        }, NameMap.of((Object)ZOMBIE_VILLAGER, ids).nameKey(v -> "entity." + v.m_135827_() + "." + v.m_135815_()).icon(v -> {
            SpawnEggItem item = SpawnEggItem.m_43213_((EntityType)((EntityType)((Holder)ForgeRegistries.ENTITY_TYPES.getHolder(v).get()).get()));
            return ItemIcon.getItemIcon((Item)(item != null ? item : Items.f_42007_));
        }).create(), (Object)ZOMBIE_VILLAGER).setNameKey("ftbquests.task.ftbquests.kill.entity");
        ((NBTConfig)config.add("nbt", (ConfigValue)new NBTConfig(), (Object)this.nbt, v -> {
            this.nbt = v;
        }, (Object)new CompoundTag())).setNameKey("questsadditions.task.nbt");
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 100L, 1L, Long.MAX_VALUE).setNameKey("questsadditions.task.count");
        config.addBool("checkItem", this.checkItem, v -> {
            this.checkItem = v;
        }, false).setNameKey("questsadditions.task.check_item");
        config.addItemStack("item", this.item, v -> {
            this.item = v;
        }, ItemStack.f_41583_, true, true).setNameKey("ftbquests.task.ftbquests.item");
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getAltTitle() {
        return Component.m_237110_((String)(this.checkItem ? "questsadditions.task.interaction.item.title" : "questsadditions.task.interaction.title"), (Object[])new Object[]{this.formatMaxProgress(), Component.m_237115_((String)("entity." + this.entity.m_135827_() + "." + this.entity.m_135815_())), this.item.m_41786_()});
    }

    public List<ItemStack> getValidDisplayItems() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemFiltersAPI.getDisplayItemStacks((ItemStack)this.item, list);
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Icon getAltIcon() {
        SpawnEggItem item = SpawnEggItem.m_43213_((EntityType)((EntityType)((Holder)ForgeRegistries.ENTITY_TYPES.getHolder(this.entity).get()).get()));
        Icon icon = ItemIcon.getItemIcon((Item)(item != null ? item : Items.f_42007_));
        return this.checkItem ? TasksUtils.createHoldingIcon(icon, this.item) : icon;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
    }

    public void Interact(TeamData teamData, Entity e, ItemStack itemStack) {
        CompoundTag entitynbt;
        if (!teamData.isCompleted((QuestObject)this) && this.entity.equals((Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)e.m_6095_())) && (!this.checkItem || ItemFiltersAPI.filter((ItemStack)this.item, (ItemStack)itemStack)) && TasksUtils.Compoundequals(this.nbt, entitynbt = e.m_20240_(new CompoundTag()))) {
            teamData.addProgress((Task)this, 1L);
        }
    }
}

