/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.core.events;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.function.Function;

public final class SimpleEvent<L> {
    private final Function<L[], L> invokerFactory;
    private L[] listeners;
    private L invoker;

    public SimpleEvent(Class<L> listenerClass, Function<L[], L> invokerFactory) {
        this.invokerFactory = invokerFactory;
        this.listeners = (Object[])Array.newInstance(listenerClass, 0);
        this.invoker = this.invokerFactory.apply(this.listeners);
    }

    public synchronized void registerListener(L listener) {
        int oldLength = this.listeners.length;
        L[] LArray = Arrays.copyOf(this.listeners, oldLength + 1);
        this.listeners = LArray;
        LArray[oldLength] = listener;
        this.invoker = this.invokerFactory.apply(this.listeners);
    }

    public L getInvoker() {
        return this.invoker;
    }
}

