/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.blueprint.common.remolder.data;

import com.teamabnormals.blueprint.common.remolder.data.Molding;
import org.objectweb.asm.Type;

@FunctionalInterface
public interface DataType {
    public static final Type OBJECT_TYPE = Type.getType(Object.class);
    public static final Type STRING_TYPE = Type.getType(String.class);
    public static final Type BOOLEAN_TYPE = Type.getType(Boolean.class);
    public static final Type CHARACTER_TYPE = Type.getType(Character.class);
    public static final Type BYTE_TYPE = Type.getType(Byte.class);
    public static final Type SHORT_TYPE = Type.getType(Short.class);
    public static final Type INTEGER_TYPE = Type.getType(Integer.class);
    public static final Type FLOAT_TYPE = Type.getType(Float.class);
    public static final Type LONG_TYPE = Type.getType(Long.class);
    public static final Type DOUBLE_TYPE = Type.getType(Double.class);
    public static final DataType BOOLEAN = molding -> Type.BOOLEAN_TYPE;
    public static final DataType BOOLEAN_WRAPPER = molding -> BOOLEAN_TYPE;
    public static final DataType CHAR = molding -> Type.CHAR_TYPE;
    public static final DataType CHAR_WRAPPER = molding -> CHARACTER_TYPE;
    public static final DataType BYTE = molding -> Type.BYTE_TYPE;
    public static final DataType BYTE_WRAPPER = molding -> BYTE_TYPE;
    public static final DataType SHORT = molding -> Type.SHORT_TYPE;
    public static final DataType SHORT_WRAPPER = molding -> SHORT_TYPE;
    public static final DataType INT = molding -> Type.INT_TYPE;
    public static final DataType INT_WRAPPER = molding -> INTEGER_TYPE;
    public static final DataType LONG = molding -> Type.LONG_TYPE;
    public static final DataType LONG_WRAPPER = molding -> LONG_TYPE;
    public static final DataType FLOAT = molding -> Type.FLOAT_TYPE;
    public static final DataType FLOAT_WRAPPER = molding -> FLOAT_TYPE;
    public static final DataType DOUBLE = molding -> Type.DOUBLE_TYPE;
    public static final DataType DOUBLE_WRAPPER = molding -> DOUBLE_TYPE;
    public static final DataType STRING = molding -> STRING_TYPE;
    public static final DataType ELEMENT = new DataType(){

        @Override
        public ElementType elementType() {
            return ElementType.ELEMENT;
        }

        @Override
        public Type getTrueType(Molding<?> molding) {
            return molding.getDataType();
        }
    };

    public static String toString(DataType dataType) {
        ElementType elementType = dataType.elementType();
        return elementType != ElementType.NONE ? elementType.name() : dataType.getTrueType(null).getClassName();
    }

    default public ElementType elementType() {
        return ElementType.NONE;
    }

    public Type getTrueType(Molding<?> var1);

    public static enum ElementType {
        NONE,
        ELEMENT,
        LIST,
        MAP;

    }
}

