/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.mixins.forge;

import java.util.function.Consumer;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.client.ICustomItemRendererProvider;
import net.mehvahdjukaar.moonlight.api.client.ItemStackRenderer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.NonNullLazy;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Item.class})
public abstract class ItemMixin {
    @Inject(remap=false, method={"initializeClient"}, at={@At(value="HEAD")})
    public void initializeClient(Consumer<IClientItemExtensions> consumer, CallbackInfo ci) {
        ItemMixin itemMixin = this;
        if (itemMixin instanceof ICustomItemRendererProvider) {
            final ICustomItemRendererProvider provider = (ICustomItemRendererProvider)((Object)itemMixin);
            consumer.accept(new IClientItemExtensions(){
                final NonNullLazy<BlockEntityWithoutLevelRenderer> renderer = NonNullLazy.of(((Supplier<ItemStackRenderer>)provider.getRendererFactory())::get);

                public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                    return (BlockEntityWithoutLevelRenderer)this.renderer.get();
                }
            });
        }
    }
}

