/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.MoonlightRegistry;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.jetbrains.annotations.Nullable;

public class OptionalPropertyCondition
implements LootItemCondition {
    @Nullable
    final Block block;
    final StatePropertiesPredicate properties;
    private final ResourceLocation blockId;

    OptionalPropertyCondition(ResourceLocation blockId, Block block, StatePropertiesPredicate predicate) {
        this.properties = predicate;
        this.block = block;
        this.blockId = blockId;
    }

    public LootItemConditionType m_7940_() {
        return MoonlightRegistry.LAZY_PROPERTY.get();
    }

    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81461_);
    }

    public boolean test(LootContext lootContext) {
        if (this.block == null) {
            return false;
        }
        BlockState blockState = (BlockState)lootContext.m_78953_(LootContextParams.f_81461_);
        return blockState != null && blockState.m_60713_(this.block) && this.properties.m_67667_(blockState);
    }

    public static class ConditionSerializer
    implements Serializer<OptionalPropertyCondition> {
        public void serialize(JsonObject jsonObject, OptionalPropertyCondition condition, JsonSerializationContext context) {
            jsonObject.addProperty("block", condition.blockId.toString());
            jsonObject.add("properties", condition.properties.m_67666_());
        }

        public OptionalPropertyCondition deserialize(JsonObject jsonObject, JsonDeserializationContext context) {
            ResourceLocation resourceLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)jsonObject, (String)"block"));
            Block block = BuiltInRegistries.f_256975_.m_6612_(resourceLocation).orElse(null);
            StatePropertiesPredicate predicate = StatePropertiesPredicate.f_67658_;
            if (block != null) {
                predicate = StatePropertiesPredicate.m_67679_((JsonElement)jsonObject.get("properties"));
                predicate.m_67672_(block.m_49965_(), string -> {
                    throw new JsonSyntaxException("Block " + String.valueOf(block) + " has no property " + string);
                });
            }
            return new OptionalPropertyCondition(resourceLocation, block, predicate);
        }
    }
}

