/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util.math;

import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.util.math.colors.BaseColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MthUtils {
    public static final float PHI = (float)(1.0 + (Math.sqrt(5.0) - 1.0) / 2.0);

    public static float[] polarToCartesian(float a, float r) {
        float x = r * Mth.m_14089_((float)a);
        float y = r * Mth.m_14031_((float)a);
        return new float[]{x, y};
    }

    public static float signedAngleDiff(double to, double from) {
        float x1 = Mth.m_14089_((float)((float)to));
        float y1 = Mth.m_14031_((float)((float)to));
        float x2 = Mth.m_14089_((float)((float)from));
        float y2 = Mth.m_14031_((float)((float)from));
        return (float)Mth.m_14136_((double)(x1 * y1 - y1 * x2), (double)(x1 * x2 + y1 * y2));
    }

    public static Vec3 changeBasisN(Vec3 newBasisYVector, Vec3 rot) {
        Vec3 y = newBasisYVector.m_82541_();
        Vec3 x = new Vec3(y.f_82480_, y.f_82481_, y.f_82479_).m_82541_();
        Vec3 z = y.m_82537_(x).m_82541_();
        return MthUtils.changeBasis(x, y, z, rot);
    }

    public static Vec3 changeBasis(Vec3 newX, Vec3 newY, Vec3 newZ, Vec3 rot) {
        return newX.m_82490_(rot.f_82479_).m_82549_(newY.m_82490_(rot.f_82480_)).m_82549_(newZ.m_82490_(rot.f_82481_));
    }

    public static Vec3 getNormalFrom3DData(int direction) {
        return MthUtils.V3itoV3(Direction.m_122376_((int)direction).m_122436_());
    }

    public static Vec3 V3itoV3(Vec3i v) {
        return new Vec3((double)v.m_123341_(), (double)v.m_123342_(), (double)v.m_123343_());
    }

    private static double isClockWise(UnaryOperator<Vec3> rot, Direction dir) {
        Vec3 v = MthUtils.V3itoV3(dir.m_122436_());
        Vec3 v2 = (Vec3)rot.apply(v);
        return v2.m_82526_(new Vec3(0.0, 1.0, 0.0));
    }

    public static Vec3 rotateVec3(Vec3 vec, Direction dir) {
        double cos = 1.0;
        double sin = 0.0;
        switch (dir) {
            case SOUTH: {
                cos = -1.0;
                sin = 0.0;
                break;
            }
            case WEST: {
                cos = 0.0;
                sin = 1.0;
                break;
            }
            case EAST: {
                cos = 0.0;
                sin = -1.0;
                break;
            }
            case UP: {
                return new Vec3(vec.f_82479_, -vec.f_82481_, vec.f_82480_);
            }
            case DOWN: {
                return new Vec3(vec.f_82479_, vec.f_82481_, vec.f_82480_);
            }
        }
        double dx = vec.f_82479_ * cos + vec.f_82481_ * sin;
        double dy = vec.f_82480_;
        double dz = vec.f_82481_ * cos - vec.f_82479_ * sin;
        return new Vec3(dx, dy, dz);
    }

    public static float averageAngles(Float ... angles) {
        float x = 0.0f;
        float y = 0.0f;
        Float[] floatArray = angles;
        int n = floatArray.length;
        for (int i = 0; i < n; ++i) {
            float a = floatArray[i].floatValue();
            x += Mth.m_14089_((float)((float)((double)a * Math.PI * 2.0)));
            y += Mth.m_14031_((float)((float)((double)a * Math.PI * 2.0)));
        }
        return (float)(Mth.m_14136_((double)y, (double)x) / (Math.PI * 2));
    }

    public static double getPitch(Vec3 vec3) {
        return -Math.toDegrees(Math.asin(vec3.f_82480_));
    }

    public static double getYaw(Vec3 vec3) {
        return Math.toDegrees(Math.atan2(-vec3.f_82479_, vec3.f_82481_));
    }

    public static double getRoll(Vec3 vec3) {
        return Math.toDegrees(Math.atan2(vec3.f_82480_, vec3.f_82479_));
    }

    public static double wrapRad(double pValue) {
        double p = Math.PI * 2;
        double d0 = pValue % p;
        if (d0 >= Math.PI) {
            d0 -= p;
        }
        if (d0 < -Math.PI) {
            d0 += p;
        }
        return d0;
    }

    public static float wrapRad(float pValue) {
        float p = (float)Math.PI * 2;
        float d0 = pValue % p;
        if ((double)d0 >= Math.PI) {
            d0 -= p;
        }
        if ((double)d0 < -Math.PI) {
            d0 += p;
        }
        return d0;
    }

    public static float nextWeighted(RandomSource rand, float max, float bias) {
        float r = rand.m_188501_();
        if (bias <= 0.0f) {
            if (bias == 0.0f) {
                return r * max;
            }
            bias = -bias / (bias - 1.0f);
        }
        return max * (1.0f - r) / (bias * max * r + 1.0f);
    }

    public static float nextWeighted(RandomSource rand, float max, float bias, float min) {
        return MthUtils.nextWeighted(rand, max - min, bias) + min;
    }

    public static float nextWeighted(RandomSource rand, float max) {
        return MthUtils.nextWeighted(rand, max, 1.0f);
    }

    public static <T extends BaseColor<T>> T lerpColorScale(List<T> palette, float phase) {
        if (phase >= 1.0f) {
            phase %= 1.0f;
        }
        int n = palette.size();
        float g = (float)n * phase;
        int ind = (int)Math.floor(g);
        float delta = g % 1.0f;
        BaseColor start = (BaseColor)palette.get(ind);
        BaseColor end = (BaseColor)palette.get((ind + 1) % n);
        return (T)start.mixWith(end, delta);
    }

    public static boolean isWithinRectangle(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    public static VoxelShape rotateVoxelShape(VoxelShape source, Direction direction) {
        if (direction == Direction.NORTH) {
            return source;
        }
        AtomicReference<VoxelShape> newShape = new AtomicReference<VoxelShape>(Shapes.m_83040_());
        source.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vec3 min = new Vec3(minX - 0.5, minY - 0.5, minZ - 0.5);
            Vec3 max = new Vec3(maxX - 0.5, maxY - 0.5, maxZ - 0.5);
            Vec3 v1 = MthUtils.rotateVec3(min, direction);
            Vec3 v2 = MthUtils.rotateVec3(max, direction);
            VoxelShape s = Shapes.m_166049_((double)(0.5 + Math.min(v1.f_82479_, v2.f_82479_)), (double)(0.5 + Math.min(v1.f_82480_, v2.f_82480_)), (double)(0.5 + Math.min(v1.f_82481_, v2.f_82481_)), (double)(0.5 + Math.max(v1.f_82479_, v2.f_82479_)), (double)(0.5 + Math.max(v1.f_82480_, v2.f_82480_)), (double)(0.5 + Math.max(v1.f_82481_, v2.f_82481_)));
            newShape.set(Shapes.m_83110_((VoxelShape)((VoxelShape)newShape.get()), (VoxelShape)s));
        });
        return newShape.get();
    }

    public static VoxelShape moveVoxelShape(VoxelShape source, Vec3 v) {
        AtomicReference<VoxelShape> newShape = new AtomicReference<VoxelShape>(Shapes.m_83040_());
        source.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            VoxelShape s = Shapes.m_166049_((double)(minX + v.f_82479_), (double)(minY + v.f_82480_), (double)(minZ + v.f_82481_), (double)(maxX + v.f_82479_), (double)(maxY + v.f_82480_), (double)(maxZ + v.f_82481_));
            newShape.set(Shapes.m_83110_((VoxelShape)((VoxelShape)newShape.get()), (VoxelShape)s));
        });
        return newShape.get();
    }

    public static double lambertW0(double x) {
        double maxError = 1.0E-6;
        if (x == -0.36787944117144233) {
            return -1.0;
        }
        if (x >= -0.36787944117144233) {
            double nLog = Math.log(x);
            double nLog0 = 1.0;
            while (Math.abs(nLog0 - nLog) > maxError) {
                nLog0 = x * Math.exp(-nLog) / (1.0 + nLog);
                nLog = x * Math.exp(-nLog0) / (1.0 + nLog0);
            }
            return Math.round(1000000.0 * nLog) / 1000000L;
        }
        throw new IllegalArgumentException("Not in valid range for lambertW function. x has to be greater than or equal to -1/e.");
    }

    public static double lambertW1(double x) {
        double maxError = 1.0E-6;
        if (x == -0.36787944117144233) {
            return -1.0;
        }
        if (x < 0.0 && x > -0.36787944117144233) {
            double nLog = Math.log(-x);
            double nLog0 = 1.0;
            while (Math.abs(nLog0 - nLog) > maxError) {
                nLog0 = (nLog * nLog + x / Math.exp(nLog)) / (nLog + 1.0);
                nLog = (nLog0 * nLog0 + x / Math.exp(nLog0)) / (nLog0 + 1.0);
            }
            return Math.round(1000000.0 * nLog) / 1000000L;
        }
        if (x == 0.0) {
            return 0.0;
        }
        throw new IllegalArgumentException("Not in valid range for lambertW function. x has to be in [-1/e,0]");
    }

    private static float exp01(float t, float base) {
        return (float)((double)base * Math.pow(1.0f / base + 1.0f, t) - (double)base);
    }

    public static float normalizedExponent(float t, float curve) {
        if (curve == 0.0f) {
            return t;
        }
        float base = curve > 0.0f ? (float)(-Math.log(curve)) : (float)(Math.log(-curve) - 1.0);
        return MthUtils.exp01(t, base);
    }

    public static BlockHitResult collideWithSweptAABB(Entity entity, Vec3 movement, double maxStep) {
        AABB aabb = entity.m_20191_();
        return MthUtils.collideWithSweptAABB(entity.m_20182_(), aabb, movement, entity.m_9236_(), maxStep);
    }

    public static BlockHitResult collideWithSweptAABB(Vec3 myPos, AABB myBox, Vec3 movement, Level level, double maxStep) {
        double len = movement.m_82553_();
        if (maxStep >= len) {
            return MthUtils.collideWithSweptAABB(myPos, myBox, movement, level);
        }
        Vec3 stepMovement = movement.m_82541_().m_82490_(maxStep);
        Vec3 currentPos = myPos;
        for (double moved = 0.0; moved < len; moved += maxStep) {
            BlockHitResult result;
            if (moved + maxStep > len) {
                stepMovement = movement.m_82490_((len - moved) / len);
            }
            if ((result = MthUtils.collideWithSweptAABB(currentPos, myBox, stepMovement, level)).m_6662_() != HitResult.Type.MISS) {
                return result;
            }
            currentPos = currentPos.m_82549_(stepMovement);
            myBox = myBox.m_82383_(stepMovement);
        }
        Vec3 missPos = myPos.m_82549_(movement);
        return BlockHitResult.m_82426_((Vec3)missPos, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)missPos));
    }

    public static BlockHitResult collideWithSweptAABB(Vec3 myPos, AABB myBox, Vec3 movement, Level level) {
        AABB encompassing = myBox.m_82369_(movement);
        Set positions = BlockPos.m_121921_((AABB)encompassing).map(BlockPos::m_7949_).collect(Collectors.toSet());
        CollisionResult earliestCollision = null;
        BlockPos hitPos = null;
        for (BlockPos pos : positions) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_()) continue;
            List boxes = state.m_60812_((BlockGetter)level, pos).m_83299_();
            for (AABB box : boxes) {
                CollisionResult result = MthUtils.sweptAABB(myBox, box = box.m_82338_(pos), movement);
                if (result == null || result.entryTime < 0.0) continue;
                if (earliestCollision == null) {
                    earliestCollision = result;
                    hitPos = pos;
                    continue;
                }
                if (result.entryTime == earliestCollision.entryTime) {
                    Vec3 collidedPos = myPos.m_82549_(movement.m_82490_(result.entryTime));
                    if (!(pos.m_203193_((Position)collidedPos) < hitPos.m_203193_((Position)collidedPos))) continue;
                    earliestCollision = result;
                    hitPos = pos;
                    continue;
                }
                if (!(result.entryTime < earliestCollision.entryTime)) continue;
                earliestCollision = result;
                hitPos = pos;
            }
        }
        if (earliestCollision != null && earliestCollision.entryTime < 1.0) {
            double entryTime = earliestCollision.entryTime - (double)1.0E-5f;
            movement = movement.m_82490_(entryTime);
            Vec3 finalPos = myPos.m_82549_(movement);
            return new BlockHitResult(finalPos, earliestCollision.direction.m_122424_(), hitPos, false);
        }
        Vec3 missPos = myPos.m_82549_(movement);
        return BlockHitResult.m_82426_((Vec3)missPos, (Direction)Direction.UP, (BlockPos)BlockPos.m_274446_((Position)missPos));
    }

    private static CollisionResult sweptAABB(AABB movingBox, AABB staticBox, Vec3 movement) {
        double exitZ;
        double entryZ;
        double exitY;
        double entryY;
        double exitX;
        double entryX;
        if (movement.f_82479_ > 0.0) {
            entryX = (staticBox.f_82288_ - movingBox.f_82291_) / movement.f_82479_;
            exitX = (staticBox.f_82291_ - movingBox.f_82288_) / movement.f_82479_;
        } else if (movement.f_82479_ < 0.0) {
            entryX = (staticBox.f_82291_ - movingBox.f_82288_) / movement.f_82479_;
            exitX = (staticBox.f_82288_ - movingBox.f_82291_) / movement.f_82479_;
        } else {
            entryX = Double.NEGATIVE_INFINITY;
            exitX = Double.POSITIVE_INFINITY;
        }
        if (movement.f_82480_ > 0.0) {
            entryY = (staticBox.f_82289_ - movingBox.f_82292_) / movement.f_82480_;
            exitY = (staticBox.f_82292_ - movingBox.f_82289_) / movement.f_82480_;
        } else if (movement.f_82480_ < 0.0) {
            entryY = (staticBox.f_82292_ - movingBox.f_82289_) / movement.f_82480_;
            exitY = (staticBox.f_82289_ - movingBox.f_82292_) / movement.f_82480_;
        } else {
            entryY = Double.NEGATIVE_INFINITY;
            exitY = Double.POSITIVE_INFINITY;
        }
        if (movement.f_82481_ > 0.0) {
            entryZ = (staticBox.f_82290_ - movingBox.f_82293_) / movement.f_82481_;
            exitZ = (staticBox.f_82293_ - movingBox.f_82290_) / movement.f_82481_;
        } else if (movement.f_82481_ < 0.0) {
            entryZ = (staticBox.f_82293_ - movingBox.f_82290_) / movement.f_82481_;
            exitZ = (staticBox.f_82290_ - movingBox.f_82293_) / movement.f_82481_;
        } else {
            entryZ = Double.NEGATIVE_INFINITY;
            exitZ = Double.POSITIVE_INFINITY;
        }
        double entryTime = Math.max(Math.max(entryX, entryY), entryZ);
        double exitTime = Math.min(Math.min(exitX, exitY), exitZ);
        if (entryTime > exitTime || entryX < 0.0 && entryY < 0.0 && entryZ < 0.0 || entryX > 1.0 || entryY > 1.0 || entryZ > 1.0) {
            return null;
        }
        Direction collisionDirection = entryX > entryY && entryX > entryZ ? (movement.f_82479_ > 0.0 ? Direction.EAST : Direction.WEST) : (entryY > entryZ ? (movement.f_82480_ > 0.0 ? Direction.UP : Direction.DOWN) : (movement.f_82481_ > 0.0 ? Direction.SOUTH : Direction.NORTH));
        return new CollisionResult(entryTime, collisionDirection);
    }

    private record CollisionResult(double entryTime, Direction direction) {
    }
}

