/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.dummmmmmy.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.mehvahdjukaar.dummmmmmy.Dummmmmmy;
import net.mehvahdjukaar.dummmmmmy.DummyPlatStuff;
import net.mehvahdjukaar.dummmmmmy.common.CritRecord;
import net.mehvahdjukaar.dummmmmmy.common.DummyMobType;
import net.mehvahdjukaar.dummmmmmy.configs.CommonConfigs;
import net.mehvahdjukaar.dummmmmmy.network.ClientBoundDamageNumberMessage;
import net.mehvahdjukaar.dummmmmmy.network.ClientBoundUpdateAnimationMessage;
import net.mehvahdjukaar.dummmmmmy.network.NetworkHandler;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.CombatEntry;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetDummyEntity
extends Mob {
    private static final int SHIELD_COOLDOWN = 100;
    private static final int HEALTH_RECHARGE_TIME = 160;
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(TargetDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BOSS = SynchedEntityData.m_135353_(TargetDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int lastTickActuallyDamaged;
    private float totalDamageTakenInCombat;
    private float totalHealingTakenInCombat;
    private final List<CritRecord> critRecordsThisTick = new ArrayList<CritRecord>();
    private DummyMobType mobType = DummyMobType.UNDEFINED;
    private DamageSource currentDamageSource = null;
    private boolean unbreakable = false;
    private final PlayersTracker playersTracker = new PlayersTracker();
    private int healthRechargeTimer = 0;
    private float lastHealth;
    private float prevAnimationPosition = 0.0f;
    private float animationPosition;
    private int damageNumberPos = 0;
    private float shakeAmount = 0.0f;
    private float prevShakeAmount = 0.0f;
    private int shieldCooldown = 0;

    public TargetDummyEntity(EntityType<TargetDummyEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21553_(false);
        Arrays.fill(this.f_21348_, 1.1f);
        this.playersTracker.showHealthBar(false);
    }

    public TargetDummyEntity(Level world) {
        this(Dummmmmmy.TARGET_DUMMY.get(), world);
    }

    public float getShake(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevShakeAmount, (float)this.shakeAmount);
    }

    public float getAnimationPosition(float partialTicks) {
        return Mth.m_14179_((float)partialTicks, (float)this.prevAnimationPosition, (float)this.animationPosition);
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean sheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)sheared);
    }

    public boolean isBoss() {
        return (Boolean)this.f_19804_.m_135370_(BOSS);
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (dataAccessor == BOSS) {
            this.playersTracker.showHealthBar(this.isBoss());
        }
    }

    public void setBoss(boolean boss) {
        this.f_19804_.m_135381_(BOSS, (Object)boss);
        this.playersTracker.showHealthBar(boss);
    }

    public boolean canScare() {
        return this.mobType == DummyMobType.SCARECROW;
    }

    public boolean canAttract() {
        return this.mobType == DummyMobType.DECOY;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
        super.m_8061_(slot, stack);
        if (slot == EquipmentSlot.HEAD) {
            this.mobType = DummyMobType.get(stack);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHEARED, (Object)false);
        this.f_19804_.m_135372_(BOSS, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Sheared", this.isSheared());
        tag.m_128405_("HealthRechargeTimer", this.healthRechargeTimer);
        if (this.unbreakable) {
            tag.m_128379_("Unbreakable", true);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setSheared(tag.m_128471_("Sheared"));
        this.healthRechargeTimer = tag.m_128451_("HealthRechargeTimer");
        if (tag.m_128441_("Unbreakable")) {
            this.unbreakable = tag.m_128471_("Unbreakable");
        }
        this.mobType = DummyMobType.get(this.m_6844_(EquipmentSlot.HEAD));
        this.setBoss(this.m_6844_(EquipmentSlot.OFFHAND).m_41720_() instanceof BannerItem);
        this.lastHealth = this.m_21223_();
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        boolean success = false;
        if (!player.m_5833_() && player.m_150110_().f_35938_) {
            ItemStack itemstack = player.m_21120_(hand);
            EquipmentSlot equipmentSlot = TargetDummyEntity.m_147233_((ItemStack)itemstack);
            Item item = itemstack.m_41720_();
            if (DummyMobType.get(itemstack) != DummyMobType.UNDEFINED || ForgeHelper.canEquipItem((LivingEntity)this, (ItemStack)itemstack, (EquipmentSlot)EquipmentSlot.HEAD)) {
                equipmentSlot = EquipmentSlot.HEAD;
            }
            Level level = player.m_9236_();
            if (itemstack.m_41619_() && hand == InteractionHand.MAIN_HAND) {
                equipmentSlot = this.getClickedSlot(vec);
                if (equipmentSlot == null) {
                    equipmentSlot = this.m_21033_(EquipmentSlot.MAINHAND) ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
                }
                if (this.m_21033_(equipmentSlot)) {
                    if (level.f_46443_) {
                        return InteractionResult.CONSUME;
                    }
                    this.swapItem(player, equipmentSlot, ItemStack.f_41583_, hand);
                    success = true;
                }
            } else if (equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR) {
                if (level.f_46443_) {
                    return InteractionResult.CONSUME;
                }
                this.swapItem(player, equipmentSlot, itemstack, hand);
                success = true;
            } else if (itemstack.m_41720_() instanceof ShieldItem) {
                this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                if (level.f_46443_) {
                    return InteractionResult.CONSUME;
                }
                this.swapItem(player, EquipmentSlot.MAINHAND, itemstack, hand);
                success = true;
            } else if (item instanceof ShearsItem) {
                if (!this.isSheared()) {
                    player.m_5496_(SoundEvents.f_12480_, 1.0f, 1.0f);
                    if (level.f_46443_) {
                        return InteractionResult.CONSUME;
                    }
                    this.setSheared(true);
                    return InteractionResult.SUCCESS;
                }
            } else if (item instanceof BannerItem) {
                this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
                if (level.f_46443_) {
                    return InteractionResult.CONSUME;
                }
                this.swapItem(player, EquipmentSlot.OFFHAND, itemstack, hand);
                this.setBoss(true);
                return InteractionResult.SUCCESS;
            }
            if (success) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    private void swapItem(Player player, EquipmentSlot slot, ItemStack armor, InteractionHand hand) {
        ItemStack oldArmor = this.m_6844_(slot);
        player.m_21008_(hand, oldArmor.m_41777_());
        this.m_21468_(slot, armor);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.setBoss(false);
    }

    @Nullable
    private EquipmentSlot getClickedSlot(Vec3 vec3) {
        EquipmentSlot equipmentSlot = null;
        double d0 = vec3.f_82480_;
        EquipmentSlot slot = EquipmentSlot.FEET;
        if (d0 >= 0.1 && d0 < 0.55 && this.m_21033_(slot)) {
            equipmentSlot = EquipmentSlot.FEET;
        } else if (d0 >= 0.9 && d0 < 1.6 && this.m_21033_(EquipmentSlot.CHEST)) {
            equipmentSlot = EquipmentSlot.CHEST;
        } else if (d0 >= 0.4 && d0 < 1.2000000000000002 && this.m_21033_(EquipmentSlot.LEGS)) {
            equipmentSlot = EquipmentSlot.LEGS;
        } else if (d0 >= 1.6 && this.m_21033_(EquipmentSlot.HEAD)) {
            equipmentSlot = EquipmentSlot.HEAD;
        }
        return equipmentSlot;
    }

    public void m_5907_() {
        this.dropPreservedEquipment(s -> true);
        this.m_5552_(this.m_142340_(), 1.0f);
    }

    public Set<EquipmentSlot> dropPreservedEquipment(Predicate<ItemStack> predicate) {
        HashSet<EquipmentSlot> set = new HashSet<EquipmentSlot>();
        for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
            ItemStack itemStack = this.m_6844_(equipmentSlot);
            if (itemStack.m_41619_()) continue;
            if (!predicate.test(itemStack)) {
                set.add(equipmentSlot);
                continue;
            }
            double d = this.m_21519_(equipmentSlot);
            if (!(d > 1.0)) continue;
            this.m_8061_(equipmentSlot, ItemStack.f_41583_);
            this.m_5552_(itemStack, 1.0f);
        }
        return set;
    }

    public void dismantle(boolean drops) {
        Level level = this.m_9236_();
        if (!level.f_46443_ && this.m_6084_()) {
            if (drops) {
                this.m_5907_();
            }
            this.m_5496_(this.m_5592_(), 1.0f, 1.0f);
            ((ServerLevel)level).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50705_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_146850_(GameEvent.f_223707_);
        }
    }

    private void setRecharging() {
        this.healthRechargeTimer = 160;
        CombatTracker tracker = this.m_21231_();
        tracker.f_19276_.clear();
        this.playersTracker.finishFight();
        this.m_9236_().m_7605_((Entity)this, (byte)32);
    }

    public float getRechargingAnimation(float partialTicks) {
        return Math.max(0.0f, Mth.m_14179_((float)partialTicks, (float)this.healthRechargeTimer, (float)(this.healthRechargeTimer - 1)) / 160.0f);
    }

    public boolean isRecharging() {
        return this.healthRechargeTimer > 0;
    }

    public boolean hasInfiniteHealth() {
        return !this.isBoss() || !this.playersTracker.hasPlayers();
    }

    @NotNull
    public ItemStack m_142340_() {
        ItemStack itemStack = new ItemStack((ItemLike)Dummmmmmy.DUMMY_ITEM.get());
        if (this.m_8077_()) {
            itemStack.m_41714_(this.m_7770_());
        }
        return itemStack;
    }

    public void m_6074_() {
        this.dismantle(true);
    }

    public boolean m_21254_() {
        return this.shieldCooldown == 0 && !this.m_21120_(InteractionHand.MAIN_HAND).m_41619_();
    }

    protected void m_6728_(LivingEntity attacker) {
        super.m_6728_(attacker);
        if (DummyPlatStuff.canDisableShield(attacker, this.f_20935_, this)) {
            this.disableShield();
        } else {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        }
    }

    private void disableShield() {
        this.shieldCooldown = 100;
        this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
        this.m_9236_().m_7605_((Entity)this, (byte)30);
    }

    public void m_7822_(byte id) {
        if (id == 30) {
            this.shieldCooldown = 100;
        }
        if (id == 32) {
            this.healthRechargeTimer = 160;
        }
        super.m_7822_(id);
    }

    public boolean m_6673_(DamageSource source) {
        return this.isRecharging() || super.m_6673_(source) || source == this.m_269291_().m_269063_() || source == this.m_269291_().m_269318_();
    }

    public boolean m_6469_(DamageSource source, float damage) {
        CritRecord critRecord;
        LivingEntity livingEntity;
        TamableAnimal animal;
        Entity sp;
        if (source == this.m_269291_().m_269341_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            return true;
        }
        if (source.m_7640_() instanceof WitherBoss || source.m_7639_() instanceof WitherBoss) {
            this.dismantle(true);
            return true;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player instanceof ServerPlayer) {
                sp = (ServerPlayer)player;
                this.playersTracker.track((ServerPlayer)sp);
            }
            if (player.m_6144_() && player.m_21205_().m_41619_() && !this.unbreakable && player.m_150110_().f_35938_) {
                this.dismantle(!player.m_7500_());
                return false;
            }
        }
        if ((sp = source.m_7639_()) instanceof TamableAnimal && (animal = (TamableAnimal)sp).m_21824_() && (livingEntity = animal.m_269323_()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            this.playersTracker.track(player);
        }
        if (this.m_9236_().f_46443_) {
            return false;
        }
        DamageSource old = this.currentDamageSource;
        this.currentDamageSource = source;
        if (!this.critRecordsThisTick.isEmpty() && (critRecord = this.critRecordsThisTick.get(this.critRecordsThisTick.size() - 1)).canCompleteWith(source)) {
            critRecord.addSource(source);
        }
        boolean result = super.m_6469_(source, damage);
        this.currentDamageSource = old;
        this.f_20916_ = 0;
        return result;
    }

    public void m_21153_(float newHealth) {
        if (newHealth == this.m_21233_()) {
            super.m_21153_(newHealth);
        } else {
            Level level = this.m_9236_();
            if (level.f_46443_) {
                return;
            }
            float damage = this.m_21223_() - newHealth;
            DamageSource actualSource = this.getActualDamageSource(damage);
            if (actualSource != null || damage < 0.0f) {
                this.onActuallyDamagedOrTrueDamageDetected(damage, actualSource);
            }
            this.lastTickActuallyDamaged = this.f_19797_;
            if (!this.hasInfiniteHealth()) {
                this.doSetHealth(newHealth);
                if (newHealth <= 0.0f) {
                    this.setRecharging();
                }
            }
        }
    }

    private void doSetHealth(float newHealth) {
        super.m_21153_(newHealth);
        this.lastHealth = this.m_21223_();
        this.playersTracker.updateHealth();
    }

    @Nullable
    private DamageSource getActualDamageSource(float damage) {
        DamageSource actualSource = null;
        if (PlatHelper.getPlatform().isForge()) {
            CombatEntry currentCombatEntry = this.getLastEntry();
            if (currentCombatEntry != null && this.m_21231_().f_19278_ == this.f_19797_) {
                actualSource = currentCombatEntry.f_19250_();
                if ((double)Math.abs(damage - currentCombatEntry.f_19252_()) > 1.0E-4) {
                    boolean bl = false;
                }
            }
        } else {
            actualSource = this.currentDamageSource;
        }
        return actualSource;
    }

    public boolean m_21224_() {
        return false;
    }

    private void onActuallyDamagedOrTrueDamageDetected(float damage, @Nullable DamageSource actualSource) {
        if (this.isRecharging()) {
            return;
        }
        if (damage < 0.0f) {
            this.playersTracker.getPlayers().forEach(this.playersTracker::track);
        }
        this.showDamageAndAnimationsToClients(damage, actualSource);
        if (damage < 0.0f) {
            this.totalHealingTakenInCombat -= damage;
        } else {
            this.totalDamageTakenInCombat += damage;
        }
        this.updateTargetBlock(damage);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            float xp;
            ServerLevel sl = (ServerLevel)level;
            if (damage > 0.0f && (xp = CommonConfigs.DROP_XP.get().floatValue() * damage) > 0.0f) {
                ExperienceOrb.m_147082_((ServerLevel)sl, (Vec3)this.m_20182_().m_82520_(0.0, 0.5, 0.0), (int)Mth.m_14143_((float)xp));
            }
        }
    }

    @Nullable
    public CombatEntry getLastEntry() {
        CombatTracker tracker = this.m_21231_();
        if (tracker.f_19276_.isEmpty()) {
            return null;
        }
        return (CombatEntry)tracker.f_19276_.get(tracker.f_19276_.size() - 1);
    }

    private void showDamageAndAnimationsToClients(float damage, @Nullable DamageSource source) {
        if (this.lastTickActuallyDamaged != this.f_19797_) {
            this.animationPosition = 0.0f;
        }
        if (damage > 0.0f) {
            this.animationPosition = Math.min(this.animationPosition + damage, 60.0f);
            NetworkHandler.CHANNEL.sentToAllClientPlayersTrackingEntity((Entity)this, (Message)new ClientBoundUpdateAnimationMessage(this.m_19879_(), this.animationPosition));
        }
        if (this.playersTracker.hasPlayers()) {
            CritRecord critRec = null;
            for (int j = this.critRecordsThisTick.size() - 1; j >= 0; --j) {
                CritRecord c = this.critRecordsThisTick.get(j);
                if (!c.matches(source)) continue;
                critRec = c;
                break;
            }
            for (ServerPlayer p : this.playersTracker.getPlayers()) {
                NetworkHandler.CHANNEL.sendToClientPlayer(p, (Message)new ClientBoundDamageNumberMessage((LivingEntity)this, damage, source, critRec));
            }
            if (critRec != null) {
                this.critRecordsThisTick.remove(critRec);
            }
        }
    }

    private void updateTargetBlock(float damage) {
        Level level;
        BlockPos pos = this.m_20097_();
        BlockState state = this.m_20075_();
        if (state.m_60734_() instanceof TargetBlock && !(level = this.m_9236_()).m_183326_().m_183582_(pos, (Object)state.m_60734_())) {
            int power = (int)Mth.m_14036_((float)(damage / this.m_21223_() * 15.0f), (float)1.0f, (float)15.0f);
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61426_, (Comparable)Integer.valueOf(power)), 3);
            level.m_186460_(pos, state.m_60734_(), 20);
        }
    }

    protected void m_8022_() {
    }

    protected Vec3 m_7939_() {
        return new Vec3(0.0, (double)(this.m_20192_() - 1.0f), 0.0);
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public void m_8119_() {
        if (this.shieldCooldown > 0) {
            --this.shieldCooldown;
        }
        this.critRecordsThisTick.clear();
        Level level = this.m_9236_();
        BlockPos onPos = this.m_20097_();
        float health = this.m_21223_();
        if (!level.f_46443_) {
            float trueDamage;
            if (this.lastTickActuallyDamaged + 1 == this.f_19797_ && !level.f_46443_ && (trueDamage = this.lastHealth - health) > 0.0f) {
                if (this.hasInfiniteHealth()) {
                    this.m_5634_(trueDamage);
                }
                this.onActuallyDamagedOrTrueDamageDetected(trueDamage, null);
            }
            if (level.m_46467_() % 20L == 0L && level.m_46859_(onPos)) {
                this.dismantle(true);
                return;
            }
        }
        if (this.healthRechargeTimer != 0) {
            --this.healthRechargeTimer;
            this.doSetHealth(health + this.m_21233_() / 160.0f);
            if (this.healthRechargeTimer == 0) {
                this.playersTracker.clear();
                this.totalHealingTakenInCombat = 0.0f;
                this.totalDamageTakenInCombat = 0.0f;
            }
        }
        this.m_20242_(true);
        BlockState onState = level.m_8055_(onPos);
        onState.m_60734_().m_141947_(level, onPos, onState, (Entity)this);
        super.m_8119_();
        if (level.f_46443_) {
            this.f_20916_ = 0;
            this.prevShakeAmount = this.shakeAmount;
            this.prevAnimationPosition = this.animationPosition;
            if (this.animationPosition > 0.0f) {
                this.shakeAmount += 1.0f;
                this.animationPosition -= 0.8f;
                if (this.animationPosition <= 0.0f) {
                    this.shakeAmount = 0.0f;
                    this.animationPosition = 0.0f;
                }
            }
        } else {
            this.displayCombatMessages();
        }
    }

    private void displayCombatMessages() {
        CombatTracker tracker = this.m_21231_();
        if (tracker.f_19281_) {
            float combatDuration = tracker.m_19295_();
            this.playersTracker.update(combatDuration, this.totalDamageTakenInCombat, this.totalHealingTakenInCombat);
        } else {
            this.totalDamageTakenInCombat = 0.0f;
            if (!this.playersTracker.hasPlayers()) {
                this.totalHealingTakenInCombat = 0.0f;
            }
        }
    }

    public void m_20256_(Vec3 motionIn) {
    }

    public void m_147240_(double strength, double x, double z) {
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_6040_() {
        return true;
    }

    protected boolean m_6107_() {
        return true;
    }

    public boolean m_6090_() {
        return true;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_5834_() {
    }

    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_20242_(boolean ignored) {
        super.m_20242_(true);
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return SoundEvents.f_11683_;
    }

    @NotNull
    public SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    @NotNull
    public MobType m_6336_() {
        return this.mobType.getType();
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.playersTracker.healthBar.m_6456_(this.m_5446_());
    }

    public void m_6452_(ServerPlayer serverPlayer) {
        super.m_6452_(serverPlayer);
        this.playersTracker.unTrack(serverPlayer);
    }

    public static AttributeSupplier.Builder makeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22276_, (double)CommonConfigs.BOSS_HEALTH.get().intValue()).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22280_, 0.0);
    }

    public void updateAnimation(float shake) {
        this.animationPosition = shake;
    }

    public void moist(Entity attacker, float critModifier) {
        this.critRecordsThisTick.add(new CritRecord(attacker, critModifier));
    }

    public int getNextNumberPos() {
        return this.damageNumberPos++;
    }

    private void showDpsMessageTo(ServerPlayer player, float combatDuration, float dps, float hps, boolean outOfCompat) {
        boolean showMessage;
        CommonConfigs.DpsMode dpsMode = CommonConfigs.DYNAMIC_DPS.get();
        if (dpsMode != CommonConfigs.DpsMode.OFF && combatDuration > 0.0f && (showMessage = dpsMode == CommonConfigs.DpsMode.DYNAMIC ? this.lastTickActuallyDamaged + 1 == this.f_19797_ : outOfCompat) && player.m_20270_((Entity)this) < 64.0f) {
            MutableComponent message;
            MutableComponent dpsMessage = Component.m_237110_((String)"message.dummmmmmy.dps", (Object[])new Object[]{Dummmmmmy.DF2.format(dps)});
            MutableComponent hpsMessage = Component.m_237110_((String)"message.dummmmmmy.hps", (Object[])new Object[]{Dummmmmmy.DF2.format(hps)});
            if (dps > 0.0f && hps > 0.0f) {
                message = Component.m_237110_((String)"message.dummmmmmy.double", (Object[])new Object[]{this.m_5446_(), dpsMessage, hpsMessage});
            } else if (dps > 0.0f) {
                message = Component.m_237110_((String)"message.dummmmmmy.single", (Object[])new Object[]{this.m_5446_(), dpsMessage});
            } else if (hps > 0.0f) {
                message = Component.m_237110_((String)"message.dummmmmmy.single", (Object[])new Object[]{this.m_5446_(), hpsMessage});
            } else {
                return;
            }
            player.m_5661_((Component)message, true);
        }
    }

    private class PlayersTracker {
        private final Map<ServerPlayer, Integer> currentlyAttacking = new HashMap<ServerPlayer, Integer>();
        private final ServerBossEvent healthBar = new ServerBossEvent(TargetDummyEntity.this.m_5446_(), CommonConfigs.BOSS_HEALTH_COLOR.get(), BossEvent.BossBarOverlay.NOTCHED_12);

        private PlayersTracker() {
        }

        public void showHealthBar(boolean on) {
            this.healthBar.m_8321_(on);
            if (!on) {
                this.healthBar.m_7706_();
            }
        }

        public void updateHealth() {
            this.healthBar.m_142711_(TargetDummyEntity.this.m_21223_() / TargetDummyEntity.this.m_21233_());
        }

        public void track(ServerPlayer serverPlayer) {
            this.currentlyAttacking.put(serverPlayer, 300);
            this.healthBar.m_6543_(serverPlayer);
        }

        public void unTrack(ServerPlayer serverPlayer) {
            this.currentlyAttacking.remove(serverPlayer);
            if (!TargetDummyEntity.this.isRecharging()) {
                this.healthBar.m_6539_(serverPlayer);
            }
        }

        public void update(float combatDuration, float totalDamageTakenInCombat, float totalHealingTakenInCombat) {
            ArrayList<ServerPlayer> removedPlayers = new ArrayList<ServerPlayer>();
            float seconds = combatDuration / 20.0f + 1.0f;
            float dps = totalDamageTakenInCombat / seconds;
            float hps = totalHealingTakenInCombat / seconds;
            for (Map.Entry<ServerPlayer, Integer> e : this.currentlyAttacking.entrySet()) {
                ServerPlayer p = e.getKey();
                int timer = e.getValue() - 1;
                this.currentlyAttacking.replace(p, timer);
                boolean outOfCombat = false;
                if (timer <= 0) {
                    removedPlayers.add(p);
                    outOfCombat = true;
                }
                TargetDummyEntity.this.showDpsMessageTo(p, combatDuration, dps, hps, outOfCombat);
            }
            removedPlayers.forEach(this::unTrack);
        }

        public boolean hasPlayers() {
            return !this.currentlyAttacking.isEmpty();
        }

        public Collection<ServerPlayer> getPlayers() {
            return this.currentlyAttacking.keySet();
        }

        public void clear() {
            this.currentlyAttacking.clear();
            this.healthBar.m_7706_();
        }

        public void finishFight() {
            this.currentlyAttacking.replaceAll((p, i) -> 0);
        }
    }
}

