/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.util.client;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.util.CustomComponentParser;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TextComponentParser;
import dev.ftb.mods.ftblibrary.util.client.ImageComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.gui.Font;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ClientTextComponentUtils {
    private static final Function<String, Component> DEFAULT_STRING_TO_COMPONENT = ClientTextComponentUtils::defaultStringToComponent;
    private static final List<CustomComponentParser> CUSTOM_COMPONENT_PARSERS = new ArrayList<CustomComponentParser>();

    public static void addCustomParser(CustomComponentParser function) {
        CUSTOM_COMPONENT_PARSERS.add(function);
    }

    public static Component parse(String s) {
        return TextComponentParser.parse(s, DEFAULT_STRING_TO_COMPONENT);
    }

    private static Component defaultStringToComponent(String s) {
        if (s.isEmpty()) {
            return Component.m_237119_();
        }
        if (s.indexOf(58) != -1) {
            Map<String, String> map = StringUtils.splitProperties(s);
            for (CustomComponentParser parser : CUSTOM_COMPONENT_PARSERS) {
                Component c = parser.parse(s, map);
                if (c == null || c == Component.f_130760_) continue;
                return c;
            }
            if (map.containsKey("image")) {
                ImageComponent c = new ImageComponent();
                c.image = Icon.getIcon(map.get("image"));
                if (map.containsKey("width")) {
                    c.width = Integer.parseInt(map.get("width"));
                }
                if (map.containsKey("height")) {
                    c.height = Integer.parseInt(map.get("height"));
                }
                c.align = ImageComponent.ImageAlign.fromString(map.getOrDefault("align", "center"));
                c.fit = map.getOrDefault("fit", "false").equals("true");
                MutableComponent output = MutableComponent.m_237204_((ComponentContents)c);
                if (map.containsKey("text")) {
                    output.m_130948_(Style.f_131099_.m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)ClientTextComponentUtils.parse(map.get("text")))));
                }
                return output;
            }
            if (map.containsKey("open_url")) {
                return ClientTextComponentUtils.parse(map.get("text")).m_6881_().m_130948_(Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, map.get("open_url"))));
            }
        }
        return ClientTextComponentUtils.parse(I18n.m_118938_((String)s, (Object[])new Object[0]));
    }

    public static FormattedText ellipsize(Font font, FormattedText text, int maxWidth) {
        int strWidth = font.m_92852_(text);
        int ellipsisWidth = font.m_92852_((FormattedText)CommonComponents.f_238772_);
        if (strWidth > maxWidth) {
            return ellipsisWidth >= maxWidth ? font.m_92854_(text, maxWidth) : FormattedText.m_130773_((FormattedText[])new FormattedText[]{font.m_92854_(text, maxWidth - ellipsisWidth), CommonComponents.f_238772_});
        }
        return text;
    }
}

