/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.nbtedit;

import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.DoubleConfig;
import dev.ftb.mods.ftblibrary.config.IntConfig;
import dev.ftb.mods.ftblibrary.config.LongConfig;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.config.ui.EditStringConfigOverlay;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.IconWithBorder;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractThreePanelScreen;
import dev.ftb.mods.ftblibrary.ui.misc.SimpleToast;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftblibrary.util.TextComponentUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftblibrary.util.client.PositionedIngredient;
import it.unimi.dsi.fastutil.bytes.ByteArrayList;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTEditorScreen
extends AbstractThreePanelScreen<NBTPanel> {
    private static final int TOP_PANEL_H = 20;
    public static final Icon NBT_BYTE = NBTEditorScreen.getIcon("byte");
    public static final Icon NBT_SHORT = NBTEditorScreen.getIcon("short");
    public static final Icon NBT_INT = NBTEditorScreen.getIcon("int");
    public static final Icon NBT_LONG = NBTEditorScreen.getIcon("long");
    public static final Icon NBT_FLOAT = NBTEditorScreen.getIcon("float");
    public static final Icon NBT_DOUBLE = NBTEditorScreen.getIcon("double");
    public static final Icon NBT_STRING = NBTEditorScreen.getIcon("string");
    public static final Icon NBT_LIST = NBTEditorScreen.getIcon("list");
    public static final Icon NBT_LIST_CLOSED = NBTEditorScreen.getIcon("list").combineWith(NBTEditorScreen.getIcon("map_closed").withColor(Color4I.rgba(-1056964609)));
    public static final Icon NBT_LIST_OPEN = NBTEditorScreen.getIcon("list");
    public static final Icon NBT_MAP = NBTEditorScreen.getIcon("map");
    public static final Icon NBT_MAP_CLOSED = NBTEditorScreen.getIcon("map").combineWith(NBTEditorScreen.getIcon("map_closed").withColor(Color4I.rgba(-1056964609)));
    public static final Icon NBT_MAP_OPEN = NBTEditorScreen.getIcon("map");
    public static final Icon NBT_BYTE_ARRAY = NBTEditorScreen.getIcon("byte_array");
    public static final Icon NBT_BYTE_ARRAY_CLOSED = NBTEditorScreen.getIcon("byte_array_closed");
    public static final Icon NBT_BYTE_ARRAY_OPEN = NBTEditorScreen.getIcon("byte_array_open");
    public static final Icon NBT_INT_ARRAY = NBTEditorScreen.getIcon("int_array");
    public static final Icon NBT_INT_ARRAY_CLOSED = NBTEditorScreen.getIcon("int_array_closed");
    public static final Icon NBT_INT_ARRAY_OPEN = NBTEditorScreen.getIcon("int_array_open");
    private final CompoundTag info;
    private final NBTCallback callback;
    private final ButtonNBTMap buttonNBTRoot;
    private ButtonNBT selected;
    public final Panel panelTopLeft;
    public final Panel panelTopRight;
    private boolean accepted = false;

    public NBTEditorScreen(CompoundTag info, CompoundTag nbt, NBTCallback callback) {
        this.info = info;
        this.callback = callback;
        this.panelTopLeft = new TopLeftPanel();
        this.panelTopRight = new TopRightPanel();
        this.buttonNBTRoot = new ButtonNBTMap(this.mainPanel, null, this.getInfoTitle(info), nbt);
        this.buttonNBTRoot.updateChildren(true);
        this.buttonNBTRoot.setCollapsedTree(true);
        this.buttonNBTRoot.setCollapsed(false);
        this.setSelected(this.buttonNBTRoot);
    }

    private String getInfoTitle(CompoundTag info) {
        if (info.m_128441_("title")) {
            MutableComponent title = Component.Serializer.m_130701_((String)info.m_128461_("title"));
            if (title != null) {
                return title.getString();
            }
        } else if (info.m_128441_("type")) {
            return info.m_128461_("type").toUpperCase();
        }
        return "ROOT";
    }

    private void collapseAll(boolean collapse) {
        for (Widget w : ((NBTPanel)this.mainPanel).getWidgets()) {
            if (!(w instanceof ButtonNBTCollection)) continue;
            ButtonNBTCollection collection = (ButtonNBTCollection)w;
            collection.setCollapsedTree(collapse);
        }
        ((NBTPanel)this.mainPanel).refreshWidgets();
    }

    @Override
    protected void doCancel() {
        this.getGui().closeGui();
    }

    @Override
    protected void doAccept() {
        this.accepted = true;
        this.getGui().closeGui();
    }

    @Override
    protected int getTopPanelHeight() {
        return 20;
    }

    @Override
    protected NBTPanel createMainPanel() {
        return new NBTPanel();
    }

    @Override
    protected Panel createTopPanel() {
        return new CustomTopPanel();
    }

    private void setSelected(@NotNull ButtonNBT newSelected) {
        ButtonNBT prevSelected = this.selected;
        this.selected = newSelected;
        if (prevSelected != null) {
            prevSelected.updateTitle();
        }
        this.selected.updateTitle();
    }

    @Override
    public boolean onInit() {
        return this.setSizeProportional(0.75f, 0.9f);
    }

    @Override
    public void onClosed() {
        super.onClosed();
        this.callback.handle(this.accepted, this.buttonNBTRoot.map);
    }

    @Override
    public boolean doesGuiPauseGame() {
        return true;
    }

    @Override
    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if ((key.is(257) || key.is(335)) && key.modifiers.shift()) {
            this.doAccept();
            return true;
        }
        if (key.is(334) || key.is(61)) {
            this.collapseAll(false);
        } else if (key.is(45) || key.is(333)) {
            this.collapseAll(true);
        } else if (key.is(67) && key.modifiers.control()) {
            this.copyToClipboard();
        }
        return false;
    }

    private void copyToClipboard() {
        NBTEditorScreen.setClipboardString(this.selected.toNBT().toString());
        SimpleToast.info((Component)Component.m_237115_((String)"ftblibrary.gui.nbt_copied"), (Component)Component.m_237113_((String)" "));
    }

    private ButtonNBT makeNBTButton(ButtonNBTCollection parent, String key) {
        Tag nbt = parent.getTag(key);
        return switch (nbt.m_7060_()) {
            case 10 -> new ButtonNBTMap(this.mainPanel, parent, key, (CompoundTag)nbt);
            case 9 -> new ButtonNBTList(this.mainPanel, parent, key, (ListTag)nbt);
            case 7 -> new ButtonNBTByteArray(this.mainPanel, parent, key, (ByteArrayTag)nbt);
            case 11 -> new ButtonNBTIntArray(this.mainPanel, parent, key, (IntArrayTag)nbt);
            default -> new ButtonBasicTag(this.mainPanel, parent, key, nbt);
        };
    }

    public SimpleButton newTag(Panel panel, String title, Icon icon, Supplier<Tag> supplier) {
        return new SimpleButton(panel, (Component)Component.m_237113_((String)title), icon, (btn, mb) -> {
            if (this.selected instanceof ButtonNBTMap) {
                StringConfig value = new StringConfig(Pattern.compile("^.+$"));
                EditStringConfigOverlay<String> overlay = new EditStringConfigOverlay<String>(this, value, arg_0 -> this.lambda$newTag$0(value, (Supplier)supplier, arg_0));
                overlay.setPos(btn.posX, btn.posY + btn.height + 4);
                this.getGui().pushModalPanel(overlay);
            } else if (this.selected instanceof ButtonNBTCollection) {
                ((ButtonNBTCollection)this.selected).setTag("-1", (Tag)supplier.get());
                this.selected.updateChildren(false);
                ((NBTPanel)this.mainPanel).refreshWidgets();
            }
        }){

            @Override
            public void drawBackground(GuiGraphics stack, Theme theme, int x, int y, int w, int h) {
                IconWithBorder.BUTTON_ROUND_GRAY.draw(stack, x, y, w, h);
            }
        };
    }

    private static Icon getIcon(String name) {
        return Icon.getIcon("ftblibrary:textures/icons/nbt/" + name + ".png");
    }

    private /* synthetic */ void lambda$newTag$0(StringConfig value, Supplier supplier, boolean accepted) {
        if (accepted && !((String)value.getValue()).isEmpty()) {
            ((ButtonNBTCollection)this.selected).setTag((String)value.getValue(), (Tag)supplier.get());
            this.selected.updateChildren(false);
            ((NBTPanel)this.mainPanel).refreshWidgets();
        }
        this.openGui();
    }

    public static interface NBTCallback {
        public void handle(boolean var1, CompoundTag var2);
    }

    private class TopLeftPanel
    extends Panel {
        public TopLeftPanel() {
            super(NBTEditorScreen.this.topPanel);
        }

        @Override
        public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
            super.draw(graphics, theme, x, y, w, h);
        }

        @Override
        public void addWidgets() {
            List<Widget> addBtns;
            this.add(new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"selectServer.delete"), NBTEditorScreen.this.selected == NBTEditorScreen.this.buttonNBTRoot ? Icons.BIN.combineWith((Icon)Color4I.rgba(-1071636448)) : Icons.BIN, (widget, button) -> this.deleteTag()));
            boolean canRename = NBTEditorScreen.this.selected.parent instanceof ButtonNBTMap;
            Icon renameIcon = Icons.NOTES;
            this.add(new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"ftblibrary.gui.edit_tag_name"), canRename ? renameIcon : renameIcon.combineWith((Icon)Color4I.rgba(-1071636448)), (btn, mb) -> {
                if (canRename) {
                    this.getGui().pushModalPanel(this.makeRenameOverlay(btn));
                }
            }));
            if (NBTEditorScreen.this.selected instanceof ButtonBasicTag) {
                this.add(new SimpleButton((Panel)this, (Component)Component.m_237115_((String)"ftblibrary.gui.edit_tag_value"), Icons.FEATHER, (widget, button) -> ((ButtonBasicTag)NBTEditorScreen.this.selected).edit()));
            }
            if (!(addBtns = this.buildAddButtons()).isEmpty()) {
                TextField addLabel = new TextField(this).setText((Component)Component.m_237113_((String)"   ").m_7220_((Component)Component.m_237115_((String)"gui.add"))).addFlags(32);
                this.add(addLabel);
                this.addAll(addBtns);
            }
        }

        private void deleteTag() {
            if (NBTEditorScreen.this.selected != NBTEditorScreen.this.buttonNBTRoot && NBTEditorScreen.this.selected.parent != null) {
                NBTEditorScreen.this.selected.parent.setTag(NBTEditorScreen.this.selected.key, null);
                NBTEditorScreen.this.selected.parent.updateChildren(false);
                NBTEditorScreen.this.setSelected(NBTEditorScreen.this.selected.parent);
                ((NBTPanel)NBTEditorScreen.this.mainPanel).refreshWidgets();
                NBTEditorScreen.this.panelTopLeft.refreshWidgets();
            }
        }

        @NotNull
        private List<Widget> buildAddButtons() {
            ArrayList<Widget> addBtns = new ArrayList<Widget>();
            if (NBTEditorScreen.this.selected.canCreateNew(10)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Compound", NBT_MAP, CompoundTag::new));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(9)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "List", NBT_LIST, ListTag::new));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(8)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "String", NBT_STRING, () -> StringTag.m_129297_((String)"")));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(1)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Byte", NBT_BYTE, () -> ByteTag.m_128266_((byte)0)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(2)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Short", NBT_SHORT, () -> ShortTag.m_129258_((short)0)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(3)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Int", NBT_INT, () -> IntTag.m_128679_((int)0)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(4)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Long", NBT_LONG, () -> LongTag.m_128882_((long)0L)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(5)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Float", NBT_FLOAT, () -> FloatTag.m_128566_((float)0.0f)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(6)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Double", NBT_DOUBLE, () -> DoubleTag.m_128500_((double)0.0)));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(7)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Byte Array", NBT_BYTE_ARRAY, () -> new ByteArrayTag(new byte[0])));
            }
            if (NBTEditorScreen.this.selected.canCreateNew(11)) {
                addBtns.add(NBTEditorScreen.this.newTag(this, "Int Array", NBT_INT_ARRAY, () -> new IntArrayTag(new int[0])));
            }
            return addBtns;
        }

        @NotNull
        private EditStringConfigOverlay<String> makeRenameOverlay(SimpleButton button) {
            StringConfig value = new StringConfig();
            if (NBTEditorScreen.this.selected != null) {
                value.setValue(NBTEditorScreen.this.selected.key);
            }
            EditStringConfigOverlay<String> overlay = new EditStringConfigOverlay<String>(this, value, accepted -> {
                if (accepted && !((String)value.getValue()).isEmpty() && NBTEditorScreen.this.selected.parent != null) {
                    ButtonNBTCollection parent = NBTEditorScreen.this.selected.parent;
                    Tag nbt = parent.getTag(NBTEditorScreen.this.selected.key);
                    parent.setTag(NBTEditorScreen.this.selected.key, null);
                    parent.setTag((String)value.getValue(), nbt);
                    parent.updateChildren(false);
                    NBTEditorScreen.this.setSelected(parent.children.get(value.getValue()));
                    ((NBTPanel)NBTEditorScreen.this.mainPanel).refreshWidgets();
                }
                this.getGui().openGui();
            }, (Component)Component.m_237113_((String)"New name"));
            overlay.setPos(button.posX, button.posY + button.height + 4);
            overlay.setExtraZlevel(300);
            return overlay;
        }

        @Override
        public void alignWidgets() {
            this.setWidth(this.align(new WidgetLayout.Horizontal(2, 4, 2)));
            this.widgets.forEach(w -> w.setY((20 - w.height) / 2 - 2));
        }
    }

    private class TopRightPanel
    extends Panel {
        public TopRightPanel() {
            super(NBTEditorScreen.this.topPanel);
        }

        @Override
        public void addWidgets() {
            this.add(new SimpleButton((Panel)this, List.of(Component.m_237115_((String)"gui.copy"), TextComponentUtils.hotkeyTooltip("Ctrl + C")), ItemIcon.getItemIcon(Items.f_42516_), (widget, button) -> NBTEditorScreen.this.copyToClipboard()));
            this.add(new SimpleButton((Panel)this, List.of(Component.m_237115_((String)"gui.collapse_all"), TextComponentUtils.hotkeyTooltip("-")), Icons.DOWN, (widget, button) -> NBTEditorScreen.this.collapseAll(true)));
            this.add(new SimpleButton((Panel)this, List.of(Component.m_237115_((String)"gui.expand_all"), TextComponentUtils.hotkeyTooltip("="), TextComponentUtils.hotkeyTooltip("+")), Icons.UP, (widget, button) -> NBTEditorScreen.this.collapseAll(false)));
        }

        @Override
        public void alignWidgets() {
            this.setWidth(this.align(new WidgetLayout.Horizontal(2, 4, 2)));
        }
    }

    public class ButtonNBTMap
    extends ButtonNBTCollection {
        private final CompoundTag map;
        private Icon hoverIcon;

        public ButtonNBTMap(@Nullable Panel panel, ButtonNBTCollection parent, String key, CompoundTag map) {
            super(panel, parent, key, NBT_MAP_OPEN, NBT_MAP_CLOSED);
            this.hoverIcon = Icon.empty();
            this.map = map;
        }

        @Override
        public void updateTitle() {
            this.setTitle((Component)Component.m_237113_((String)this.key).m_130940_(this.isSelected() ? ChatFormatting.GREEN : ChatFormatting.DARK_GREEN));
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            this.map.m_128431_().stream().sorted(StringUtils.IGNORE_CASE_COMPARATOR).forEach(key -> {
                ButtonNBT nbt = NBTEditorScreen.this.makeNBTButton(this, (String)key);
                this.children.put(key, nbt);
                nbt.updateChildren(first);
            });
            this.updateHoverIcon();
            if (first && !this.hoverIcon.isEmpty()) {
                this.setCollapsed(true);
            }
        }

        private void updateHoverIcon() {
            ItemStack stack;
            this.hoverIcon = Icon.empty();
            if (this.map.m_128425_("id", 8) && this.map.m_128425_("Count", 99) && !(stack = ItemStack.m_41712_((CompoundTag)this.map)).m_41619_()) {
                this.hoverIcon = ItemIcon.getItemIcon(stack);
            }
            this.setWidth(12 + NBTEditorScreen.this.getTheme().getStringWidth((FormattedText)this.getTitle()) + (this.hoverIcon.isEmpty() ? 0 : 10));
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            ListTag infoList;
            if (this == NBTEditorScreen.this.buttonNBTRoot && !(infoList = NBTEditorScreen.this.info.m_128437_("text", 8)).isEmpty()) {
                list.add((Component)Component.m_237115_((String)"gui.info").m_130946_(":"));
                for (int i = 0; i < infoList.size(); ++i) {
                    MutableComponent component = Component.Serializer.m_130701_((String)infoList.m_128778_(i));
                    if (component == null) continue;
                    list.add((Component)component);
                }
            }
        }

        @Override
        public void draw(GuiGraphics pose, Theme theme, int x, int y, int w, int h) {
            super.draw(pose, theme, x, y, w, h);
            if (!this.hoverIcon.isEmpty()) {
                this.hoverIcon.draw(pose, x + 12 + theme.getStringWidth((FormattedText)this.getTitle()), y + 1, 8, 8);
            }
        }

        @Override
        public Optional<PositionedIngredient> getIngredientUnderMouse() {
            return PositionedIngredient.of(this.hoverIcon.getIngredient(), this, true);
        }

        @Override
        public Tag getTag(String key) {
            return this.map.m_128423_(key);
        }

        @Override
        public void setTag(String key, @Nullable Tag base) {
            if (base != null) {
                this.map.m_128365_(key, base);
            } else {
                this.map.m_128473_(key);
            }
            this.updateHoverIcon();
            if (this.parent != null) {
                this.parent.setTag(this.key, (Tag)this.map);
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return true;
        }

        @Override
        public CompoundTag toNBT() {
            CompoundTag nbt = this.map.m_6426_();
            if (this == NBTEditorScreen.this.buttonNBTRoot) {
                ListTag infoList1 = new ListTag();
                ListTag infoList0 = NBTEditorScreen.this.info.m_128437_("text", 8);
                if (!infoList0.isEmpty()) {
                    for (int i = 0; i < infoList0.size(); ++i) {
                        MutableComponent component = Component.Serializer.m_130701_((String)infoList0.m_128778_(i));
                        if (component == null) continue;
                        infoList1.add((Object)StringTag.m_129297_((String)component.getString()));
                    }
                    nbt.m_128365_("_", (Tag)infoList1);
                }
            }
            return nbt;
        }
    }

    public abstract class ButtonNBTCollection
    extends ButtonNBT {
        public boolean collapsed;
        public final Map<String, ButtonNBT> children;
        public final Icon iconOpen;
        public final Icon iconClosed;

        public ButtonNBTCollection(@Nullable Panel panel, ButtonNBTCollection parent, String key, Icon open, Icon closed) {
            super(panel, parent, key);
            this.iconOpen = open;
            this.iconClosed = closed;
            this.setCollapsed(false);
            this.setWidth(this.width + 2 + NBTEditorScreen.this.getTheme().getStringWidth(key));
            this.children = new LinkedHashMap<String, ButtonNBT>();
            this.updateTitle();
        }

        @Override
        public void addChildren() {
            if (!this.collapsed) {
                for (ButtonNBT button : this.children.values()) {
                    ((NBTPanel)NBTEditorScreen.this.mainPanel).add(button);
                    button.addChildren();
                }
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            if (this.getMouseX() <= this.getX() + this.height) {
                this.setCollapsed(!this.collapsed);
                ((NBTPanel)NBTEditorScreen.this.mainPanel).refreshWidgets();
            } else {
                NBTEditorScreen.this.setSelected(this);
                NBTEditorScreen.this.panelTopLeft.refreshWidgets();
            }
        }

        @Override
        public boolean mouseDoubleClicked(MouseButton button) {
            if (this.isMouseOver()) {
                this.setCollapsed(!this.collapsed);
                ((NBTPanel)NBTEditorScreen.this.mainPanel).refreshWidgets();
                return true;
            }
            return false;
        }

        public void setCollapsed(boolean c) {
            this.collapsed = c;
            this.setIcon(this.collapsed ? this.iconClosed : this.iconOpen);
        }

        public void setCollapsedTree(boolean c) {
            this.setCollapsed(c);
            for (ButtonNBT button : this.children.values()) {
                if (!(button instanceof ButtonNBTCollection)) continue;
                ButtonNBTCollection collection = (ButtonNBTCollection)button;
                collection.setCollapsedTree(c);
            }
        }

        public abstract Tag getTag(String var1);

        public abstract void setTag(String var1, @Nullable Tag var2);
    }

    public abstract class ButtonNBT
    extends Button {
        protected final ButtonNBTCollection parent;
        protected String key;

        public ButtonNBT(@Nullable Panel panel, ButtonNBTCollection parent, String key) {
            super(panel);
            this.parent = parent;
            this.key = key;
            this.setPosAndSize(parent == null ? 0 : parent.posX + 10, 0, 10, 10);
            this.setTitle((Component)Component.m_237113_((String)this.key));
        }

        public abstract CompoundTag toNBT();

        public void updateChildren(boolean first) {
        }

        public void addChildren() {
        }

        public boolean canCreateNew(int id) {
            return false;
        }

        @Override
        public void addMouseOverText(TooltipList list) {
        }

        @Override
        public void draw(GuiGraphics pose, Theme theme, int x, int y, int w, int h) {
            if (this.isSelected()) {
                Color4I.WHITE.withAlpha(64).draw(pose, x, y, w, h);
            }
            IconWithBorder.BUTTON_ROUND_GRAY.draw(pose, x + 1, y + 1, 8, 8);
            this.drawIcon(pose, theme, x + 1, y + 1, 8, 8);
            theme.drawString(pose, this.getTitle(), x + 11, y + 1);
        }

        public boolean isSelected() {
            return this == NBTEditorScreen.this.selected;
        }

        public void updateTitle() {
        }
    }

    protected class NBTPanel
    extends Panel {
        public NBTPanel() {
            super(NBTEditorScreen.this);
        }

        @Override
        public void addWidgets() {
            this.add(NBTEditorScreen.this.buttonNBTRoot);
            NBTEditorScreen.this.buttonNBTRoot.addChildren();
        }

        @Override
        public void alignWidgets() {
            this.align(WidgetLayout.VERTICAL);
        }
    }

    private class CustomTopPanel
    extends AbstractThreePanelScreen.TopPanel {
        private CustomTopPanel() {
            super(NBTEditorScreen.this);
        }

        @Override
        public void addWidgets() {
            this.add(NBTEditorScreen.this.panelTopLeft);
            this.add(NBTEditorScreen.this.panelTopRight);
        }

        @Override
        public void alignWidgets() {
            NBTEditorScreen.this.panelTopLeft.setPosAndSize(0, 2, NBTEditorScreen.this.panelTopLeft.width, 20);
            NBTEditorScreen.this.panelTopRight.setPosAndSize(this.width - NBTEditorScreen.this.panelTopRight.width, 2, 0, 20);
            NBTEditorScreen.this.panelTopRight.alignWidgets();
        }
    }

    public class ButtonNBTList
    extends ButtonNBTCollection {
        private final ListTag list;

        public ButtonNBTList(Panel panel, ButtonNBTCollection p, String key, ListTag l) {
            super(panel, p, key, NBT_LIST_OPEN, NBT_LIST_CLOSED);
            this.list = l;
        }

        @Override
        public void updateTitle() {
            this.setTitle((Component)Component.m_237113_((String)this.key).m_130940_(this.isSelected() ? ChatFormatting.YELLOW : ChatFormatting.GOLD));
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = NBTEditorScreen.this.makeNBTButton(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public Tag getTag(String key) {
            return this.list.get(Integer.parseInt(key));
        }

        @Override
        public void setTag(String key, @Nullable Tag base) {
            int id = Integer.parseInt(key);
            if (id == -1) {
                if (base != null) {
                    this.list.add((Object)base);
                }
            } else if (base != null) {
                this.list.set(id, base);
            } else {
                this.list.remove(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (Tag)this.list);
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return this.list.isEmpty() || this.list.m_7264_() == id;
        }

        @Override
        public CompoundTag toNBT() {
            return (CompoundTag)Util.m_137469_((Object)new CompoundTag(), t -> t.m_128365_(this.key, (Tag)this.list));
        }
    }

    public class ButtonNBTByteArray
    extends ButtonNBTCollection {
        private final ByteArrayList list;

        public ButtonNBTByteArray(Panel panel, ButtonNBTCollection p, String key, ByteArrayTag l) {
            super(panel, p, key, NBT_BYTE_ARRAY_OPEN, NBT_BYTE_ARRAY_CLOSED);
            this.list = new ByteArrayList(l.m_128227_());
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = NBTEditorScreen.this.makeNBTButton(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public Tag getTag(String key) {
            return ByteTag.m_128266_((byte)this.list.getByte(Integer.parseInt(key)));
        }

        @Override
        public void setTag(String key, @Nullable Tag base) {
            int id = Integer.parseInt(key);
            if (id == -1) {
                if (base != null) {
                    this.list.add(((NumericTag)base).m_7063_());
                }
            } else if (base != null) {
                this.list.set(id, ((NumericTag)base).m_7063_());
            } else {
                this.list.removeByte(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (Tag)new ByteArrayTag(this.list.toByteArray()));
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return id == 1;
        }

        @Override
        public CompoundTag toNBT() {
            return (CompoundTag)Util.m_137469_((Object)new CompoundTag(), t -> t.m_128365_(this.key, (Tag)new ByteArrayTag(this.list.toByteArray())));
        }
    }

    public class ButtonNBTIntArray
    extends ButtonNBTCollection {
        private final IntArrayList list;

        public ButtonNBTIntArray(Panel panel, ButtonNBTCollection parent, String key, IntArrayTag l) {
            super(panel, parent, key, NBT_INT_ARRAY_OPEN, NBT_INT_ARRAY_CLOSED);
            this.list = new IntArrayList(l.m_128648_());
        }

        @Override
        public void updateChildren(boolean first) {
            this.children.clear();
            for (int i = 0; i < this.list.size(); ++i) {
                String s = Integer.toString(i);
                ButtonNBT nbt = NBTEditorScreen.this.makeNBTButton(this, s);
                this.children.put(s, nbt);
                nbt.updateChildren(first);
            }
        }

        @Override
        public Tag getTag(String key) {
            return IntTag.m_128679_((int)this.list.getInt(Integer.parseInt(key)));
        }

        @Override
        public void setTag(String key, @Nullable Tag base) {
            int id = Integer.parseInt(key);
            if (id == -1) {
                if (base != null) {
                    this.list.add(((NumericTag)base).m_7047_());
                }
            } else if (base != null) {
                this.list.set(id, ((NumericTag)base).m_7047_());
            } else {
                this.list.rem(id);
            }
            if (this.parent != null) {
                this.parent.setTag(this.key, (Tag)new IntArrayTag(this.list.toIntArray()));
            }
        }

        @Override
        public boolean canCreateNew(int id) {
            return id == 3;
        }

        @Override
        public CompoundTag toNBT() {
            return (CompoundTag)Util.m_137469_((Object)new CompoundTag(), t -> t.m_128365_(this.key, (Tag)new IntArrayTag(this.list.toIntArray())));
        }
    }

    public class ButtonBasicTag
    extends ButtonNBT {
        private Tag nbt;

        public ButtonBasicTag(Panel panel, ButtonNBTCollection parent, String key, Tag nbt) {
            super(panel, parent, key);
            this.nbt = nbt;
            switch (this.nbt.m_7060_()) {
                case 1: {
                    this.setIcon(NBT_BYTE);
                    break;
                }
                case 2: {
                    this.setIcon(NBT_SHORT);
                    break;
                }
                case 3: {
                    this.setIcon(NBT_INT);
                    break;
                }
                case 4: {
                    this.setIcon(NBT_LONG);
                    break;
                }
                case 5: {
                    this.setIcon(NBT_FLOAT);
                    break;
                }
                case 6: 
                case 99: {
                    this.setIcon(NBT_DOUBLE);
                    break;
                }
                case 8: {
                    this.setIcon(NBT_STRING);
                }
            }
            this.parent.setTag(this.key, this.nbt);
            this.updateTitle();
        }

        @Override
        public void updateTitle() {
            String value = switch (this.nbt.m_7060_()) {
                case 1, 2, 3 -> ((NumericTag)this.nbt).m_7047_();
                case 4 -> ((NumericTag)this.nbt).m_7046_();
                case 5, 6, 99 -> ((NumericTag)this.nbt).m_7061_();
                case 8 -> this.nbt.m_7916_();
                default -> "";
            };
            ChatFormatting k = this.isSelected() ? ChatFormatting.WHITE : ChatFormatting.GRAY;
            ChatFormatting v = this.isSelected() ? ChatFormatting.AQUA : ChatFormatting.DARK_AQUA;
            MutableComponent text = Component.m_237113_((String)this.key).m_130940_(k).m_130946_(": ").m_7220_((Component)Component.m_237113_((String)value.toString()).m_130940_(v));
            this.setTitle((Component)text);
            this.setWidth(12 + NBTEditorScreen.this.getTheme().getStringWidth((FormattedText)text));
        }

        @Override
        public void onClicked(MouseButton button) {
            NBTEditorScreen.this.setSelected(this);
            NBTEditorScreen.this.panelTopLeft.refreshWidgets();
            if (button.isRight()) {
                this.edit();
            }
        }

        @Override
        public boolean mouseDoubleClicked(MouseButton button) {
            if (this.isMouseOver()) {
                this.edit();
                return true;
            }
            return false;
        }

        public void edit() {
            switch (this.nbt.m_7060_()) {
                case 1: 
                case 2: 
                case 3: {
                    this.openEditOverlay(new IntConfig(Integer.MIN_VALUE, Integer.MAX_VALUE), ((NumericTag)this.nbt).m_7047_());
                    break;
                }
                case 4: {
                    this.openEditOverlay(new LongConfig(Long.MIN_VALUE, Long.MAX_VALUE), ((NumericTag)this.nbt).m_7046_());
                    break;
                }
                case 5: 
                case 6: 
                case 99: {
                    this.openEditOverlay(new DoubleConfig(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), ((NumericTag)this.nbt).m_7061_());
                    break;
                }
                case 8: {
                    this.openEditOverlay(new StringConfig(), this.nbt.m_7916_());
                }
            }
        }

        private <T> void openEditOverlay(ConfigFromString<T> config, T val) {
            config.setValue(val);
            this.getGui().pushModalPanel(new EditStringConfigOverlay<T>(this.getGui(), config, accepted -> this.onCallback(config, accepted)).atMousePosition());
        }

        public void onCallback(ConfigValue<?> value, boolean accepted) {
            if (accepted) {
                switch (this.nbt.m_7060_()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.nbt = IntTag.m_128679_((int)((Number)value.getValue()).intValue());
                        break;
                    }
                    case 4: {
                        this.nbt = LongTag.m_128882_((long)((Number)value.getValue()).longValue());
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 99: {
                        this.nbt = DoubleTag.m_128500_((double)((Number)value.getValue()).doubleValue());
                        break;
                    }
                    case 8: {
                        this.nbt = StringTag.m_129297_((String)value.getValue().toString());
                    }
                }
                this.parent.setTag(this.key, this.nbt);
                this.updateTitle();
            }
            NBTEditorScreen.this.openGui();
        }

        @Override
        public CompoundTag toNBT() {
            return (CompoundTag)Util.m_137469_((Object)new CompoundTag(), t -> t.m_128365_(this.key, this.nbt));
        }
    }
}

