/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="torchmaster", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityBlockingVolumeRenderer {
    private static final ResourceLocation FORCEFIELD_LOCATION = new ResourceLocation("textures/misc/forcefield.png");
    private static final Map<Vec3i, Tuple<Integer, Integer>> volumeLights = new HashMap<Vec3i, Tuple<Integer, Integer>>();
    private static final Map<Vec3i, Integer> locationLights = new HashMap<Vec3i, Integer>();

    private static BoundingBox createVolume(Vec3i pos, int halfRange) {
        Vec3i min = pos.m_7918_(-halfRange, -halfRange, -halfRange);
        Vec3i max = pos.m_7918_(halfRange + 1, halfRange + 1, halfRange + 1);
        return BoundingBox.m_162375_((Vec3i)min, (Vec3i)max);
    }

    private static void renderLightVolume(Vec3i pos, int torchRange, Camera cam, int color) {
        Minecraft mc = Minecraft.m_91087_();
        int blockRenderDistance = mc.f_91066_.m_193772_() * 16;
        BoundingBox torchVol = EntityBlockingVolumeRenderer.createVolume(pos, torchRange);
        BoundingBox playerVolume = EntityBlockingVolumeRenderer.createVolume((Vec3i)cam.m_90588_(), blockRenderDistance);
        if (!playerVolume.m_71049_(torchVol)) {
            return;
        }
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        double camX = cam.m_90583_().f_82479_;
        double camZ = cam.m_90583_().f_82481_;
        double camY = cam.m_90583_().f_82480_;
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)FORCEFIELD_LOCATION);
        RenderSystem.depthMask((boolean)Minecraft.m_91085_());
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        RenderSystem.applyModelViewMatrix();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderSystem.disableCull();
        float slide = (float)(Util.m_137550_() % 3000L) / 3000.0f;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        double vMinX = (double)torchVol.m_162395_() - camX;
        double vMaxX = (double)torchVol.m_162399_() - camX;
        double vMinY = (double)torchVol.m_162396_() - camY;
        double vMaxY = (double)torchVol.m_162400_() - camY;
        double vMinZ = (double)torchVol.m_162398_() - camZ;
        double vMaxZ = (double)torchVol.m_162401_() - camZ;
        float uv0 = slide;
        float uv1 = (float)torchRange + slide;
        bufferbuilder.m_5483_(vMaxX, vMinY, vMinZ).m_7421_(uv1, uv1).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMinY, vMaxZ).m_7421_(uv1, uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMaxZ).m_7421_(uv0, uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMinZ).m_7421_(uv0, uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMinZ).m_7421_(uv1, uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMaxZ).m_7421_(uv1, uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMaxZ).m_7421_(uv0, uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMinZ).m_7421_(uv0, uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMaxZ).m_7421_(uv1, uv1).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMinY, vMaxZ).m_7421_(uv1, uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMaxZ).m_7421_(uv0, uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMaxZ).m_7421_(uv0, uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMinZ).m_7421_(uv1, uv1).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMinY, vMinZ).m_7421_(uv1, uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMinZ).m_7421_(uv0, uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMinZ).m_7421_(uv0, uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMinZ).m_7421_(uv1, uv1).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMinZ).m_7421_(uv1, uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMaxZ).m_7421_(uv0, uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMaxZ).m_7421_(uv0, uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMinZ).m_7421_(uv1, uv1).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMinY, vMinZ).m_7421_(uv1, uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMinY, vMaxZ).m_7421_(uv0, uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMaxZ).m_7421_(uv0, uv1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.enableCull();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }

    public static void showVolumeAt(Vec3i pos, int range, int color) {
        volumeLights.put(pos, (Tuple<Integer, Integer>)new Tuple((Object)range, (Object)color));
    }

    public static void removeVolumeAt(Vec3i pos) {
        volumeLights.remove(pos);
    }

    public static void showLocationAt(Vec3i pos, int color) {
        locationLights.put(pos, color);
    }

    public static void removeLocationAt(Vec3i pos) {
        locationLights.remove(pos);
    }

    public static void clearAll() {
        volumeLights.clear();
        locationLights.clear();
    }

    @SubscribeEvent
    public static void onRenderLevelStageEvent(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            return;
        }
        for (Map.Entry<Vec3i, Tuple<Integer, Integer>> entry : volumeLights.entrySet()) {
            EntityBlockingVolumeRenderer.renderLightVolume(entry.getKey(), (Integer)entry.getValue().m_14418_(), event.getCamera(), (Integer)entry.getValue().m_14419_());
        }
        for (Map.Entry<Vec3i, Object> entry : locationLights.entrySet()) {
            EntityBlockingVolumeRenderer.renderTorchLocation(entry.getKey(), (Integer)entry.getValue(), event.getCamera());
        }
    }

    private static void renderTorchLocation(Vec3i pos, int color, Camera cam) {
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        double camX = cam.m_90583_().f_82479_;
        double camZ = cam.m_90583_().f_82481_;
        double camY = cam.m_90583_().f_82480_;
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)FORCEFIELD_LOCATION);
        RenderSystem.depthMask((boolean)Minecraft.m_91085_());
        PoseStack posestack = RenderSystem.getModelViewStack();
        posestack.m_85836_();
        RenderSystem.applyModelViewMatrix();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.polygonOffset((float)-3.0f, (float)-3.0f);
        RenderSystem.enablePolygonOffset();
        RenderSystem.disableCull();
        float slide = (float)(Util.m_137550_() % 3000L) / 3000.0f;
        bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        double vMinX = (double)pos.m_123341_() - camX;
        double vMaxX = (double)pos.m_123341_() - camX + 1.0;
        double vMinY = (double)pos.m_123342_() - camY;
        double vMaxY = (double)pos.m_123342_() - camY + 1.0;
        double vMinZ = (double)pos.m_123343_() - camZ;
        double vMaxZ = (double)pos.m_123343_() - camZ + 1.0;
        boolean uv0 = false;
        boolean uv1 = true;
        bufferbuilder.m_5483_(vMaxX, vMinY, vMinZ).m_7421_((float)uv1, (float)uv1).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMinY, vMaxZ).m_7421_((float)uv1, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMaxZ).m_7421_((float)uv0, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMinZ).m_7421_((float)uv0, (float)uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMinZ).m_7421_((float)uv1, (float)uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMaxZ).m_7421_((float)uv1, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMaxZ).m_7421_((float)uv0, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMinZ).m_7421_((float)uv0, (float)uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMaxZ).m_7421_((float)uv1, (float)uv1).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMinY, vMaxZ).m_7421_((float)uv1, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMaxZ).m_7421_((float)uv0, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMaxZ).m_7421_((float)uv0, (float)uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMinZ).m_7421_((float)uv1, (float)uv1).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMinY, vMinZ).m_7421_((float)uv1, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMinZ).m_7421_((float)uv0, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMinZ).m_7421_((float)uv0, (float)uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMinZ).m_7421_((float)uv1, (float)uv1).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMinZ).m_7421_((float)uv1, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMaxY, vMaxZ).m_7421_((float)uv0, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMaxY, vMaxZ).m_7421_((float)uv0, (float)uv1).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMinZ).m_7421_((float)uv1, (float)uv1).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMinY, vMinZ).m_7421_((float)uv1, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMaxX, vMinY, vMaxZ).m_7421_((float)uv0, (float)uv0).m_5752_();
        bufferbuilder.m_5483_(vMinX, vMinY, vMaxZ).m_7421_((float)uv0, (float)uv1).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
        RenderSystem.enableCull();
        RenderSystem.polygonOffset((float)0.0f, (float)0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        posestack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.depthMask((boolean)true);
    }
}

