/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.util;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayeredForwardingMap<K, V>
implements Map<K, V> {
    private final Map<K, V>[] layers;

    public LayeredForwardingMap(Map<K, V>[] layers) {
        if (layers.length < 1) {
            throw new IllegalArgumentException();
        }
        for (Map<K, V> layer : layers) {
            if (layer != null) continue;
            throw new IllegalArgumentException();
        }
        this.layers = layers;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        for (Map<K, V> map : this.layers) {
            if (map.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object key) {
        for (Map<K, V> map : this.layers) {
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map<K, V> map : this.layers) {
            if (!map.containsValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        for (Map<K, V> map : this.layers) {
            V value = map.get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        V originalValue = null;
        for (Map<K, V> map : this.layers) {
            V oldVal = map.remove(key);
            if (originalValue == null) {
                originalValue = oldVal;
            }
            map.put(key, value);
        }
        return originalValue;
    }

    @Override
    public V remove(Object key) {
        for (Map<K, V> map : this.layers) {
            map.remove(key);
        }
        return null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
        for (V value : m.values()) {
            if (value != null) continue;
            throw new IllegalArgumentException();
        }
        for (Map<K, V> map : this.layers) {
            map.putAll(m);
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        ObjectOpenHashSet keys = new ObjectOpenHashSet();
        for (Map<K, V> map : this.layers) {
            keys.addAll(map.keySet());
        }
        return Collections.unmodifiableSet(keys);
    }

    @Override
    @NotNull
    public Collection<V> values() {
        Set<K> keys = this.keySet();
        ArrayList<V> vals = new ArrayList<V>();
        for (K key : keys) {
            vals.add(this.get(key));
        }
        return vals;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }
}

