/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.tickables;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.embeddedt.modernfix.tickables.TickableObject;
import org.jetbrains.annotations.Nullable;

public class LoadableTickableObject<T>
implements TickableObject {
    private volatile int ticksInactive = 0;
    private final int timeout;
    private final Supplier<T> loader;
    private final Consumer<T> finalizer;
    private volatile T theObject = null;

    public LoadableTickableObject(int timeout, Supplier<T> loader, Consumer<T> finalizer) {
        this(timeout, loader, finalizer, null);
    }

    public LoadableTickableObject(int timeout, Supplier<T> loader, Consumer<T> finalizer, @Nullable T initialValue) {
        this.timeout = timeout;
        this.loader = loader;
        this.finalizer = finalizer;
        this.theObject = initialValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        LoadableTickableObject loadableTickableObject = this;
        synchronized (loadableTickableObject) {
            ++this.ticksInactive;
            T obj = this.theObject;
            if (obj == null) {
                this.theObject = obj = this.loader.get();
            }
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void tick() {
        LoadableTickableObject loadableTickableObject = this;
        synchronized (loadableTickableObject) {
            ++this.ticksInactive;
            if (this.ticksInactive >= this.timeout) {
                this.finalizer.accept(this.theObject);
                this.theObject = null;
            }
        }
    }
}

