/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.registrate;

import com.oierbravo.create_mechanical_spawner.CreateMechanicalSpawner;
import com.simibubi.create.AllFluids;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.infrastructure.config.AllConfigs;
import com.tterrag.registrate.builders.FluidBuilder;
import com.tterrag.registrate.util.entry.FluidEntry;
import java.util.function.Supplier;
import net.createmod.catnip.theme.Color;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.joml.Vector3f;

public class ModFluids {
    public static String PREFIX = "spawn_fluid";
    public static final CreateRegistrate REGISTRATE = CreateMechanicalSpawner.registrate();
    public static final FluidEntry<ForgeFlowingFluid.Flowing> RANDOM = ModFluids.createSpawnFluid("random", 11796735);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> BLAZE = ModFluids.createSpawnFluid("blaze", 16739328);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CREEPER = ModFluids.createSpawnFluid("creeper", 1165568);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> DROWNED = ModFluids.createSpawnFluid("drowned", 65495);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> ENDERMAN = ModFluids.createSpawnFluid("enderman", 27984);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> EVOKER = ModFluids.createSpawnFluid("evoker", 0x868686);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> GHAST = ModFluids.createSpawnFluid("ghast", 0xDADADA);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> MAGMA_CUBE = ModFluids.createSpawnFluid("magma_cube", 0x7D0000);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> PIGLING = ModFluids.createSpawnFluid("pigling", 16754915);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SKELETON = ModFluids.createSpawnFluid("skeleton", 0x555555);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SLIME = ModFluids.createSpawnFluid("slime", 1507072);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> SPIDER = ModFluids.createSpawnFluid("spider", 0x220000);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> WITCH = ModFluids.createSpawnFluid("witch", 610304);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> WITHER_SKELETON = ModFluids.createSpawnFluid("wither_skeleton", 0x393939);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> ZOMBIE = ModFluids.createSpawnFluid("zombie", 684800);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> BAT = ModFluids.createSpawnFluid("bat", 16751309);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> BEE = ModFluids.createSpawnFluid("bee", 16770560);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> COW = ModFluids.createSpawnFluid("cow", 3679255);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> CHICKEN = ModFluids.createSpawnFluid("chicken", 0xF7F7F7);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> FOX = ModFluids.createSpawnFluid("fox", 16750336);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> HORSE = ModFluids.createSpawnFluid("horse", 8408064);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> PANDA = ModFluids.createSpawnFluid("panda", 0xE5E5E5);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> PARROT = ModFluids.createSpawnFluid("parrot", 0xFF0000);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> PIG = ModFluids.createSpawnFluid("pig", 16751309);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> RABBIT = ModFluids.createSpawnFluid("rabbit", 16751309);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> VILLAGER = ModFluids.createSpawnFluid("villager", 5256704);
    public static final FluidEntry<ForgeFlowingFluid.Flowing> WOLF = ModFluids.createSpawnFluid("wolf", 16751309);

    private static FluidEntry<ForgeFlowingFluid.Flowing> createSpawnFluid(String target, int fogColor) {
        ResourceLocation flow = new ResourceLocation("create_mechanical_spawner", "fluid/spawn_fluid_" + target + "_flow");
        ResourceLocation still = new ResourceLocation("create_mechanical_spawner", "fluid/spawn_fluid_" + target + "_still");
        return ((FluidBuilder)REGISTRATE.standardFluid(PREFIX + "_" + target, SolidRenderedPlaceableFluidType.create(fogColor, () -> Float.valueOf(0.125f * AllConfigs.client().honeyTransparencyMultiplier.getF()))).lang("Spawn fluid " + target).properties(b -> b.viscosity(2000).density(1400)).fluidProperties(p -> p.levelDecreasePerBlock(2).tickRate(25).slopeFindDistance(3).explosionResistance(100.0f)).tag(new TagKey[]{AllTags.forgeFluidTag((String)"spawn_fluid")}).source(ForgeFlowingFluid.Source::new).bucket().tag(new TagKey[]{AllTags.forgeItemTag((String)"buckets/spawn_fluid")}).build()).register();
    }

    public static void register() {
    }

    private static class SolidRenderedPlaceableFluidType
    extends AllFluids.TintedFluidType {
        private Vector3f fogColor;
        private Supplier<Float> fogDistance;

        public static FluidBuilder.FluidTypeFactory create(int fogColor, Supplier<Float> fogDistance) {
            return (p, s, f) -> {
                SolidRenderedPlaceableFluidType fluidType = new SolidRenderedPlaceableFluidType(p, s, f);
                fluidType.fogColor = new Color(fogColor, false).asVectorF();
                fluidType.fogDistance = fogDistance;
                return fluidType;
            };
        }

        private SolidRenderedPlaceableFluidType(FluidType.Properties properties, ResourceLocation stillTexture, ResourceLocation flowingTexture) {
            super(properties, stillTexture, flowingTexture);
        }

        protected int getTintColor(FluidStack stack) {
            return -1;
        }

        public int getTintColor(FluidState state, BlockAndTintGetter world, BlockPos pos) {
            return 0xFFFFFF;
        }

        protected Vector3f getCustomFogColor() {
            return this.fogColor;
        }

        protected float getFogDistanceModifier() {
            return this.fogDistance.get().floatValue();
        }
    }
}

