/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.compat.jei;

import com.oierbravo.create_mechanical_spawner.compat.jei.RandomMobCycleTimer;
import com.oierbravo.create_mechanical_spawner.compat.jei.RenderHelper;
import com.oierbravo.create_mechanical_spawner.compat.jei.animations.AnimatedSpawner;
import com.oierbravo.create_mechanical_spawner.content.components.SpawnerConfig;
import com.oierbravo.create_mechanical_spawner.content.components.SpawnerRecipe;
import com.oierbravo.create_mechanical_spawner.foundation.utility.ModLang;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class SpawnerCategory
extends CreateRecipeCategory<SpawnerRecipe> {
    private final AnimatedSpawner spawner = new AnimatedSpawner();
    private final RandomMobCycleTimer randomMobCycleTimer;
    private List<LivingEntity> displayedMobs = List.of();
    private List<Optional<EntityType<?>>> allMobs = List.of();

    public SpawnerCategory(CreateRecipeCategory.Info<SpawnerRecipe> info) {
        super(info);
        this.randomMobCycleTimer = new RandomMobCycleTimer(0);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SpawnerRecipe recipe, IFocusGroup focuses) {
        boolean useCustomLoot;
        FluidIngredient fluidIngredient = recipe.getFluidIngredient();
        List<ItemStack> invisibleIngredientsBuckets = fluidIngredient.getMatchingFluidStacks().stream().map(fluidStack -> new ItemStack((ItemLike)fluidStack.getFluid().m_6859_())).toList();
        List<Fluid> listFluids = fluidIngredient.getMatchingFluidStacks().stream().map(fluidStack -> fluidStack.getFluid()).toList();
        List<ItemStack> buckets = fluidIngredient.getMatchingFluidStacks().stream().map(fluidStack -> fluidStack.getFluid().getFluidType().getBucket(fluidStack)).toList();
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(invisibleIngredientsBuckets);
        EntityType<?> mob = recipe.getMob();
        boolean bl = useCustomLoot = !recipe.getCustomLoot().isEmpty() && (Boolean)SpawnerConfig.CUSTOM_LOOT_PER_SPAWN_RECIPE_ENABLED.get() != false;
        if (mob != null && !useCustomLoot) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            ItemStack egg = mob.m_20615_((Level)level).m_142340_();
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStack(egg);
        }
        if (useCustomLoot) {
            NonNullList<ProcessingOutput> customLoot = recipe.getCustomLoot();
            boolean single = customLoot.size() == 1;
            int i = 0;
            for (ProcessingOutput output : customLoot) {
                int xOffset = i % 2 == 0 ? 0 : 19;
                int yOffset = i / 2 * -19;
                ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, single ? 139 : 133 + xOffset, 27 + yOffset).setBackground(SpawnerCategory.getRenderedSlot((ProcessingOutput)output), -1, -1).addItemStack(output.getStack())).addRichTooltipCallback(SpawnerCategory.addStochasticTooltip((ProcessingOutput)output));
                ++i;
            }
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 15, 9).setBackground(SpawnerCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)ForgeTypes.FLUID_STACK, fluidIngredient.getMatchingFluidStacks())).addRichTooltipCallback(SpawnerCategory::addFluidAmountTooltip);
    }

    private static void addFluidAmountTooltip(IRecipeSlotView recipeSlotView, ITooltipBuilder tooltip) {
        Optional displayed = recipeSlotView.getDisplayedIngredient((IIngredientType)ForgeTypes.FLUID_STACK);
        if (displayed.isEmpty()) {
            return;
        }
        FluidStack fluidStack = (FluidStack)displayed.get();
        tooltip.add((FormattedText)Component.m_237113_((String)(fluidStack.getAmount() + "mB")));
    }

    public LivingEntity getDisplayedMob() {
        return this.randomMobCycleTimer.getCycledLivingEntity(this.displayedMobs);
    }

    public void draw(SpawnerRecipe recipe, @NotNull IRecipeSlotsView iRecipeSlotsView, @NotNull GuiGraphics guiGraphics, double mouseX, double mouseY) {
        boolean useCustomLoot;
        this.randomMobCycleTimer.onDraw();
        Font font = Minecraft.m_91087_().f_91062_;
        AllGuiTextures.JEI_DOWN_ARROW.render(guiGraphics, 43, 4);
        this.spawner.draw(guiGraphics, 48, 27);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        EntityType<?> mob = recipe.getMob();
        boolean bl = useCustomLoot = !recipe.getCustomLoot().isEmpty() && (Boolean)SpawnerConfig.CUSTOM_LOOT_PER_SPAWN_RECIPE_ENABLED.get() != false;
        if (mob != null) {
            assert (level != null);
            LivingEntity mobEntity = (LivingEntity)mob.m_20615_((Level)level);
            assert (mobEntity != null);
            String id = mobEntity.m_20078_();
            assert (id != null);
            RenderHelper.renderEntity(guiGraphics, 100, 35, 20.0f * this.getMobScaleModifier(id), 38.0 - mouseX, 80.0 - mouseY, this.randomMobCycleTimer.getCycledLivingEntity(List.of(mobEntity)));
            Component displayName = mobEntity.m_5446_();
            guiGraphics.m_280614_(font, displayName, 20, 57, 8, false);
            if (useCustomLoot) {
                String customLoottext = ModLang.translate("generic.with_custom_loot", new Object[0]).string();
                guiGraphics.m_280056_(font, customLoottext, 20, 65, 8, false);
            }
            return;
        }
        if (!useCustomLoot) {
            String text = ModLang.translate("generic.biome_dependant", new Object[0]).string();
            guiGraphics.m_280056_(font, text, 80, 57, 8, false);
        }
    }

    private void drawMob() {
    }

    private float getMobScaleModifier(String mobId) {
        return switch (mobId) {
            case "minecraft:ghast" -> 0.25f;
            case "minecraft:enderman" -> 0.9f;
            default -> 1.0f;
        };
    }
}

