/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.item.sandwich;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.config.ModConfig;
import someassemblyrequired.ingredient.Ingredients;
import someassemblyrequired.mixin.FoodPropertiesMixin;
import someassemblyrequired.registry.ModFoods;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModTags;

public class SandwichItemHandler
implements IItemHandler,
IItemHandlerModifiable,
INBTSerializable<ListTag>,
Iterable<ItemStack> {
    protected final List<ItemStack> items = new ArrayList<ItemStack>();
    protected FoodProperties foodProperties = ModFoods.EMPTY;
    protected MobEffectInstance effect;

    public static SandwichItemHandler of(List<ItemStack> items) {
        SandwichItemHandler result = new SandwichItemHandler();
        for (ItemStack item : items) {
            result.add(item);
        }
        return result;
    }

    public static Optional<SandwichItemHandler> get(@Nullable ICapabilityProvider capabilityProvider) {
        if (capabilityProvider == null) {
            return Optional.empty();
        }
        return capabilityProvider.getCapability(ForgeCapabilities.ITEM_HANDLER).filter(handler -> handler instanceof SandwichItemHandler).map(handler -> (SandwichItemHandler)handler);
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public FoodProperties getFoodProperties() {
        return this.foodProperties;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public int getItemCount() {
        return this.items.size();
    }

    public int getTotalHeight() {
        int size = 0;
        for (ItemStack item : this.items) {
            size += Ingredients.getHeight(item);
        }
        return size;
    }

    public int getTotalNutrition() {
        int result = 0;
        for (ItemStack stack : this.items) {
            result += Ingredients.getFood(stack, null).m_38744_();
        }
        return result;
    }

    public float getAverageSaturation() {
        float totalSaturation = 0.0f;
        for (ItemStack stack : this.items) {
            FoodProperties food = Ingredients.getFood(stack, null);
            totalSaturation += food.m_38745_() * (float)food.m_38744_();
        }
        return totalSaturation / (float)this.getTotalNutrition();
    }

    @Nullable
    public MobEffectInstance getEffect() {
        return this.effect;
    }

    private void updateFoodProperties() {
        if (this.isEmpty()) {
            this.foodProperties = ModFoods.EMPTY;
        } else {
            FoodProperties.Builder builder = new FoodProperties.Builder().m_38760_(this.getTotalNutrition()).m_38758_(this.getAverageSaturation());
            HashSet<Item> uniqueIngredients = new HashSet<Item>();
            for (ItemStack item : this.items) {
                FoodProperties food = Ingredients.getFood(item, null);
                for (Pair<Supplier<MobEffectInstance>, Float> pair : ((FoodPropertiesMixin)food).getEffectSuppliers()) {
                    builder.effect((Supplier)pair.getFirst(), ((Float)pair.getSecond()).floatValue());
                }
                if (food.m_38744_() <= 0 || !food.m_38749_().isEmpty() || item.m_204117_(ModTags.SANDWICH_BREAD)) continue;
                uniqueIngredients.add(item.m_41720_());
            }
            this.addBonusEffect(builder, uniqueIngredients.size());
            this.foodProperties = builder.m_38767_();
        }
    }

    public void addBonusEffect(FoodProperties.Builder builder, int uniqueIngredientCount) {
        String effectName = this.isBurger() ? (String)ModConfig.server.burgerBonusEffect.get() : (String)ModConfig.server.sandwichBonusEffect.get();
        List durations = this.isBurger() ? (List)ModConfig.server.burgerEffectDurations.get() : (List)ModConfig.server.sandwichEffectDurations.get();
        uniqueIngredientCount = Math.min(durations.size() - 1, uniqueIngredientCount);
        try {
            int duration;
            ResourceLocation effectId = new ResourceLocation(effectName);
            MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(effectId);
            if (effect != null && !durations.isEmpty() && (duration = ((Integer)durations.get(uniqueIngredientCount)).intValue()) > 0) {
                this.effect = new MobEffectInstance(effect, duration * 20, 0);
                builder.effect(() -> this.effect, 1.0f);
            }
        }
        catch (ResourceLocationException resourceLocationException) {
            // empty catch block
        }
    }

    public void add(ItemStack stack) {
        if (stack.m_41619_()) {
            throw new IllegalArgumentException();
        }
        this.items.add(stack);
        this.onContentsChanged();
    }

    public boolean canAdd(SandwichItemHandler sandwich) {
        return this.getTotalHeight() + sandwich.getTotalHeight() <= (Integer)ModConfig.server.maximumSandwichHeight.get();
    }

    public void add(SandwichItemHandler sandwich) {
        this.items.addAll(sandwich.items);
        this.onContentsChanged();
    }

    public void pop() {
        this.items.remove(this.items.size() - 1);
        this.onContentsChanged();
    }

    public void setItems(List<ItemStack> items) {
        this.items.clear();
        this.items.addAll(items);
        this.onContentsChanged();
    }

    public ItemStack bottom() {
        return this.items.get(0);
    }

    public ItemStack top() {
        return this.items.get(this.items.size() - 1);
    }

    public boolean hasTopAndBottomBread() {
        return this.getItemCount() > 0 && this.bottom().m_204117_(ModTags.SANDWICH_BREAD) && this.top().m_204117_(ModTags.SANDWICH_BREAD);
    }

    public boolean isBurger() {
        return this.getItemCount() > 0 && this.bottom().m_204117_(ModTags.BURGER_BUNS) && this.top().m_204117_(ModTags.BURGER_BUNS);
    }

    public boolean isDoubleDeckerSandwich() {
        if (this.getItemCount() < 5) {
            return false;
        }
        if (!this.hasTopAndBottomBread()) {
            return false;
        }
        boolean foundBread = false;
        for (int i = 1; i < this.getItemCount() - 2; ++i) {
            if (!this.items.get(i).m_204117_(ModTags.SANDWICH_BREAD)) continue;
            if (foundBread) {
                return false;
            }
            foundBread = true;
        }
        return foundBread && !this.items.get(1).m_204117_(ModTags.SANDWICH_BREAD) && !this.items.get(this.getItemCount() - 2).m_204117_(ModTags.SANDWICH_BREAD);
    }

    public ItemStack getAsItem() {
        ItemStack result = new ItemStack((ItemLike)ModItems.SANDWICH.get());
        result.m_41698_("BlockEntityTag").m_128365_("Sandwich", (Tag)this.serializeNBT());
        return result;
    }

    public int getSlots() {
        return this.items.size();
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        if (stack.m_41619_()) {
            throw new IllegalArgumentException();
        }
        this.validateSlotIndex(slot);
        this.items.set(slot, stack);
        this.onContentsChanged();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlotIndex(slot);
        return this.items.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 1;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return false;
    }

    public ListTag serializeNBT() {
        return SandwichItemHandler.serializeItems(this.items);
    }

    public static ListTag serializeItems(List<ItemStack> items) {
        ListTag result = new ListTag();
        for (ItemStack stack : items) {
            result.add((Object)stack.m_41739_(new CompoundTag()));
        }
        return result;
    }

    public void deserializeNBT(ListTag listTag) {
        this.items.clear();
        for (int i = 0; i < listTag.size(); ++i) {
            this.items.add(ItemStack.m_41712_((CompoundTag)listTag.m_128728_(i)));
        }
        this.onLoad();
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return this.items.iterator();
    }

    protected void validateSlotIndex(int slot) {
        if (slot < 0 || slot >= this.items.size()) {
            throw new IndexOutOfBoundsException("Slot " + slot + " not in valid range - [0," + this.items.size() + ")");
        }
    }

    protected void onLoad() {
        this.updateFoodProperties();
    }

    protected void onContentsChanged() {
        this.updateFoodProperties();
    }
}

