/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.integration.jei.create;

import com.simibubi.create.compat.jei.CreateJEI;
import com.simibubi.create.content.fluids.potion.PotionFluidHandler;
import com.simibubi.create.content.fluids.transfer.FillingRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipeBuilder;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.ISimpleRecipeManagerPlugin;
import mezz.jei.api.registration.IAdvancedRegistration;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import someassemblyrequired.SomeAssemblyRequired;
import someassemblyrequired.integration.ModCompat;
import someassemblyrequired.integration.create.recipe.SandwichFluidSpoutingRecipe;
import someassemblyrequired.integration.jei.SandwichRecipeGenerator;
import someassemblyrequired.item.sandwich.SandwichItem;
import someassemblyrequired.item.sandwich.SandwichItemHandler;
import someassemblyrequired.recipe.SandwichSpoutingRecipe;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModRecipeTypes;

public class SequencedAssemblyRecipeGenerator
extends SandwichRecipeGenerator<SequencedAssemblyRecipe> {
    private static final RecipeType<SequencedAssemblyRecipe> SEQUENCED_ASSEMBLY = RecipeType.create((String)"create", (String)"sequenced_assembly", SequencedAssemblyRecipe.class);

    public static void register(IAdvancedRegistration registration) {
        registration.addTypedRecipeManagerPlugin(SEQUENCED_ASSEMBLY, (ISimpleRecipeManagerPlugin)new SequencedAssemblyRecipeGenerator());
    }

    @Override
    protected int getMaxToppings() {
        return 6;
    }

    @Override
    protected SequencedAssemblyRecipe getRecipeForSandwich(ItemStack prefix, List<ItemStack> toppings, ItemStack result) {
        SequencedAssemblyRecipeBuilder recipe = new SequencedAssemblyRecipeBuilder(SomeAssemblyRequired.id("dynamic/sequenced_assembly")).transitionTo((ItemLike)ModItems.SANDWICH.get()).loops(1).addOutput(result, 1.0f).require(Ingredient.m_43927_((ItemStack[])new ItemStack[]{prefix}));
        for (ItemStack input : toppings) {
            Optional<FluidIngredient> fluidIngredient = this.getFluidFromFilling(input);
            if (fluidIngredient.isPresent()) {
                recipe.addStep(FillingRecipe::new, builder -> builder.require((FluidIngredient)fluidIngredient.get()));
                continue;
            }
            recipe.addStep(DeployerApplicationRecipe::new, builder -> builder.require(Ingredient.m_43927_((ItemStack[])new ItemStack[]{input})));
        }
        return recipe.build();
    }

    @Override
    protected List<SequencedAssemblyRecipe> getRecipesForBread(ItemStack bottomBread, ItemStack topBread) {
        List<SequencedAssemblyRecipe> recipes = super.getRecipesForBread(bottomBread, topBread);
        this.getSpoutingRecipes().map(recipe -> recipe.assemble(FluidStack.EMPTY)).filter(item -> !item.m_150930_(Items.f_42787_)).map(filling -> SandwichItem.of(bottomBread, filling, topBread)).map(sandwich -> (SequencedAssemblyRecipe)this.getRecipeForSandwich(SandwichItemHandler.get((ICapabilityProvider)sandwich).orElse(new SandwichItemHandler()))).forEach(recipes::add);
        ModCompat.EXAMPLE_POTIONS.stream().filter(potion -> !potion.m_43488_().isEmpty()).map(potion -> PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)potion)).map(potion -> (SequencedAssemblyRecipe)this.createRecipe(bottomBread, (ItemStack)potion, topBread)).forEach(recipes::add);
        return recipes;
    }

    @Override
    protected ItemStack getFillingFromFluid(FluidStack fluid) {
        for (Recipe recipe : CreateJEI.getTypedRecipes((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.SANDWICH_SPOUTING.get()))) {
            if (!((SandwichSpoutingRecipe)recipe).matches(fluid)) continue;
            return ((SandwichSpoutingRecipe)recipe).assemble(fluid);
        }
        throw new IllegalArgumentException("Unsupported fluid: [%s]".formatted(fluid.toString()));
    }

    @Override
    protected Optional<FluidIngredient> getFluidFromFilling(ItemStack filling) {
        if (filling.m_150930_(Items.f_42589_)) {
            int requiredAmount = PotionFluidHandler.getRequiredAmountForFilledBottle(null, null);
            return Optional.of(FluidIngredient.fromFluidStack((FluidStack)FluidHelper.copyStackWithAmount((FluidStack)PotionFluidHandler.getFluidFromPotionItem((ItemStack)filling), (int)requiredAmount)));
        }
        return this.getSpoutingRecipes().filter(recipe -> ItemStack.m_41656_((ItemStack)recipe.m_8043_((RegistryAccess)RegistryAccess.f_243945_), (ItemStack)filling)).map(SandwichFluidSpoutingRecipe::getIngredient).findFirst();
    }

    private Stream<SandwichFluidSpoutingRecipe> getSpoutingRecipes() {
        return CreateJEI.getTypedRecipesExcluding((net.minecraft.world.item.crafting.RecipeType)((net.minecraft.world.item.crafting.RecipeType)ModRecipeTypes.SANDWICH_SPOUTING.get()), recipe -> recipe.m_7707_() != ModRecipeTypes.SANDWICH_FLUID_SPOUTING_SERIALIZER.get()).stream().map(recipe -> (SandwichFluidSpoutingRecipe)recipe);
    }
}

