/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.providers.ingredient;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.ingredient.IngredientProperties;
import someassemblyrequired.registry.ModItems;
import someassemblyrequired.registry.ModSoundEvents;

public class IngredientBuilder {
    private final Item item;
    @Nullable
    private Component displayName;
    @Nullable
    private Component fullName;
    @Nullable
    private SoundEvent soundEvent;
    private ItemStack displayItem = ItemStack.f_41583_;
    private ItemStack container = ItemStack.f_41583_;
    private int height = 1;
    private boolean renderAsItem = true;
    private FoodProperties foodProperties = null;

    public IngredientBuilder(Item item) {
        this.item = item;
    }

    public IngredientProperties build() {
        return new IngredientProperties(this.foodProperties, this.displayName, this.fullName, this.displayItem, this.container, this.soundEvent, this.height, this.renderAsItem);
    }

    public Item getItem() {
        return this.item;
    }

    public ItemStack getDisplayItem() {
        return this.displayItem;
    }

    public IngredientBuilder setDisplayName(Component displayName) {
        this.displayName = displayName;
        return this;
    }

    public IngredientBuilder setDisplayName(String translationKey) {
        return this.setDisplayName((Component)Component.m_237115_((String)translationKey));
    }

    public IngredientBuilder setDisplayName(Item item) {
        return this.setDisplayName(IngredientBuilder.getDefaultTranslationKey(item));
    }

    public IngredientBuilder setCustomDisplayName() {
        return this.setDisplayName(this.getItem());
    }

    public IngredientBuilder setFullName(Component fullName) {
        this.fullName = fullName;
        return this;
    }

    public IngredientBuilder setFullName(String translationKey) {
        return this.setFullName((Component)Component.m_237115_((String)translationKey));
    }

    public IngredientBuilder setFullName(Item item) {
        return this.setFullName(IngredientBuilder.getDefaultTranslationKey(item));
    }

    public IngredientBuilder setCustomFullName() {
        return this.setFullName(IngredientBuilder.getDefaultTranslationKey(this.getItem()));
    }

    public IngredientBuilder setDisplayItem(ItemStack displayItem) {
        this.displayItem = displayItem;
        return this;
    }

    public IngredientBuilder setSpread(int color) {
        ItemStack spread = new ItemStack((ItemLike)ModItems.SPREAD.get());
        spread.m_41784_().m_128405_("Color", color);
        return this.setDisplayItem(spread);
    }

    public IngredientBuilder setWetSound() {
        return this.setSound((SoundEvent)ModSoundEvents.ADD_ITEM_WET.get());
    }

    public IngredientBuilder setMoistSound() {
        return this.setSound((SoundEvent)ModSoundEvents.ADD_ITEM_MOIST.get());
    }

    public IngredientBuilder setSlimySound() {
        return this.setSound((SoundEvent)ModSoundEvents.ADD_ITEM_SLIMY.get());
    }

    public IngredientBuilder setLeafySound() {
        return this.setSound((SoundEvent)ModSoundEvents.ADD_ITEM_LEAFY.get());
    }

    public IngredientBuilder setContainer(ItemStack container) {
        this.container = container;
        return this;
    }

    public IngredientBuilder setContainer(Item item) {
        return this.setContainer(new ItemStack((ItemLike)item));
    }

    public IngredientBuilder setBottled() {
        return this.setContainer(Items.f_42590_);
    }

    public IngredientBuilder setBowled() {
        return this.setContainer(Items.f_42399_);
    }

    public IngredientBuilder setBucketed() {
        return this.setContainer(Items.f_42446_);
    }

    public IngredientBuilder setSound(SoundEvent soundEvent) {
        this.soundEvent = soundEvent;
        return this;
    }

    public IngredientBuilder setHeight(int height) {
        this.height = height;
        return this;
    }

    public IngredientBuilder setRenderAsItem(boolean renderAsItem) {
        this.renderAsItem = renderAsItem;
        return this;
    }

    public IngredientBuilder setFoodProperties(FoodProperties foodProperties) {
        this.foodProperties = foodProperties;
        return this;
    }

    private static String getDefaultTranslationKey(Item item) {
        ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
        if ("minecraft".equals(id.m_135827_()) || "some_assembly_required".equals(id.m_135827_())) {
            return "%s.ingredient.%s".formatted("some_assembly_required", id.m_135815_());
        }
        return "%s.ingredient.%s.%s".formatted("some_assembly_required", id.m_135827_(), id.m_135815_());
    }
}

