/*
 * Decompiled with CFR 0.152.
 */
package someassemblyrequired.data.providers;

import com.google.gson.JsonElement;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import someassemblyrequired.data.providers.ingredient.CreateIngredients;
import someassemblyrequired.data.providers.ingredient.FarmersDelightIngredients;
import someassemblyrequired.data.providers.ingredient.IngredientBuilder;
import someassemblyrequired.data.providers.ingredient.MinersDelightIngredients;
import someassemblyrequired.ingredient.IngredientProperties;
import someassemblyrequired.integration.ModCompat;
import someassemblyrequired.registry.ModItems;

public record Ingredients(PackOutput packOutput) implements DataProvider
{
    private static final Map<Item, IngredientBuilder> INGREDIENTS = new HashMap<Item, IngredientBuilder>();
    public static final List<Item> MODEL_OVERRIDES = new ArrayList<Item>();

    private void addIngredients() {
        INGREDIENTS.clear();
        for (int i = 0; i < MODEL_OVERRIDES.size(); ++i) {
            Item item2 = MODEL_OVERRIDES.get(i);
            ItemStack displayItem = new ItemStack((ItemLike)ModItems.SPREAD.get());
            displayItem.m_41784_().m_128405_("CustomModelData", i + 1);
            this.builder(item2).setDisplayItem(displayItem);
        }
        if (ModCompat.isCreateLoaded()) {
            CreateIngredients.addIngredients(this);
        }
        if (ModCompat.isFarmersDelightLoaded()) {
            FarmersDelightIngredients.addIngredients(this);
        }
        if (ModCompat.isMinersDelightLoaded()) {
            MinersDelightIngredients.addIngredients(this);
        }
        ItemStack displayItem = INGREDIENTS.get(ModItems.GOLDEN_APPLE_SLICES.get()).getDisplayItem().m_41777_();
        displayItem.m_41784_().m_128379_("HasEffect", true);
        this.builder((Item)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get()).setDisplayItem(displayItem);
        this.builder(Items.f_42734_).setBowled().setSpread(9175075).setMoistSound();
        this.builder(Items.f_42400_).setBowled().setSpread(11367505).setMoistSound();
        this.builder(Items.f_42699_).setBowled().setSpread(12546612).setWetSound();
        this.builder(Items.f_42718_).setBowled().setSpread(4169344).setMoistSound();
        this.builder(Items.f_42787_).setCustomFullName().setBottled().setSpread(15771918).setMoistSound();
        this.builder(Items.f_42455_).setCustomFullName().setBucketed().setSpread(0xEEFDFF).setMoistSound();
        this.builder(Items.f_42620_).setHeight(5).setRenderAsItem(false);
        this.builder((Item)ModItems.BURGER_BUN.get()).setHeight(6).setRenderAsItem(false);
        String burgerBunHalf = "%s.ingredient.%s".formatted("some_assembly_required", "burger_bun_half");
        this.builder((Item)ModItems.BURGER_BUN_BOTTOM.get()).setHeight(2).setRenderAsItem(false).setFullName(burgerBunHalf);
        this.builder((Item)ModItems.BURGER_BUN_TOP.get()).setHeight(4).setRenderAsItem(false).setFullName(burgerBunHalf);
        this.builder(Items.f_41912_).setHeight(8).setRenderAsItem(false);
        Arrays.asList((Item)ModItems.TOASTED_BREAD_SLICE.get(), (Item)ModItems.APPLE_SLICES.get(), (Item)ModItems.GOLDEN_APPLE_SLICES.get(), (Item)ModItems.ENCHANTED_GOLDEN_APPLE_SLICES.get(), (Item)ModItems.CHOPPED_CARROT.get(), (Item)ModItems.CHOPPED_GOLDEN_CARROT.get(), (Item)ModItems.CHOPPED_BEETROOT.get(), (Item)ModItems.TOMATO_SLICES.get(), (Item)ModItems.SLICED_ONION.get()).forEach(item -> this.builder((Item)item).setCustomDisplayName());
    }

    public IngredientBuilder builder(Item item) {
        if (INGREDIENTS.containsKey(item)) {
            return INGREDIENTS.get(item);
        }
        IngredientBuilder builder = new IngredientBuilder(item);
        INGREDIENTS.put(item, builder);
        return builder;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        Path outputFolder = this.packOutput().m_245114_();
        ArrayList futures = new ArrayList();
        this.addIngredients();
        INGREDIENTS.forEach((item, builder) -> {
            IngredientProperties ingredient = builder.build();
            ResourceLocation id = ForgeRegistries.ITEMS.getKey(item);
            Object name = id.m_135815_();
            if (!"minecraft".equals(id.m_135827_()) && !"some_assembly_required".equals(id.m_135827_())) {
                name = id.m_135827_() + "/" + (String)name;
            }
            Path path = outputFolder.resolve("data/%s/%s/ingredients/%s.json".formatted("some_assembly_required", "some_assembly_required", name));
            futures.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)ingredient.toJson((Item)item), (Path)path));
        });
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public String m_6055_() {
        return "Ingredients";
    }

    static {
        MODEL_OVERRIDES.addAll(List.of((Item)ModItems.BURGER_BUN.get(), (Item)ModItems.BURGER_BUN_BOTTOM.get(), (Item)ModItems.BURGER_BUN_TOP.get(), (Item)ModItems.APPLE_SLICES.get(), (Item)ModItems.GOLDEN_APPLE_SLICES.get(), (Item)ModItems.CHOPPED_CARROT.get(), (Item)ModItems.CHOPPED_GOLDEN_CARROT.get(), (Item)ModItems.CHOPPED_BEETROOT.get(), (Item)ModItems.TOMATO_SLICES.get(), (Item)ModItems.SLICED_ONION.get()));
        MODEL_OVERRIDES.addAll(FarmersDelightIngredients.MODEL_OVERRIDES);
        MODEL_OVERRIDES.addAll(MinersDelightIngredients.MODEL_OVERRIDES);
        MODEL_OVERRIDES.add(Items.f_42620_);
    }
}

