/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.command;

import com.github.tartaricacid.netmusic.client.config.MusicListManage;
import com.github.tartaricacid.netmusic.init.InitItems;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.netmusic.network.message.GetMusicListMessage;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class NetMusicCommand {
    private static final String ROOT_NAME = "netmusic";
    private static final String RELOAD_NAME = "reload";
    private static final String GET_163_NAME = "get163";
    private static final String GET_163_CD_NAME = "get163cd";
    private static final String GET_DJ_CD_NAME = "getDJcd";
    private static final String SONG_LIST_ID = "song_list_id";
    private static final String SONG_ID = "song_id";
    private static final String DJ_SONG_ID = "dj_id";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.m_82127_((String)ROOT_NAME).requires(source -> source.m_6761_(2));
        LiteralArgumentBuilder get163List = Commands.m_82127_((String)GET_163_NAME);
        LiteralArgumentBuilder get163Song = Commands.m_82127_((String)GET_163_CD_NAME);
        LiteralArgumentBuilder reload = Commands.m_82127_((String)RELOAD_NAME);
        LiteralArgumentBuilder getDJSong = Commands.m_82127_((String)GET_DJ_CD_NAME);
        RequiredArgumentBuilder songListId = Commands.m_82129_((String)SONG_LIST_ID, (ArgumentType)LongArgumentType.longArg());
        RequiredArgumentBuilder songId = Commands.m_82129_((String)SONG_ID, (ArgumentType)LongArgumentType.longArg());
        RequiredArgumentBuilder djId = Commands.m_82129_((String)DJ_SONG_ID, (ArgumentType)LongArgumentType.longArg());
        root.then(get163List.then(songListId.executes(NetMusicCommand::getSongList)));
        root.then(get163Song.then(songId.executes(NetMusicCommand::getSong)));
        root.then(reload.executes(NetMusicCommand::reload));
        root.then(getDJSong.then(djId.executes(NetMusicCommand::getDJSong)));
        return root;
    }

    private static int getSong(CommandContext<CommandSourceStack> context) {
        try {
            long songId = LongArgumentType.getLong(context, (String)SONG_ID);
            ItemMusicCD.SongInfo songInfo = MusicListManage.get163Song(songId);
            ItemStack musicDisc = ItemMusicCD.setSongInfo(songInfo, ((Item)InitItems.MUSIC_CD.get()).m_7968_());
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            boolean canPlaceIn = serverPlayer.m_150109_().m_36054_(musicDisc);
            if (canPlaceIn && musicDisc.m_41619_()) {
                musicDisc.m_41764_(1);
                ItemEntity dropItem = serverPlayer.m_36176_(musicDisc, false);
                if (dropItem != null) {
                    dropItem.m_32065_();
                }
                serverPlayer.m_9236_().m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((serverPlayer.m_217043_().m_188501_() - serverPlayer.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.f_36095_.m_38946_();
            } else {
                ItemEntity dropItem = serverPlayer.m_36176_(musicDisc, false);
                if (dropItem != null) {
                    dropItem.m_32061_();
                    dropItem.m_32052_(serverPlayer.m_20148_());
                }
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"command.netmusic.music_cd.add163cd.success"), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.netmusic.music_cd.add163cd.fail"));
        }
        return 1;
    }

    private static int getSongList(CommandContext<CommandSourceStack> context) {
        try {
            long listId = LongArgumentType.getLong(context, (String)SONG_LIST_ID);
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            NetworkHandler.sendToClientPlayer(new GetMusicListMessage(listId), serverPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static int reload(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            NetworkHandler.sendToClientPlayer(new GetMusicListMessage(-1L), serverPlayer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 1;
    }

    private static int getDJSong(CommandContext<CommandSourceStack> context) {
        try {
            long djId = LongArgumentType.getLong(context, (String)DJ_SONG_ID);
            ItemMusicCD.SongInfo songInfo = MusicListManage.getDjSong(djId);
            ItemStack musicDisc = ItemMusicCD.setSongInfo(songInfo, ((Item)InitItems.MUSIC_CD.get()).m_7968_());
            ServerPlayer serverPlayer = ((CommandSourceStack)context.getSource()).m_81375_();
            boolean canPlaceIn = serverPlayer.m_150109_().m_36054_(musicDisc);
            if (canPlaceIn && musicDisc.m_41619_()) {
                musicDisc.m_41764_(1);
                ItemEntity dropItem = serverPlayer.m_36176_(musicDisc, false);
                if (dropItem != null) {
                    dropItem.m_32065_();
                }
                serverPlayer.m_9236_().m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, ((serverPlayer.m_217043_().m_188501_() - serverPlayer.m_217043_().m_188501_()) * 0.7f + 1.0f) * 2.0f);
                serverPlayer.f_36095_.m_38946_();
            } else {
                ItemEntity dropItem = serverPlayer.m_36176_(musicDisc, false);
                if (dropItem != null) {
                    dropItem.m_32061_();
                    dropItem.m_32052_(serverPlayer.m_20148_());
                }
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237115_((String)"command.netmusic.music_cd.addDJcd.success"), false);
        }
        catch (Exception e) {
            e.printStackTrace();
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.netmusic.music_cd.addDJcd.fail"));
        }
        return 1;
    }
}

