/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.gui;

import com.github.tartaricacid.netmusic.inventory.ComputerMenu;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.netmusic.network.message.SetMusicIDMessage;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class ComputerMenuScreen
extends AbstractContainerScreen<ComputerMenu> {
    private static final ResourceLocation BG = new ResourceLocation("netmusic", "textures/gui/computer.png");
    private static final Pattern URL_HTTP_REG = Pattern.compile("(http|ftp|https)://[\\w\\-_]+(\\.[\\w\\-_]+)+([\\w\\-.,@?^=%&:/~+#]*[\\w\\-@?^=%&/~+#])?");
    private static final Pattern URL_FILE_REG = Pattern.compile("^[a-zA-Z]:\\\\(?:[^\\\\/:*?\"<>|\\r\\n]+\\\\)*[^\\\\/:*?\"<>|\\r\\n]*$");
    private static final Pattern TIME_REG = Pattern.compile("^\\d+$");
    private EditBox urlTextField;
    private EditBox nameTextField;
    private EditBox timeTextField;
    private Checkbox readOnlyButton;
    private Component tips = Component.m_237119_();

    public ComputerMenuScreen(ComputerMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.f_97727_ = 216;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initUrlEditBox();
        this.initNameEditBox();
        this.initTimeEditBox();
        this.readOnlyButton = new Checkbox(this.f_97735_ + 58, this.f_97736_ + 55, 80, 20, (Component)Component.m_237115_((String)"gui.netmusic.cd_burner.read_only"), false);
        this.m_142416_((GuiEventListener)this.readOnlyButton);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.netmusic.cd_burner.craft"), b -> this.handleCraftButton()).m_252794_(this.f_97735_ + 7, this.f_97736_ + 78).m_253046_(135, 18).m_253136_());
    }

    private void initUrlEditBox() {
        String perText = "";
        boolean focus = false;
        if (this.urlTextField != null) {
            perText = this.urlTextField.m_94155_();
            focus = this.urlTextField.m_93696_();
        }
        this.urlTextField = new EditBox(this.getMinecraft().f_91062_, this.f_97735_ + 10, this.f_97736_ + 18, 120, 16, (Component)Component.m_237113_((String)"Music URL Box"));
        this.urlTextField.m_94144_(perText);
        this.urlTextField.m_94182_(false);
        this.urlTextField.m_94199_(32500);
        this.urlTextField.m_94202_(15986656);
        this.urlTextField.m_93692_(focus);
        this.urlTextField.m_94201_();
        this.m_7787_((GuiEventListener)this.urlTextField);
    }

    private void initNameEditBox() {
        String perText = "";
        boolean focus = false;
        if (this.nameTextField != null) {
            perText = this.nameTextField.m_94155_();
            focus = this.nameTextField.m_93696_();
        }
        this.nameTextField = new EditBox(this.getMinecraft().f_91062_, this.f_97735_ + 10, this.f_97736_ + 39, 120, 16, (Component)Component.m_237113_((String)"Music Name Box"));
        this.nameTextField.m_94144_(perText);
        this.nameTextField.m_94182_(false);
        this.nameTextField.m_94199_(256);
        this.nameTextField.m_94202_(15986656);
        this.nameTextField.m_93692_(focus);
        this.nameTextField.m_94201_();
        this.m_7787_((GuiEventListener)this.nameTextField);
    }

    private void initTimeEditBox() {
        String perText = "";
        boolean focus = false;
        if (this.timeTextField != null) {
            perText = this.timeTextField.m_94155_();
            focus = this.timeTextField.m_93696_();
        }
        this.timeTextField = new EditBox(this.getMinecraft().f_91062_, this.f_97735_ + 10, this.f_97736_ + 61, 40, 16, (Component)Component.m_237113_((String)"Music Time Box"));
        this.timeTextField.m_94144_(perText);
        this.timeTextField.m_94182_(false);
        this.timeTextField.m_94199_(5);
        this.timeTextField.m_94202_(15986656);
        this.timeTextField.m_93692_(focus);
        this.timeTextField.m_94201_();
        this.m_7787_((GuiEventListener)this.timeTextField);
    }

    private void handleCraftButton() {
        ItemStack cd = ((ComputerMenu)this.m_6262_()).getInput().getStackInSlot(0);
        if (cd.m_41619_()) {
            this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.cd_is_empty");
            return;
        }
        ItemMusicCD.SongInfo songInfo = ItemMusicCD.getSongInfo(cd);
        if (songInfo != null && songInfo.readOnly) {
            this.tips = Component.m_237115_((String)"gui.netmusic.cd_burner.cd_read_only");
            return;
        }
        String urlText = this.urlTextField.m_94155_();
        if (Util.m_288217_((String)urlText)) {
            this.tips = Component.m_237115_((String)"gui.netmusic.computer.url.empty");
            return;
        }
        String nameText = this.nameTextField.m_94155_();
        if (Util.m_288217_((String)nameText)) {
            this.tips = Component.m_237115_((String)"gui.netmusic.computer.name.empty");
            return;
        }
        String timeText = this.timeTextField.m_94155_();
        if (Util.m_288217_((String)timeText)) {
            this.tips = Component.m_237115_((String)"gui.netmusic.computer.time.empty");
            return;
        }
        if (!TIME_REG.matcher(timeText).matches()) {
            this.tips = Component.m_237115_((String)"gui.netmusic.computer.time.not_number");
            return;
        }
        int time = Integer.parseInt(timeText);
        if (URL_HTTP_REG.matcher(urlText).matches()) {
            ItemMusicCD.SongInfo song = new ItemMusicCD.SongInfo(urlText, nameText, time, this.readOnlyButton.m_93840_());
            NetworkHandler.CHANNEL.sendToServer((Object)new SetMusicIDMessage(song));
            return;
        }
        if (URL_FILE_REG.matcher(urlText).matches()) {
            File file = Paths.get(urlText, new String[0]).toFile();
            if (!file.isFile()) {
                this.tips = Component.m_237115_((String)"gui.netmusic.computer.url.local_file_error");
                return;
            }
            try {
                URL url = file.toURI().toURL();
                ItemMusicCD.SongInfo song = new ItemMusicCD.SongInfo(url.toString(), nameText, time, this.readOnlyButton.m_93840_());
                NetworkHandler.CHANNEL.sendToServer((Object)new SetMusicIDMessage(song));
                return;
            }
            catch (MalformedURLException e) {
                e.fillInStackTrace();
            }
        }
        this.tips = Component.m_237115_((String)"gui.netmusic.computer.url.error");
    }

    protected void m_280003_(GuiGraphics graphics, int x, int y) {
    }

    protected void m_7286_(GuiGraphics graphics, float partialTicks, int x, int y) {
        this.m_280273_(graphics);
        int posX = this.f_97735_;
        int posY = (this.f_96544_ - this.f_97727_) / 2;
        graphics.m_280218_(BG, posX, posY, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_88315_(GuiGraphics graphics, int x, int y, float partialTicks) {
        super.m_88315_(graphics, x, y, partialTicks);
        this.urlTextField.m_88315_(graphics, x, y, partialTicks);
        this.nameTextField.m_88315_(graphics, x, y, partialTicks);
        this.timeTextField.m_88315_(graphics, x, y, partialTicks);
        if (Util.m_288217_((String)this.urlTextField.m_94155_()) && !this.urlTextField.m_93696_()) {
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.netmusic.computer.url.tips").m_130940_(ChatFormatting.ITALIC), this.f_97735_ + 12, this.f_97736_ + 18, ChatFormatting.GRAY.m_126665_().intValue(), false);
        }
        if (Util.m_288217_((String)this.nameTextField.m_94155_()) && !this.nameTextField.m_93696_()) {
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.netmusic.computer.name.tips").m_130940_(ChatFormatting.ITALIC), this.f_97735_ + 12, this.f_97736_ + 39, ChatFormatting.GRAY.m_126665_().intValue(), false);
        }
        if (Util.m_288217_((String)this.timeTextField.m_94155_()) && !this.timeTextField.m_93696_()) {
            graphics.m_280614_(this.f_96547_, (Component)Component.m_237115_((String)"gui.netmusic.computer.time.tips").m_130940_(ChatFormatting.ITALIC), this.f_97735_ + 11, this.f_97736_ + 61, ChatFormatting.GRAY.m_126665_().intValue(), false);
        }
        graphics.m_280554_(this.f_96547_, (FormattedText)this.tips, this.f_97735_ + 8, this.f_97736_ + 100, 162, 0xCF0000);
        this.m_280072_(graphics, x, y);
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        String urlValue = this.urlTextField.m_94155_();
        String nameValue = this.nameTextField.m_94155_();
        String timeValue = this.timeTextField.m_94155_();
        super.m_6574_(minecraft, width, height);
        this.urlTextField.m_94144_(urlValue);
        this.nameTextField.m_94144_(nameValue);
        this.timeTextField.m_94144_(timeValue);
    }

    protected void m_181908_() {
        this.urlTextField.m_94120_();
        this.nameTextField.m_94120_();
        this.timeTextField.m_94120_();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.urlTextField.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.urlTextField);
            return true;
        }
        if (this.nameTextField.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.nameTextField);
            return true;
        }
        if (this.timeTextField.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.timeTextField);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)keyCode, (int)scanCode);
        if (this.getMinecraft().f_91066_.f_92092_.isActiveAndMatches(mouseKey) && (this.urlTextField.m_93696_() || this.nameTextField.m_93696_() || this.timeTextField.m_93696_())) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_6697_(String text, boolean overwrite) {
        if (overwrite) {
            this.urlTextField.m_94144_(text);
            this.nameTextField.m_94144_(text);
            this.timeTextField.m_94144_(text);
        } else {
            this.urlTextField.m_94164_(text);
            this.nameTextField.m_94164_(text);
            this.timeTextField.m_94164_(text);
        }
    }
}

