/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.config;

import com.github.tartaricacid.netmusic.NetMusic;
import com.github.tartaricacid.netmusic.api.ExtraMusicList;
import com.github.tartaricacid.netmusic.api.pojo.NetEaseMusicList;
import com.github.tartaricacid.netmusic.api.pojo.NetEaseMusicSong;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import org.apache.commons.io.FileUtils;

public class MusicListManage {
    private static final int MAX_NUM = 100;
    private static final Gson GSON = new Gson();
    private static final Path CONFIG_DIR = Paths.get("config", new String[0]).resolve("net_music");
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("music.json");
    public static List<ItemMusicCD.SongInfo> SONGS = Lists.newArrayList();

    public static void loadConfigSongs() throws IOException {
        if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
        }
        File file = CONFIG_FILE.toFile();
        InputStream stream = null;
        if (Files.exists(CONFIG_FILE, new LinkOption[0])) {
            stream = Files.newInputStream(file.toPath(), new OpenOption[0]);
        } else {
            ResourceLocation res = new ResourceLocation("netmusic", "music.json");
            Optional optional = Minecraft.m_91087_().m_91098_().m_213713_(res);
            if (optional.isPresent()) {
                stream = ((Resource)optional.get()).m_215507_();
            }
        }
        if (stream != null) {
            SONGS = (List)GSON.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), new TypeToken<List<ItemMusicCD.SongInfo>>(){}.getType());
        }
    }

    public static ItemMusicCD.SongInfo get163Song(long id) throws Exception {
        NetEaseMusicSong pojo = (NetEaseMusicSong)GSON.fromJson(NetMusic.NET_EASE_WEB_API.song(id), NetEaseMusicSong.class);
        return new ItemMusicCD.SongInfo(pojo);
    }

    public static ItemMusicCD.SongInfo getDjSong(long id) throws Exception {
        String result = NetMusic.NET_EASE_WEB_API.dj(id);
        JsonObject jsonObject = JsonParser.parseString((String)result).getAsJsonObject();
        JsonObject program = jsonObject.getAsJsonObject("program");
        if (program == null) {
            NetMusic.LOGGER.error("Failed to get DJ song info, program is null for id: {}", (Object)id);
            return new ItemMusicCD.SongInfo();
        }
        String mainSong = program.getAsJsonObject("mainSong").toString();
        if (mainSong == null) {
            NetMusic.LOGGER.error("Failed to get DJ song info, mainSong is null for id: {}", (Object)id);
            return new ItemMusicCD.SongInfo();
        }
        NetEaseMusicSong.Song netEaseMusicSong = (NetEaseMusicSong.Song)new Gson().fromJson(mainSong, NetEaseMusicSong.Song.class);
        return new ItemMusicCD.SongInfo(netEaseMusicSong);
    }

    public static void add163List(long id) throws Exception {
        Object ids;
        int size;
        NetEaseMusicList pojo;
        int count;
        if (!Files.isDirectory(CONFIG_DIR, new LinkOption[0])) {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
        }
        if ((count = (pojo = (NetEaseMusicList)GSON.fromJson(NetMusic.NET_EASE_WEB_API.list(id), NetEaseMusicList.class)).getPlayList().getTracks().size()) < (size = Math.min(pojo.getPlayList().getTrackIds().size(), 100))) {
            ids = new long[size - count];
            for (int i = count; i < size; ++i) {
                ids[i - count] = pojo.getPlayList().getTrackIds().get(i).getId();
            }
            String extraTrackInfo = NetMusic.NET_EASE_WEB_API.songs((long[])ids);
            ExtraMusicList extra = (ExtraMusicList)GSON.fromJson(extraTrackInfo, ExtraMusicList.class);
            pojo.getPlayList().getTracks().addAll(extra.getTracks());
        }
        SONGS.clear();
        ids = pojo.getPlayList().getTracks().iterator();
        while (ids.hasNext()) {
            NetEaseMusicList.Track track = (NetEaseMusicList.Track)ids.next();
            SONGS.add(new ItemMusicCD.SongInfo(track));
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        FileUtils.write((File)CONFIG_FILE.toFile(), (CharSequence)gson.toJson(SONGS), (Charset)StandardCharsets.UTF_8);
    }
}

