/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.registry.builtin;

import com.teamabnormals.endergetic.common.levelgen.biome.modifiers.SmallEndIslandsAmbienceBiomeModifier;
import com.teamabnormals.endergetic.core.other.tags.EEBiomeTags;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEFeatures;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public final class EEBiomeModifiers {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        EEBiomeModifiers.addSpawn(context, "add_eetle_spawns", EEBiomeTags.HAS_EETLE, new MobSpawnSettings.SpawnerData((EntityType)EEEntityTypes.CHARGER_EETLE.get(), 12, 2, 5), new MobSpawnSettings.SpawnerData((EntityType)EEEntityTypes.CHARGER_EETLE.get(), 8, 2, 4));
        EEBiomeModifiers.addFeature(context, "add_corrock_vegetation", EEBiomeTags.HAS_CORROCK, GenerationStep.Decoration.VEGETAL_DECORATION, EEFeatures.EEPlacedFeatures.CORROCK_PATCH, EEFeatures.EEPlacedFeatures.EETLE_EGG_PATCH);
        EEBiomeModifiers.addFeature(context, "add_corrock_surface_structures", EEBiomeTags.HAS_CORROCK, GenerationStep.Decoration.SURFACE_STRUCTURES, EEFeatures.EEPlacedFeatures.CORROCK_BRANCH, EEFeatures.EEPlacedFeatures.CORROCK_TOWER, EEFeatures.EEPlacedFeatures.CORROCK_SHELF, EEFeatures.EEPlacedFeatures.CORROCK_ARCH, EEFeatures.EEPlacedFeatures.EUMUS_PATCH, EEFeatures.EEPlacedFeatures.SPECKLED_CORROCK_PATCH);
        EEBiomeModifiers.addFeature(context, "add_sparse_corrock_branch", EEBiomeTags.HAS_SPARSE_CORROCK, GenerationStep.Decoration.SURFACE_STRUCTURES, EEFeatures.EEPlacedFeatures.SPARSE_CORROCK_BRANCH);
        EEBiomeModifiers.register(context, "small_end_islands_ambience", () -> SmallEndIslandsAmbienceBiomeModifier.INSTANCE);
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        EEBiomeModifiers.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), EEBiomeModifiers.featureSet(context, features), step));
    }

    private static void addSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, MobSpawnSettings.SpawnerData ... spawns) {
        EEBiomeModifiers.register(context, "add_spawn/" + name, () -> new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), List.of(spawns)));
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(placedFeatureKey -> context.m_255420_(Registries.f_256988_).m_255043_(placedFeatureKey)).collect(Collectors.toList()));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)new ResourceLocation("endergetic", name)), (Object)modifier.get());
    }
}

