/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.core.mixin;

import com.teamabnormals.endergetic.common.entity.bolloom.BolloomBalloon;
import com.teamabnormals.endergetic.common.network.entity.S2CUpdateBalloonsMessage;
import com.teamabnormals.endergetic.core.EndergeticExpansion;
import com.teamabnormals.endergetic.core.interfaces.BalloonHolder;
import java.io.File;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.network.Connection;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraftforge.network.PacketDistributor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PlayerList.class})
public final class PlayerListMixin {
    @Shadow
    @Final
    private PlayerDataStorage f_11204_;
    @Shadow
    @Final
    private MinecraftServer f_11195_;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/server/players/PlayerList;save(Lnet/minecraft/server/level/ServerPlayer;)V", shift=At.Shift.AFTER)}, method={"remove"})
    private void removeBalloons(ServerPlayer player, CallbackInfo info) {
        List<BolloomBalloon> balloons = ((BalloonHolder)player).getBalloons();
        for (BolloomBalloon balloon : balloons) {
            balloon.m_142467_(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"placeNewPlayer"})
    private void spawnBalloons(Connection connection, ServerPlayer player, CallbackInfo info) {
        ListTag balloonsTag;
        ServerLevel serverWorld = (ServerLevel)player.m_9236_();
        CompoundTag compound = this.f_11195_.m_129910_().m_6614_();
        if (compound == null || !this.f_11195_.m_7779_(player.m_36316_())) {
            try {
                File playerDataFile = new File(this.f_11204_.getPlayerDataFolder(), player.m_20149_() + ".dat");
                if (playerDataFile.exists() && playerDataFile.isFile()) {
                    compound = NbtIo.m_128937_((File)playerDataFile);
                }
            }
            catch (Exception exception) {
                EndergeticExpansion.LOGGER.warn("Failed to load player data for {}", (Object)player.m_7755_().getString());
            }
        }
        if (compound != null && compound.m_128425_("Balloons", 9) && !(balloonsTag = compound.m_128437_("Balloons", 10)).isEmpty()) {
            for (int i = 0; i < balloonsTag.size(); ++i) {
                Entity entity = EntityType.m_20645_((CompoundTag)balloonsTag.m_128728_(i), (Level)serverWorld, balloon -> !serverWorld.m_8847_(balloon) ? null : balloon);
                if (!(entity instanceof BolloomBalloon)) continue;
                ((BolloomBalloon)entity).attachToEntity((Entity)player);
                EndergeticExpansion.CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new S2CUpdateBalloonsMessage((Entity)player));
            }
        }
    }
}

