/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.structure.structures;

import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.teamabnormals.blueprint.core.util.MathUtil;
import com.teamabnormals.endergetic.common.block.CorrockCrownBlock;
import com.teamabnormals.endergetic.common.block.CorrockCrownStandingBlock;
import com.teamabnormals.endergetic.common.block.CorrockCrownWallBlock;
import com.teamabnormals.endergetic.common.block.EetleEggBlock;
import com.teamabnormals.endergetic.common.entity.eetle.BroodEetle;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import com.teamabnormals.endergetic.core.registry.EEEntityTypes;
import com.teamabnormals.endergetic.core.registry.EEStructureTypes;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.minecraft.world.level.levelgen.synth.PerlinSimplexNoise;
import net.minecraft.world.phys.Vec3;

public final class EetleNestPieces {
    private static final Set<BoundingBox> GENERATING_BOUNDS = new HashSet<BoundingBox>();
    private static final Direction[] ATTACHMENT_DIRECTIONS = Direction.values();
    private static final Direction[] TUNNEL_SIDES = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static final Direction[] EGG_DIRECTIONS = Direction.values();
    private static final Block CORROCK_BLOCK = (Block)EEBlocks.END_CORROCK_BLOCK.get();
    private static final Block EUMUS = (Block)EEBlocks.EUMUS.get();
    private static final Block CROWN_STANDING = (Block)EEBlocks.END_CORROCK_CROWN.get();
    private static final Block CROWN_WALL = (Block)EEBlocks.END_WALL_CORROCK_CROWN.get();
    private static final Block EETLE_EGSS = (Block)EEBlocks.EETLE_EGG.get();
    private static final Block CORROCK = (Block)EEBlocks.END_CORROCK.get();
    private static final Block SPECKLED_CORROCK = (Block)EEBlocks.SPECKLED_END_CORROCK.get();
    public static final Set<Block> CARVABLE_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.f_50069_, Blocks.f_50259_, CORROCK_BLOCK, CORROCK, CROWN_STANDING, CROWN_WALL, EETLE_EGSS, EUMUS, SPECKLED_CORROCK, (Block)EEBlocks.INFESTED_CORROCK.get(), (Block)EEBlocks.POISMOSS.get(), (Block)EEBlocks.EUMUS_POISMOSS.get()});
    private static final BlockState CORROCK_BLOCK_STATE = CORROCK_BLOCK.m_49966_();
    private static final BlockState CORROCK_STATE = CORROCK.m_49966_();
    private static final BlockState EUMUS_STATE = EUMUS.m_49966_();
    private static final BlockState CROWN_WALL_STATE = CROWN_WALL.m_49966_();
    private static final BlockState CROWN_STANDING_STATE = CROWN_STANDING.m_49966_();
    private static final BlockState SPECKLED_CORROCK_STATE = SPECKLED_CORROCK.m_49966_();
    private static final BlockState END_STONE = Blocks.f_50259_.m_49966_();
    private static final BlockState EETLE_EGGS_STATE = EETLE_EGSS.m_49966_();
    private static final BlockState INFESTED_STATE = ((Block)EEBlocks.INFESTED_CORROCK.get()).m_49966_();
    private static final Map<Long, PerlinSimplexNoise> SURFACE_NOISE = new HashMap<Long, PerlinSimplexNoise>();
    private static final Map<Long, PerlinNoise> UNDERGROUND_NOISE = new HashMap<Long, PerlinNoise>();

    public static boolean isNotInsideGeneratingBounds(BlockPos pos) {
        for (BoundingBox boundingBox : GENERATING_BOUNDS) {
            if (!boundingBox.m_71051_((Vec3i)pos)) continue;
            return false;
        }
        return true;
    }

    public static class EetleNestPiece
    extends StructurePiece {
        private static final ResourceLocation ARENA = new ResourceLocation("endergetic", "eetle_nest/arena");
        private final StructureTemplate arena;
        private NestDesign nestDesign = null;

        public EetleNestPiece(StructureTemplateManager manager, CompoundTag compoundNBT) {
            super((StructurePieceType)EEStructureTypes.EEStructurePieceTypes.EETLE_NEST.get(), compoundNBT);
            this.arena = (StructureTemplate)manager.m_230407_(ARENA).orElseThrow(() -> new RuntimeException("Failed to get Eetle Nest Arena Template!"));
        }

        public EetleNestPiece(StructureTemplateManager manager, BlockPos corner) {
            super((StructurePieceType)EEStructureTypes.EEStructurePieceTypes.EETLE_NEST.get(), 0, new BoundingBox(corner.m_123341_() - 64, corner.m_123342_() - 48, corner.m_123343_() - 64, corner.m_123341_() + 64, corner.m_123342_() + 6, corner.m_123343_() + 64));
            this.arena = (StructureTemplate)manager.m_230407_(ARENA).orElseThrow(() -> new RuntimeException("Failed to get Eetle Nest Arena Template!"));
        }

        private static void transformSurface(WorldGenLevel world, int x, int z, int maxDepth, int depthScale, double noise, BoundingBox boundingBox, BlockState topState, BlockState under) {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(x, boundingBox.m_162396_(), z);
            if (boundingBox.m_71051_((Vec3i)mutable)) {
                int startingY = world.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, x, z);
                int depth = (int)(Math.abs(noise) * (double)depthScale + 14.0);
                BlockState fillState = topState;
                int y = startingY;
                for (int d = 0; y > maxDepth && d < depth; --y, ++d) {
                    mutable.m_142448_(y);
                    if (!boundingBox.m_71051_((Vec3i)mutable)) continue;
                    Block block = world.m_8055_((BlockPos)mutable).m_60734_();
                    if (block == Blocks.f_50259_ || block == SPECKLED_CORROCK) {
                        world.m_7731_((BlockPos)mutable, fillState, 2);
                        fillState = under;
                        continue;
                    }
                    if (!world.m_46859_((BlockPos)mutable)) continue;
                    fillState = topState;
                }
            }
        }

        protected static void createEumusPatch(WorldGenLevel world, BlockPos origin, PerlinNoise noiseGenerator, int radius, BoundingBox bounds) {
            int originX = origin.m_123341_();
            int originY = origin.m_123342_();
            int originZ = origin.m_123343_();
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            for (int x = originX - radius; x < originX + radius; ++x) {
                for (int y = originY - radius; y < originY + radius; ++y) {
                    for (int z = originZ - radius; z < originZ + radius; ++z) {
                        double localX = (float)(x - originX) / (float)radius;
                        double localY = (float)(y - originY) / (float)radius;
                        double localZ = (float)(z - originZ) / (float)radius;
                        double distanceSq = localX * localX + localY * localY + localZ * localZ;
                        double frequency = 0.75;
                        double shapeNoise = noiseGenerator.m_75408_((double)x * frequency, (double)y * frequency, (double)z * frequency) * 0.5;
                        if (!(distanceSq <= 1.0 + shapeNoise)) continue;
                        mutable.m_122178_(x, y, z);
                        if (!bounds.m_71051_((Vec3i)mutable) || world.m_8055_((BlockPos)mutable).m_60734_() != CORROCK_BLOCK) continue;
                        world.m_7731_((BlockPos)mutable, EUMUS_STATE, 2);
                    }
                }
            }
        }

        protected void m_183620_(StructurePieceSerializationContext context, CompoundTag compoundTag) {
        }

        public void m_213694_(WorldGenLevel world, StructureManager structureManager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox bounds, ChunkPos chunkPos, BlockPos pos) {
            GENERATING_BOUNDS.add(this.f_73383_);
            int originX = pos.m_123341_();
            int originZ = pos.m_123343_();
            RandomState randomState = world.m_6018_().m_7726_().m_214994_();
            pos = new BlockPos(originX, chunkGenerator.m_223221_(originX, originZ, Heightmap.Types.WORLD_SURFACE_WG, (LevelHeightAccessor)world, randomState), originZ);
            PerlinSimplexNoise surfaceNoise = SURFACE_NOISE.computeIfAbsent(world.m_7328_(), seedL -> new PerlinSimplexNoise((RandomSource)new WorldgenRandom(RandomSource.m_216335_((long)seedL)), List.of(Integer.valueOf(-3), Integer.valueOf(0))));
            int radius = 32;
            for (int x = -radius; x < radius; ++x) {
                for (int z = -radius; z < radius; ++z) {
                    int posZ;
                    int posX;
                    double noise = surfaceNoise.m_75449_((double)x, (double)z, true);
                    double areaNoise = noise * 12.0 - 7.0;
                    double distanceSq = (double)(x * x + z * z) + areaNoise * areaNoise;
                    if (distanceSq <= (double)((radius - 3) * (radius - 3))) {
                        posX = originX + x;
                        posZ = originZ + z;
                        EetleNestPiece.transformSurface(world, posX, posZ, world.m_5736_() / 2, 40, noise, bounds, CORROCK_BLOCK_STATE, EUMUS_STATE);
                        continue;
                    }
                    if (!(distanceSq <= (double)(radius * radius))) continue;
                    posX = originX + x;
                    posZ = originZ + z;
                    float f = random.m_188501_();
                    float f2 = distanceSq >= (double)(((float)radius - 1.0f) * ((float)radius - 1.0f)) ? 0.3f : 0.0f;
                    if (!(f <= 0.6f - f2)) continue;
                    EetleNestPiece.transformSurface(world, posX, posZ, world.m_5736_() / 2, 24, noise, bounds, SPECKLED_CORROCK_STATE, END_STONE);
                }
            }
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
            BlockPos carvingPos = pos.m_6625_(24);
            int originY = carvingPos.m_123342_();
            PerlinNoise undergroundNoise = UNDERGROUND_NOISE.computeIfAbsent(world.m_7328_(), seedL -> PerlinNoise.m_230539_((RandomSource)new WorldgenRandom(RandomSource.m_216335_((long)seedL)), (IntStream)IntStream.rangeClosed(-4, -3)));
            if (this.nestDesign == null) {
                this.nestDesign = new NestDesign(random);
            }
            NestDesign nestDesign = this.nestDesign;
            NestCore nestCore = nestDesign.core;
            if (!nestCore.stateMap.setup) {
                nestCore.setup(originX, originY, originZ, random, undergroundNoise);
            }
            nestCore.generate(world, bounds);
            for (EumusPatch eumusPatch : nestDesign.eumusPatches) {
                eumusPatch.generate(world, carvingPos, undergroundNoise, bounds);
            }
            nestDesign.arena.generate(world, carvingPos.m_6630_(2), random, this.arena, bounds);
            Map<Pair<Integer, Integer>, Integer> horizontalToMaxHeight = nestCore.horizontalToMaxHeight;
            StateMap stateMap = nestCore.stateMap;
            for (NestStalactite stalactite : nestDesign.stalactites) {
                int placingX = originX + stalactite.xOffset;
                int placingZ = originZ + stalactite.zOffset;
                mutable.m_122178_(placingX, originY, placingZ);
                mutable.m_142448_(horizontalToMaxHeight.computeIfAbsent((Pair<Integer, Integer>)Pair.of((Object)placingX, (Object)placingZ), pair -> {
                    for (int i = 0; i < 18; ++i) {
                        mutable.m_122173_(Direction.UP);
                        if (stateMap.getBlockState((BlockPos)mutable).m_60734_() != CORROCK_BLOCK) continue;
                        return mutable.m_123342_();
                    }
                    return originY + 18;
                }).intValue());
                stalactite.generate(world, (BlockPos)mutable, random, undergroundNoise, bounds);
            }
            List<CorrockShelf> corrockShelves = nestCore.corrockShelves;
            for (NestTunnel tunnel : nestDesign.tunnels) {
                if (!tunnel.airPositions.isEmpty()) continue;
                Direction facing = tunnel.facing;
                mutable.m_122190_((Vec3i)carvingPos);
                for (int i = 0; i < 18; ++i) {
                    mutable.m_122173_(facing);
                    if (stateMap.getBlockState((BlockPos)mutable).m_60734_() == CORROCK_BLOCK) break;
                }
                tunnel.setup((BlockPos)mutable, chunkGenerator, (LevelHeightAccessor)world, randomState, undergroundNoise, random);
                BlockPos tunnelStart = tunnel.start;
                corrockShelves.removeIf(corrockShelf -> tunnelStart.m_123331_((Vec3i)corrockShelf.pos) <= 64.0);
            }
            nestCore.generateCorrockShelfs(world, bounds);
            for (NestTunnel tunnel : nestDesign.tunnels) {
                tunnel.generateCave(world, undergroundNoise, random, bounds);
            }
            for (NestTunnel tunnel : nestDesign.tunnels) {
                tunnel.generate(world, random, bounds);
            }
            for (NestTunnel tunnel : nestDesign.tunnels) {
                tunnel.generateDecorations(world, undergroundNoise, random, bounds);
            }
            nestCore.generateCorrockShelfDecorations(world, bounds);
            nestCore.generateCorrockPatches(world, random, bounds);
        }

        private static class NestDesign {
            private final List<EumusPatch> eumusPatches = new ArrayList<EumusPatch>();
            private final NestArena arena;
            private final NestCore core = new NestCore();
            private final List<NestStalactite> stalactites = new ArrayList<NestStalactite>();
            private final List<NestTunnel> tunnels = new ArrayList<NestTunnel>();

            private NestDesign(RandomSource random) {
                int eumusPatchCount = random.m_188503_(3) + 3;
                for (int i = 0; i < eumusPatchCount; ++i) {
                    this.eumusPatches.add(new EumusPatch(EumusPatch.PatchType.CORE, random));
                }
                this.arena = new NestArena(random);
                int stalactiteCount = random.m_188503_(3) + 3;
                for (int i = 0; i < stalactiteCount; ++i) {
                    this.stalactites.add(new NestStalactite(random));
                }
                EetleEggBlock.shuffleDirections(TUNNEL_SIDES, random);
                List<NestTunnel> tunnels = this.tunnels;
                for (Direction side : TUNNEL_SIDES) {
                    if (tunnels.size() < 3 || random.m_188499_()) {
                        tunnels.add(new NestTunnel(random, side));
                    }
                    if (!random.m_188499_()) continue;
                    tunnels.add(new NestTunnel(random, side));
                }
                for (int i = 0; i < 2; ++i) {
                    tunnels.get((int)random.m_188503_((int)tunnels.size())).goesToSurface = true;
                }
                HashSet<Direction> sidesWithCaves = new HashSet<Direction>();
                for (NestTunnel tunnel : this.tunnels) {
                    if (tunnel.goesToSurface || sidesWithCaves.contains(tunnel.facing)) continue;
                    tunnel.nestCave = new NestTunnel.NestCave(random);
                    sidesWithCaves.add(tunnel.facing);
                }
            }
        }

        private static class NestCore {
            private final StateMap stateMap = new StateMap();
            private final List<BlockPos> corrockPatchPositions = new ArrayList<BlockPos>();
            private final List<CorrockShelf> corrockShelves = new ArrayList<CorrockShelf>();
            private final Map<Pair<Integer, Integer>, Integer> horizontalToMaxHeight = new HashMap<Pair<Integer, Integer>, Integer>(5);

            private NestCore() {
            }

            private void setup(int originX, int originY, int originZ, RandomSource random, PerlinNoise undergroundNoise) {
                StateMap stateMap = this.stateMap;
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                int horizontalRadius = 28;
                int verticalRadius = 18;
                for (int x = originX - horizontalRadius; x < originX + horizontalRadius; ++x) {
                    for (int z = originZ - horizontalRadius; z < originZ + horizontalRadius; ++z) {
                        for (int y = originY - verticalRadius; y < originY + verticalRadius; ++y) {
                            mutable.m_122178_(x, y, z);
                            double localX = (float)(x - originX) / (float)horizontalRadius;
                            double localY = (float)(y - originY) / (float)verticalRadius;
                            double localZ = (float)(z - originZ) / (float)horizontalRadius;
                            double distanceSq = localX * localX + localY * localY + localZ * localZ;
                            double frequency = 0.65f;
                            double shapeNoise = undergroundNoise.m_75408_((double)x * frequency, (double)y * frequency, (double)z * frequency) * 0.5;
                            if (distanceSq >= (double)0.7f + shapeNoise && distanceSq <= (double)1.2f + shapeNoise) {
                                stateMap.setBlockState((BlockPos)mutable, CORROCK_BLOCK_STATE);
                                continue;
                            }
                            if (!(distanceSq <= (double)0.9f + shapeNoise)) continue;
                            stateMap.setBlockState((BlockPos)mutable, Blocks.f_50627_.m_49966_());
                        }
                    }
                }
                stateMap.setup = true;
                int cornerX = originX - 28;
                int cornerZ = originZ - 28;
                List<BlockPos> corrockPatchPositions = this.corrockPatchPositions;
                for (int i = 0; i < 64; ++i) {
                    corrockPatchPositions.add(new BlockPos(cornerX + random.m_188503_(57), originY - random.m_188503_(8), cornerZ + random.m_188503_(57)));
                }
                List<CorrockShelf> corrockShelves = this.corrockShelves;
                int shelfs = random.m_188503_(3) + 2;
                for (int i = 0; i < shelfs; ++i) {
                    Direction horizontal = Direction.Plane.HORIZONTAL.m_235690_(random);
                    BlockPos.MutableBlockPos mutable1 = new BlockPos.MutableBlockPos((double)originX, (double)originY + MathUtil.makeNegativeRandomly((double)random.m_188503_(8), (RandomSource)random), (double)originZ);
                    if (random.m_188501_() < 0.25f) {
                        for (int j = 0; j < horizontalRadius; ++j) {
                            mutable1.m_122173_(horizontal);
                            if (stateMap.getBlockState((BlockPos)mutable1).m_60734_() != CORROCK_BLOCK) continue;
                            corrockShelves.add(new CorrockShelf(mutable1.m_5484_(horizontal.m_122427_(), random.m_188503_(4) - random.m_188503_(4)), random));
                        }
                        continue;
                    }
                    int offset = random.m_188503_(horizontalRadius + 1);
                    mutable1.m_122175_(horizontal, offset);
                    Direction leftOrRight = random.m_188499_() ? horizontal.m_122427_() : horizontal.m_122428_();
                    for (int j = 0; j < horizontalRadius; ++j) {
                        mutable1.m_122173_(leftOrRight);
                        if (stateMap.getBlockState((BlockPos)mutable1).m_60734_() != CORROCK_BLOCK) continue;
                        corrockShelves.add(new CorrockShelf((BlockPos)mutable1, random));
                    }
                }
            }

            private void generate(WorldGenLevel world, BoundingBox bounds) {
                this.stateMap.generate(world, bounds);
            }

            private void generateCorrockPatches(WorldGenLevel world, RandomSource random, BoundingBox bounds) {
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                List<BlockPos> corrockPatchPositions = this.corrockPatchPositions;
                for (int i = 0; i < corrockPatchPositions.size(); ++i) {
                    BlockPos corrockPos = corrockPatchPositions.get(i);
                    if (bounds.m_71051_((Vec3i)corrockPos)) {
                        Block block;
                        mutable.m_122190_((Vec3i)corrockPos);
                        for (int y = 0; y < 18 && (block = world.m_8055_((BlockPos)mutable).m_60734_()) != CORROCK_BLOCK; ++y) {
                            mutable.m_122173_(Direction.DOWN);
                        }
                        corrockPos = mutable.m_7949_();
                        corrockPatchPositions.set(i, corrockPos);
                    }
                    for (int j = 0; j < 32; ++j) {
                        Block below;
                        mutable.m_122154_((Vec3i)corrockPos, random.m_188503_(8) - random.m_188503_(8), random.m_188503_(4) - random.m_188503_(4), random.m_188503_(8) - random.m_188503_(8));
                        if (!bounds.m_71051_((Vec3i)mutable) || !world.m_46859_((BlockPos)mutable) || !CORROCK_STATE.m_60710_((LevelReader)world, (BlockPos)mutable) || (below = world.m_8055_(mutable.m_7495_()).m_60734_()) != CORROCK_BLOCK && !(random.m_188501_() < 0.4f)) continue;
                        world.m_7731_((BlockPos)mutable, CORROCK_STATE, 2);
                    }
                }
            }

            private void generateCorrockShelfs(WorldGenLevel world, BoundingBox bounds) {
                for (CorrockShelf shelf : this.corrockShelves) {
                    shelf.generate(world, bounds);
                }
            }

            private void generateCorrockShelfDecorations(WorldGenLevel world, BoundingBox bounds) {
                for (CorrockShelf shelf : this.corrockShelves) {
                    shelf.generateDecorations(world, bounds);
                }
            }
        }

        private static class StateMap {
            private final Map<BlockPos, BlockState> stateMap = new HashMap<BlockPos, BlockState>();
            private boolean setup;

            private StateMap() {
            }

            private static void fillAreaWithBlockCube(StateMap stateMap, int x1, int y1, int z1, int x2, int y2, int z2, BlockState block) {
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (int yy = y1; yy <= y2; ++yy) {
                    for (int xx = x1; xx <= x2; ++xx) {
                        for (int zz = z1; zz <= z2; ++zz) {
                            mutable.m_122178_(xx, yy, zz);
                            stateMap.setBlockState((BlockPos)mutable, block);
                        }
                    }
                }
            }

            private void generate(WorldGenLevel world, BoundingBox bounds) {
                this.stateMap.forEach((pos, blockState) -> {
                    if (bounds.m_71051_((Vec3i)pos)) {
                        world.m_7731_(pos, blockState, 2);
                    }
                });
            }

            private void setBlockState(BlockPos pos, BlockState state) {
                this.stateMap.put(pos.m_7949_(), state);
            }

            private BlockState getBlockState(BlockPos pos) {
                return this.stateMap.getOrDefault(pos, Blocks.f_50016_.m_49966_());
            }
        }

        private static class EumusPatch {
            private final int radius;
            private final int xOffset;
            private final int yOffset;
            private final int zOffset;

            private EumusPatch(PatchType type, RandomSource random) {
                this.radius = random.m_188503_(type.boundRadius) + type.minRadius;
                int maxHorizontalOffset = type.maxHorizontalOffset;
                this.xOffset = random.m_188503_(maxHorizontalOffset) - random.m_188503_(maxHorizontalOffset);
                int halfMaxYOffset = type.halfMaxYOffset;
                this.yOffset = (int)MathUtil.makeNegativeRandomly((double)(random.m_188503_(halfMaxYOffset + 1) + halfMaxYOffset), (RandomSource)random);
                this.zOffset = random.m_188503_(maxHorizontalOffset) - random.m_188503_(maxHorizontalOffset);
            }

            private void generate(WorldGenLevel world, BlockPos center, PerlinNoise noiseGenerator, BoundingBox bounds) {
                EetleNestPiece.createEumusPatch(world, center.m_7918_(this.xOffset, this.yOffset, this.zOffset), noiseGenerator, this.radius, bounds);
            }

            static enum PatchType {
                CORE(4, 3, 19, 8),
                SMALL(2, 2, 10, 3),
                MEDIUM(3, 2, 13, 5),
                LARGE(3, 3, 15, 6);

                private final int minRadius;
                private final int boundRadius;
                private final int maxHorizontalOffset;
                private final int halfMaxYOffset;

                private PatchType(int minRadius, int boundRadius, int maxHorizontalOffset, int halfMaxYOffset) {
                    this.minRadius = minRadius;
                    this.boundRadius = boundRadius;
                    this.maxHorizontalOffset = maxHorizontalOffset;
                    this.halfMaxYOffset = halfMaxYOffset;
                }
            }
        }

        private static class NestArena {
            private static final EnumMap<Rotation, BottomStepsRotationInfo> BOTTOM_STEPS_ROTATION_INFO = (EnumMap)Util.m_137469_(new EnumMap(Rotation.class), map -> {
                map.put(Rotation.NONE, new BottomStepsRotationInfo(1, -1, Direction.NORTH, 1, 4, 2, 5, -2, 3, -1, 4, -4, 1, 0, -3, Direction.NORTH, Direction.EAST));
                map.put(Rotation.CLOCKWISE_90, new BottomStepsRotationInfo(1, 1, Direction.SOUTH, -5, 1, -4, 2, -3, -2, -2, -1, -1, -5, 4, -1, Direction.EAST, Direction.SOUTH));
                map.put(Rotation.CLOCKWISE_180, new BottomStepsRotationInfo(-1, 1, Direction.SOUTH, -2, -4, -1, -3, 1, -3, 2, -2, 4, 1, 1, 4, Direction.NORTH, Direction.WEST));
                map.put(Rotation.COUNTERCLOCKWISE_90, new BottomStepsRotationInfo(-1, -1, Direction.NORTH, 3, -2, 4, -1, 2, 1, 3, 2, 0, 5, -4, 1, Direction.WEST, Direction.NORTH));
            });
            private final Rotation rotation;
            private final Direction bottomDoorDirection;
            private final Rotation stepsRotation;
            private final Direction topDoorDirection;
            private final Direction topDoorLeftOrRight;
            private final StateMap smallSteps = new StateMap();
            private final StateMap mediumStep = new StateMap();
            private final StateMap largeStep = new StateMap();

            private NestArena(RandomSource random) {
                this.rotation = Rotation.m_221990_((RandomSource)random);
                this.bottomDoorDirection = Direction.Plane.HORIZONTAL.m_235690_(random);
                switch (this.bottomDoorDirection) {
                    default: {
                        this.stepsRotation = Rotation.COUNTERCLOCKWISE_90;
                        break;
                    }
                    case EAST: {
                        this.stepsRotation = Rotation.NONE;
                        break;
                    }
                    case SOUTH: {
                        this.stepsRotation = Rotation.CLOCKWISE_90;
                        break;
                    }
                    case WEST: {
                        this.stepsRotation = Rotation.CLOCKWISE_180;
                    }
                }
                this.topDoorDirection = Direction.Plane.HORIZONTAL.m_235690_(random);
                this.topDoorLeftOrRight = random.m_188499_() ? this.topDoorDirection.m_122427_() : this.topDoorDirection.m_122428_();
            }

            private static void searchAndPlaceTopGate(WorldGenLevel world, BlockPos start, RandomSource random, Direction opposite, BoundingBox bounds) {
                BlockPos.MutableBlockPos mutable = start.m_122032_();
                for (int i = 0; i <= 7; ++i) {
                    if (bounds.m_71051_((Vec3i)mutable) && world.m_8055_((BlockPos)mutable).m_60734_() == CORROCK_BLOCK) {
                        BlockPos up = mutable.m_7494_();
                        world.m_7731_(up, CORROCK_BLOCK_STATE, 2);
                        NestArena.tryToPlaceCrownAroundPos(world, up, random, bounds);
                        break;
                    }
                    mutable.m_122173_(opposite);
                }
            }

            private static void createOuterStairPiece(WorldGenLevel world, BlockPos start, RandomSource random, Direction opposite, BoundingBox bounds, int length) {
                BlockPos.MutableBlockPos mutable = start.m_122032_();
                for (int i = 0; i < length; ++i) {
                    if (bounds.m_71051_((Vec3i)mutable)) {
                        world.m_7731_((BlockPos)mutable, CORROCK_BLOCK_STATE, 2);
                    }
                    mutable.m_122173_(opposite);
                    if (bounds.m_71051_((Vec3i)mutable) && world.m_8055_((BlockPos)mutable).m_60734_() == CORROCK_BLOCK) break;
                }
                if (random.m_188499_()) {
                    NestArena.tryToPlaceCrownAroundPos(world, start, random, bounds);
                }
            }

            private static void createLedgePiece(WorldGenLevel world, BlockPos middle, Direction right, Direction left, RandomSource random, int radius, boolean generateCrowns, BoundingBox bounds) {
                BlockPos.MutableBlockPos leftMutable = middle.m_122032_();
                BlockPos.MutableBlockPos rightMutable = middle.m_122032_();
                for (int i = 0; i <= radius; ++i) {
                    if (bounds.m_71051_((Vec3i)leftMutable)) {
                        world.m_7731_((BlockPos)leftMutable, CORROCK_BLOCK_STATE, 2);
                    }
                    if (bounds.m_71051_((Vec3i)rightMutable)) {
                        world.m_7731_((BlockPos)rightMutable, CORROCK_BLOCK_STATE, 2);
                    }
                    if (generateCrowns && i == radius) {
                        if (random.m_188499_()) {
                            NestArena.tryToPlaceCrownAroundPos(world, (BlockPos)leftMutable, random, bounds);
                        }
                        if (random.m_188499_()) {
                            NestArena.tryToPlaceCrownAroundPos(world, (BlockPos)rightMutable, random, bounds);
                        }
                    }
                    leftMutable.m_122173_(left);
                    rightMutable.m_122173_(right);
                }
            }

            private static int randomRange(int min, int max, RandomSource random) {
                return random.m_188503_(max - min + 1) + min;
            }

            private static void tryToPlaceCrownAroundPos(WorldGenLevel world, BlockPos pos, RandomSource random, BoundingBox bounds) {
                EetleEggBlock.shuffleDirections(ATTACHMENT_DIRECTIONS, random);
                for (Direction direction : ATTACHMENT_DIRECTIONS) {
                    if (direction.m_122434_() == Direction.Axis.Y) {
                        BlockPos offset;
                        boolean upsideDown = direction == Direction.DOWN;
                        BlockPos blockPos = offset = upsideDown ? pos.m_7495_() : pos.m_7494_();
                        if (!bounds.m_71051_((Vec3i)offset) || !world.m_46859_(offset)) continue;
                        world.m_7731_(offset, (BlockState)((BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(upsideDown))).m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))), 2);
                        break;
                    }
                    BlockPos offset = pos.m_121945_(direction);
                    if (!bounds.m_71051_((Vec3i)offset) || !world.m_46859_(offset)) continue;
                    world.m_7731_(offset, (BlockState)CROWN_WALL_STATE.m_61124_((Property)CorrockCrownWallBlock.FACING, (Comparable)direction), 2);
                    break;
                }
            }

            private static void createHorizontalCrownedCluster(StateMap stateMap, BlockPos pos, RandomSource random) {
                BlockPos up = pos.m_6630_(2);
                for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                    BlockPos offsetUp;
                    BlockPos offset;
                    if (random.m_188501_() < 0.8f) {
                        offset = pos.m_121945_(horizontal);
                        stateMap.setBlockState(offset, CORROCK_BLOCK_STATE);
                        offsetUp = offset.m_7494_();
                        if (random.m_188501_() < 0.15f) {
                            stateMap.setBlockState(offsetUp, (BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))));
                        }
                    }
                    if (!(random.m_188501_() < 0.8f)) continue;
                    offset = up.m_121945_(horizontal);
                    stateMap.setBlockState(offset, CORROCK_BLOCK_STATE);
                    offsetUp = offset.m_7494_();
                    if (!(random.m_188501_() < 0.2f)) continue;
                    stateMap.setBlockState(offsetUp, (BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))));
                }
            }

            private static void fillForward(WorldGenLevel world, BlockPos pos, Direction forward, BoundingBox bounds) {
                BlockPos.MutableBlockPos mutable = pos.m_122032_();
                for (int i = 0; i <= 4; ++i) {
                    if (!bounds.m_71051_((Vec3i)mutable)) continue;
                    if (!world.m_46859_((BlockPos)mutable)) break;
                    world.m_7731_((BlockPos)mutable, CORROCK_BLOCK_STATE, 2);
                    mutable.m_122173_(forward);
                }
            }

            private static void createLargeStepBottom(StateMap stateMap, BlockPos pos, RandomSource random) {
                for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                    BlockPos offset;
                    if (random.m_188499_()) {
                        offset = pos.m_121945_(horizontal);
                        stateMap.setBlockState(offset, CORROCK_BLOCK_STATE);
                        if (!(random.m_188501_() < 0.25f)) continue;
                        stateMap.setBlockState(offset.m_7494_(), (BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))));
                        continue;
                    }
                    if (!random.m_188499_()) continue;
                    offset = pos.m_121945_(horizontal);
                    stateMap.setBlockState(offset, CORROCK_BLOCK_STATE);
                    stateMap.setBlockState(offset.m_7494_(), CORROCK_BLOCK_STATE);
                    if (random.m_188501_() < 0.25f) {
                        stateMap.setBlockState(offset.m_6630_(2), (BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))));
                    }
                    if (!random.m_188499_()) continue;
                    BlockPos doubleOffset = pos.m_5484_(horizontal, 2);
                    stateMap.setBlockState(doubleOffset, CORROCK_BLOCK_STATE);
                    if (!(random.m_188501_() < 0.25f)) continue;
                    stateMap.setBlockState(doubleOffset.m_7494_(), (BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))));
                }
            }

            private static void createLargeStepTop(StateMap stateMap, BlockPos pos, RandomSource random) {
                for (Direction horizontal : Direction.Plane.HORIZONTAL) {
                    BlockPos offset = pos.m_121945_(horizontal);
                    stateMap.setBlockState(offset, CORROCK_BLOCK_STATE);
                    if (random.m_188501_() < 0.2f) {
                        stateMap.setBlockState(offset.m_7494_(), (BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))));
                    }
                    if (!(random.m_188501_() < 0.25f)) continue;
                    BlockPos otherOffset = offset.m_121945_(Direction.Plane.HORIZONTAL.m_235690_(random));
                    stateMap.setBlockState(otherOffset, CORROCK_BLOCK_STATE);
                    if (random.m_188501_() < 0.2f) {
                        stateMap.setBlockState(otherOffset.m_7494_(), (BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))));
                    }
                    stateMap.setBlockState(offset.m_7495_(), CORROCK_BLOCK_STATE);
                }
            }

            private static void carveForward(WorldGenLevel world, BlockPos pos, Direction forward, BoundingBox bounds) {
                BlockPos.MutableBlockPos mutable = pos.m_122032_();
                for (int i = 0; i <= 4; ++i) {
                    if (bounds.m_71051_((Vec3i)mutable)) {
                        world.m_7731_((BlockPos)mutable, f_73382_, 2);
                    }
                    mutable.m_122173_(forward);
                }
            }

            private static void carveForwardLimited(WorldGenLevel world, BlockPos pos, Direction forward, BoundingBox bounds) {
                BlockPos.MutableBlockPos mutable = pos.m_122032_();
                int carved = 0;
                for (int i = 0; i <= 4; ++i) {
                    if (bounds.m_71051_((Vec3i)mutable) && world.m_8055_((BlockPos)mutable).m_60734_() == CORROCK_BLOCK) {
                        world.m_7731_((BlockPos)mutable, f_73382_, 2);
                        if (++carved == 2) break;
                    }
                    mutable.m_122173_(forward);
                }
            }

            private static BlockPos offsetPosForRotation(BlockPos pos, Rotation rotation) {
                switch (rotation) {
                    default: {
                        return pos;
                    }
                    case CLOCKWISE_90: {
                        return pos.m_7918_(22, 0, 0);
                    }
                    case CLOCKWISE_180: {
                        return pos.m_7918_(22, 0, 22);
                    }
                    case COUNTERCLOCKWISE_90: 
                }
                return pos.m_7918_(0, 0, 22);
            }

            private void createWayUp(WorldGenLevel world, BlockPos center, Direction horizontal, Direction leftOrRight, RandomSource random, BoundingBox bounds) {
                BlockPos.MutableBlockPos mutable = center.m_122032_();
                mutable.m_122175_(horizontal, 7);
                NestArena.carveForward(world, (BlockPos)mutable, horizontal, bounds);
                NestArena.carveForward(world, mutable.m_7494_(), horizontal, bounds);
                NestArena.carveForward(world, mutable.m_6630_(2), horizontal, bounds);
                Direction cw = horizontal.m_122427_();
                BlockPos rotateCW = mutable.m_121945_(cw);
                NestArena.carveForward(world, rotateCW, horizontal, bounds);
                NestArena.carveForward(world, rotateCW.m_7494_(), horizontal, bounds);
                Direction ccw = horizontal.m_122428_();
                BlockPos rotateCCW = mutable.m_121945_(ccw);
                NestArena.carveForward(world, rotateCCW, horizontal, bounds);
                NestArena.carveForward(world, rotateCCW.m_7494_(), horizontal, bounds);
                BlockPos outsideCenter = mutable.m_5484_(horizontal, 2).m_7495_();
                for (int l = 0; l < 4; ++l) {
                    BlockPos offset = outsideCenter.m_5484_(horizontal, l);
                    NestArena.createLedgePiece(world, offset, cw, ccw, random, 4 - l, true, bounds);
                    NestArena.createLedgePiece(world, offset.m_7495_(), cw, ccw, random, 2 - l, false, bounds);
                    if (l != 3 || !(random.m_188501_() < 0.25f)) continue;
                    NestArena.tryToPlaceCrownAroundPos(world, offset, random, bounds);
                }
                BlockPos outsideThree = outsideCenter.m_5484_(horizontal, 3);
                BlockPos firstStairEdge = outsideThree.m_5484_(leftOrRight, 2);
                if (bounds.m_71051_((Vec3i)firstStairEdge)) {
                    world.m_7731_(firstStairEdge, CORROCK_BLOCK_STATE, 2);
                    NestArena.tryToPlaceCrownAroundPos(world, firstStairEdge, random, bounds);
                }
                Direction opposite = horizontal.m_122424_();
                mutable = outsideThree.m_122032_();
                mutable.m_122175_(leftOrRight, 2);
                int startY = mutable.m_123342_();
                int term = 1;
                for (int n = 0; n < 6; ++n) {
                    mutable.m_142448_(startY + (term += n % 2));
                    NestArena.createOuterStairPiece(world, (BlockPos)mutable.m_122173_(leftOrRight), random, opposite, bounds, 5);
                }
                NestArena.createOuterStairPiece(world, (BlockPos)mutable.m_122173_(leftOrRight).m_122173_(opposite), random, opposite, bounds, 7);
                NestArena.createOuterStairPiece(world, (BlockPos)mutable.m_122173_(leftOrRight).m_122173_(opposite), random, opposite, bounds, 7);
                Direction leftOrRightOpposite = leftOrRight.m_122424_();
                NestArena.carveForwardLimited(world, (BlockPos)mutable.m_122173_(Direction.UP).m_122173_(leftOrRightOpposite), opposite, bounds);
                NestArena.carveForwardLimited(world, (BlockPos)mutable.m_122173_(leftOrRightOpposite), opposite, bounds);
                NestArena.searchAndPlaceTopGate(world, (BlockPos)mutable.m_122175_(leftOrRight, 2), random, opposite, bounds);
                NestArena.searchAndPlaceTopGate(world, (BlockPos)mutable.m_122175_(leftOrRightOpposite, 3), random, opposite, bounds);
            }

            private void createCenterSteps(WorldGenLevel world, BlockPos center, Rotation rotation, RandomSource random, BoundingBox bounds) {
                StateMap smallStep = this.smallSteps;
                BottomStepsRotationInfo bottomRotationInfo = BOTTOM_STEPS_ROTATION_INFO.get(rotation);
                int xDirection = bottomRotationInfo.xDirection;
                int zDirection = bottomRotationInfo.zDirection;
                Direction ledgeFillDirection = bottomRotationInfo.ledgeFillDirection;
                NestArena.fillForward(world, center.m_7918_(3 * xDirection, 0, 4 * zDirection), ledgeFillDirection, bounds);
                NestArena.fillForward(world, center.m_7918_(4 * xDirection, 0, 3 * zDirection), ledgeFillDirection, bounds);
                NestArena.fillForward(world, center.m_7918_(5 * xDirection, 0, 3 * zDirection), ledgeFillDirection, bounds);
                NestArena.fillForward(world, center.m_7918_(6 * xDirection, 0, 3 * zDirection), ledgeFillDirection, bounds);
                center = center.m_6625_(4);
                if (!smallStep.setup) {
                    int centerX = center.m_123341_();
                    int centerY = center.m_123342_();
                    int centerZ = center.m_123343_();
                    StateMap.fillAreaWithBlockCube(smallStep, centerX + bottomRotationInfo.firstSmallStepMinX, centerY, centerZ + bottomRotationInfo.firstSmallStepMinZ, centerX + bottomRotationInfo.firstSmallStepMaxX, centerY, centerZ + bottomRotationInfo.firstSmallStepMaxZ, CORROCK_BLOCK_STATE);
                    if (random.m_188499_()) {
                        smallStep.setBlockState(center.m_7918_(NestArena.randomRange(bottomRotationInfo.firstSmallStepMinX, bottomRotationInfo.firstSmallStepMaxX, random), 1, NestArena.randomRange(bottomRotationInfo.firstSmallStepMinZ, bottomRotationInfo.firstSmallStepMaxZ, random)), (BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))));
                    }
                    StateMap.fillAreaWithBlockCube(smallStep, centerX + bottomRotationInfo.secondSmallStepMinX, centerY, centerZ + bottomRotationInfo.secondSmallStepMinZ, centerX + bottomRotationInfo.secondSmallStepMaxX, centerY + 1, centerZ + bottomRotationInfo.secondSmallStepMaxZ, CORROCK_BLOCK_STATE);
                    smallStep.setBlockState(center.m_7918_(NestArena.randomRange(bottomRotationInfo.secondSmallStepMinX, bottomRotationInfo.secondSmallStepMaxX, random), 0, NestArena.randomRange(bottomRotationInfo.secondSmallStepMinZ, bottomRotationInfo.secondSmallStepMaxZ, random)), f_73382_);
                    if (random.m_188501_() < 0.6f) {
                        smallStep.setBlockState(center.m_7918_(NestArena.randomRange(bottomRotationInfo.secondSmallStepMinX, bottomRotationInfo.secondSmallStepMaxX, random), 2, NestArena.randomRange(bottomRotationInfo.secondSmallStepMinZ, bottomRotationInfo.secondSmallStepMaxZ, random)), (BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))));
                    }
                    smallStep.setup = true;
                }
                smallStep.generate(world, bounds);
                this.createMediumStep(world, center.m_7918_(bottomRotationInfo.mediumStepOffsetX, 0, bottomRotationInfo.mediumStepOffsetZ), random, bottomRotationInfo.mediumStepDirection, bounds);
                this.createLargeStep(world, center.m_7918_(bottomRotationInfo.largeStepOffsetX, 0, bottomRotationInfo.largeStepOffsetZ), random, bottomRotationInfo.largeStepDirection, bounds);
            }

            private void createMediumStep(WorldGenLevel world, BlockPos pos, RandomSource random, Direction direction, BoundingBox bounds) {
                StateMap mediumStep = this.mediumStep;
                if (!mediumStep.setup) {
                    BlockPos.MutableBlockPos mutable = pos.m_122032_();
                    int startY = mutable.m_123342_();
                    for (int y = 0; y < 3; ++y) {
                        mutable.m_142448_(startY + y);
                        mediumStep.setBlockState((BlockPos)mutable, CORROCK_BLOCK_STATE);
                    }
                    NestArena.createHorizontalCrownedCluster(mediumStep, pos, random);
                    BlockPos offset = pos.m_121945_(direction);
                    mutable = offset.m_122032_();
                    for (int y = 0; y < 3; ++y) {
                        mutable.m_142448_(startY + y);
                        mediumStep.setBlockState((BlockPos)mutable, CORROCK_BLOCK_STATE);
                    }
                    NestArena.createHorizontalCrownedCluster(mediumStep, offset, random);
                    mediumStep.setup = true;
                }
                mediumStep.stateMap.forEach((posEntry, state) -> {
                    if (bounds.m_71051_((Vec3i)posEntry)) {
                        if (state.m_60734_() instanceof CorrockCrownBlock) {
                            if (world.m_46859_(posEntry)) {
                                world.m_7731_(posEntry, state, 2);
                            }
                        } else {
                            world.m_7731_(posEntry, state, 2);
                        }
                    }
                });
            }

            private void createLargeStep(WorldGenLevel world, BlockPos pos, RandomSource random, Direction direction, BoundingBox bounds) {
                StateMap largeStep = this.largeStep;
                if (!largeStep.setup) {
                    BlockPos.MutableBlockPos mutable = pos.m_122032_();
                    int startY = mutable.m_123342_();
                    for (int y = 0; y < 4; ++y) {
                        mutable.m_142448_(startY + y);
                        largeStep.setBlockState((BlockPos)mutable, CORROCK_BLOCK_STATE);
                    }
                    NestArena.createLargeStepBottom(largeStep, pos, random);
                    NestArena.createLargeStepTop(largeStep, (BlockPos)mutable, random);
                    BlockPos offset = pos.m_121945_(direction);
                    mutable = offset.m_122032_();
                    for (int y = 0; y < 4; ++y) {
                        mutable.m_142448_(startY + y);
                        largeStep.setBlockState((BlockPos)mutable, CORROCK_BLOCK_STATE);
                    }
                    NestArena.createLargeStepBottom(largeStep, offset, random);
                    NestArena.createLargeStepTop(largeStep, (BlockPos)mutable, random);
                    largeStep.setup = true;
                }
                largeStep.stateMap.forEach((posEntry, state) -> {
                    if (bounds.m_71051_((Vec3i)posEntry)) {
                        if (state.m_60734_() instanceof CorrockCrownBlock) {
                            if (world.m_46859_(posEntry)) {
                                world.m_7731_(posEntry, state, 2);
                            }
                        } else {
                            world.m_7731_(posEntry, state, 2);
                        }
                    }
                });
            }

            private void generate(WorldGenLevel world, BlockPos origin, RandomSource random, StructureTemplate arena, BoundingBox bounds) {
                BroodEetle broodEetle;
                BlockPos min = origin.m_7918_(-11, -16, -11);
                BlockPos max = origin.m_7918_(11, 1, 11);
                arena.m_230328_((ServerLevelAccessor)world, NestArena.offsetPosForRotation(min, this.rotation), origin, new StructurePlaceSettings().m_74379_(this.rotation).m_74381_(bounds), random, 2);
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                int extraFillBottomY = origin.m_123342_() - 16;
                for (int x = min.m_123341_(); x <= max.m_123341_(); ++x) {
                    for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                        mutable.m_122178_(x, extraFillBottomY, z);
                        if (!bounds.m_71051_((Vec3i)mutable) || world.m_8055_((BlockPos)mutable).m_60734_() != Blocks.f_50074_) continue;
                        world.m_7731_((BlockPos)mutable, CORROCK_BLOCK_STATE, 2);
                        for (int y = extraFillBottomY; y > extraFillBottomY - 3; --y) {
                            mutable.m_142448_(y);
                            world.m_7731_((BlockPos)mutable, CORROCK_BLOCK_STATE, 2);
                        }
                    }
                }
                mutable = origin.m_6625_(3).m_122032_();
                if (bounds.m_71051_((Vec3i)mutable) && (broodEetle = (BroodEetle)((EntityType)EEEntityTypes.BROOD_EETLE.get()).m_20615_((Level)world.m_6018_())) != null) {
                    broodEetle.setSleeping(true);
                    broodEetle.m_7678_((double)mutable.m_123341_() + 0.5, mutable.m_123342_(), (double)mutable.m_123343_() + 0.5, 0.0f, 0.0f);
                    broodEetle.m_6518_((ServerLevelAccessor)world, world.m_6436_(broodEetle.m_20183_()), MobSpawnType.STRUCTURE, null, null);
                    world.m_47205_((Entity)broodEetle);
                }
                mutable.m_122175_(Direction.DOWN, 10);
                Direction horizontal = this.bottomDoorDirection;
                mutable.m_122175_(horizontal, 6);
                NestArena.carveForward(world, (BlockPos)mutable, horizontal, bounds);
                NestArena.carveForward(world, mutable.m_7494_(), horizontal, bounds);
                NestArena.carveForward(world, mutable.m_6630_(2), horizontal, bounds);
                BlockPos rotateCW = mutable.m_121945_(horizontal.m_122427_());
                NestArena.carveForward(world, rotateCW, horizontal, bounds);
                NestArena.carveForward(world, rotateCW.m_7494_(), horizontal, bounds);
                BlockPos rotateCCW = mutable.m_121945_(horizontal.m_122428_());
                NestArena.carveForward(world, rotateCCW, horizontal, bounds);
                NestArena.carveForward(world, rotateCCW.m_7494_(), horizontal, bounds);
                this.createCenterSteps(world, origin.m_6625_(9), this.stepsRotation, random, bounds);
                this.createWayUp(world, origin.m_6625_(7), this.topDoorDirection, this.topDoorLeftOrRight, random, bounds);
                int arenaTopY = origin.m_123342_() - 3;
                for (int x = min.m_123341_(); x <= max.m_123341_(); ++x) {
                    block4: for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                        mutable.m_122178_(x, arenaTopY, z);
                        if (!bounds.m_71051_((Vec3i)mutable) || world.m_8055_((BlockPos)mutable).m_60734_() != CORROCK_BLOCK || !random.m_188499_()) continue;
                        EetleEggBlock.shuffleDirections(ATTACHMENT_DIRECTIONS, random);
                        for (Direction direction : ATTACHMENT_DIRECTIONS) {
                            BlockPos offset;
                            if (direction.m_122434_() == Direction.Axis.Y) {
                                direction = Direction.UP;
                                offset = mutable.m_121945_(direction);
                                if (!bounds.m_71051_((Vec3i)offset) || !world.m_46859_(offset)) continue;
                                world.m_7731_(offset, (BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))), 2);
                                continue block4;
                            }
                            offset = mutable.m_121945_(direction);
                            if (!bounds.m_71051_((Vec3i)offset) || !world.m_46859_(offset) || !world.m_46859_(offset.m_7495_())) continue;
                            world.m_7731_(offset, (BlockState)CROWN_WALL_STATE.m_61124_((Property)CorrockCrownWallBlock.FACING, (Comparable)direction), 2);
                            continue block4;
                        }
                    }
                }
            }

            static class BottomStepsRotationInfo {
                private final int xDirection;
                private final int zDirection;
                private final Direction ledgeFillDirection;
                private final int firstSmallStepMinX;
                private final int firstSmallStepMinZ;
                private final int firstSmallStepMaxX;
                private final int firstSmallStepMaxZ;
                private final int secondSmallStepMinX;
                private final int secondSmallStepMinZ;
                private final int secondSmallStepMaxX;
                private final int secondSmallStepMaxZ;
                private final int mediumStepOffsetX;
                private final int mediumStepOffsetZ;
                private final int largeStepOffsetX;
                private final int largeStepOffsetZ;
                private final Direction mediumStepDirection;
                private final Direction largeStepDirection;

                BottomStepsRotationInfo(int xDirection, int zDirection, Direction ledgeFillDirection, int firstSmallStepMinX, int firstSmallStepMinZ, int firstSmallStepMaxX, int firstSmallStepMaxZ, int secondSmallStepMinX, int secondSmallStepMinZ, int secondSmallStepMaxX, int secondSmallStepMaxZ, int mediumStepOffsetX, int mediumStepOffsetZ, int largeStepOffsetX, int largeStepOffsetZ, Direction mediumStepDirection, Direction largeStepDirection) {
                    this.xDirection = xDirection;
                    this.zDirection = zDirection;
                    this.ledgeFillDirection = ledgeFillDirection;
                    this.firstSmallStepMinX = firstSmallStepMinX;
                    this.firstSmallStepMinZ = firstSmallStepMinZ;
                    this.firstSmallStepMaxX = firstSmallStepMaxX;
                    this.firstSmallStepMaxZ = firstSmallStepMaxZ;
                    this.secondSmallStepMinX = secondSmallStepMinX;
                    this.secondSmallStepMinZ = secondSmallStepMinZ;
                    this.secondSmallStepMaxX = secondSmallStepMaxX;
                    this.secondSmallStepMaxZ = secondSmallStepMaxZ;
                    this.mediumStepOffsetX = mediumStepOffsetX;
                    this.mediumStepOffsetZ = mediumStepOffsetZ;
                    this.largeStepOffsetX = largeStepOffsetX;
                    this.largeStepOffsetZ = largeStepOffsetZ;
                    this.mediumStepDirection = mediumStepDirection;
                    this.largeStepDirection = largeStepDirection;
                }
            }
        }

        private static class NestStalactite {
            private final int radius;
            private final int length;
            private final int xOffset;
            private final int zOffset;

            private NestStalactite(RandomSource random) {
                this.radius = random.m_188503_(2) + 3;
                this.length = random.m_188503_(3) + 5;
                this.xOffset = random.m_188503_(15) - random.m_188503_(15);
                this.zOffset = random.m_188503_(15) - random.m_188503_(15);
            }

            private void generate(WorldGenLevel world, BlockPos origin, RandomSource random, PerlinNoise noiseGenerator, BoundingBox boundingBox) {
                ArrayList<BlockPos> possibleDecorationPositions = new ArrayList<BlockPos>();
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                int originX = origin.m_123341_();
                int originY = origin.m_123342_();
                int originZ = origin.m_123343_();
                int radius = this.radius;
                int length = this.length;
                float noiseMultiplier = (float)radius * 0.25f;
                for (int x = originX - radius; x < originX + radius; ++x) {
                    for (int y = originY - length; y < originY; ++y) {
                        block2: for (int z = originZ - radius; z < originZ + radius; ++z) {
                            double frequency;
                            double shapeNoise;
                            double localZ;
                            double localY;
                            double localX;
                            double distanceSq;
                            mutable.m_122178_(x, y, z);
                            if (!boundingBox.m_71051_((Vec3i)mutable) || !((distanceSq = (localX = (double)((float)(x - originX) / (float)radius)) * localX + (localY = (double)((float)(y - originY) / ((float)length - 1.0f))) * localY + (localZ = (double)((float)(z - originZ) / (float)radius)) * localZ) <= 1.0 + (shapeNoise = noiseGenerator.m_75408_((double)x * (frequency = 2.0), (double)y * frequency, (double)z * frequency) * (double)noiseMultiplier))) continue;
                            for (int yU = 0; yU <= length; ++yU) {
                                Block block = world.m_8055_((BlockPos)mutable).m_60734_();
                                if (!world.m_46859_((BlockPos)mutable) && block != EETLE_EGSS && !(block instanceof CorrockCrownBlock)) continue block2;
                                possibleDecorationPositions.add(mutable.m_7949_());
                                world.m_7731_((BlockPos)mutable, CORROCK_BLOCK_STATE, 2);
                                mutable.m_142448_(mutable.m_123342_() + 1);
                            }
                        }
                    }
                }
                for (BlockPos pos : possibleDecorationPositions) {
                    if (!(random.m_188501_() < 0.1f)) continue;
                    EetleEggBlock.shuffleDirections(ATTACHMENT_DIRECTIONS, random);
                    for (Direction direction : ATTACHMENT_DIRECTIONS) {
                        BlockPos offset = pos.m_121945_(direction);
                        if (!boundingBox.m_71051_((Vec3i)offset) || !world.m_46859_(offset)) continue;
                        if (random.m_188499_()) {
                            world.m_7731_(offset, (BlockState)EETLE_EGGS_STATE.m_61124_((Property)EetleEggBlock.FACING, (Comparable)direction), 2);
                            continue;
                        }
                        if (direction.m_122434_() == Direction.Axis.Y) {
                            world.m_7731_(offset, (BlockState)((BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(direction == Direction.DOWN))).m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))), 2);
                            continue;
                        }
                        world.m_7731_(offset, (BlockState)CROWN_WALL_STATE.m_61124_((Property)CorrockCrownWallBlock.FACING, (Comparable)direction), 2);
                    }
                }
            }
        }

        private static class NestTunnel {
            private static final Set<Block> CORROCK_REPLACEABLE = Sets.newHashSet((Object[])new Block[]{Blocks.f_50259_, Blocks.f_50069_, EUMUS, CORROCK_BLOCK});
            private static final Vec3 UP = new Vec3(0.0, 1.0, 1.0);
            private final Direction facing;
            private final int xOffset;
            private final int yOffset;
            private final int zOffset;
            private final List<BlockPos> airPositions = new ArrayList<BlockPos>();
            private final List<BlockPos> corrockPositions = new ArrayList<BlockPos>();
            private final List<TunnelDecoration> decorations = new ArrayList<TunnelDecoration>();
            private BlockPos start;
            private NestCave nestCave = null;
            private boolean goesToSurface;

            private NestTunnel(RandomSource random, Direction facing) {
                this.facing = facing;
                this.yOffset = random.m_188503_(6) - random.m_188503_(6);
                Direction rotateY = facing.m_122427_();
                int offset = random.m_188503_(11) - random.m_188503_(11);
                this.xOffset = rotateY.m_122429_() * offset;
                this.zOffset = rotateY.m_122431_() * offset;
            }

            private void setup(BlockPos startPos, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState, PerlinNoise noiseGenerator, RandomSource random) {
                BlockPos end;
                this.start = startPos = startPos.m_7918_(this.xOffset, this.yOffset, this.zOffset);
                ArrayList<Vec3> points = new ArrayList<Vec3>();
                Vec3 startVec = Vec3.m_82528_((Vec3i)startPos);
                Direction facing = this.facing;
                if (this.goesToSurface) {
                    end = startPos.m_5484_(facing, 16 + random.m_188503_(9)).m_5484_(facing.m_122427_(), (int)MathUtil.makeNegativeRandomly((double)(random.m_188503_(7) + 6), (RandomSource)random));
                    int endX = end.m_123341_();
                    int endZ = end.m_123343_();
                    int topY = chunkGenerator.m_223221_(endX, endZ, Heightmap.Types.WORLD_SURFACE, heightAccessor, randomState);
                    end = new BlockPos(endX, topY, endZ);
                    Vec3 endVec = Vec3.m_82528_((Vec3i)end);
                    Vec3 difference = endVec.m_82546_(startVec);
                    Vec3 normalizedDifference = difference.m_82541_();
                    Vec3 anchorStart = startVec.m_82546_(normalizedDifference).m_82520_((double)(-6 * facing.m_122429_()), 0.0, (double)(-6 * facing.m_122431_()));
                    Vec3 anchorEnd = endVec.m_82549_(normalizedDifference).m_82520_(0.0, 6.0, 0.0);
                    points.add(anchorStart);
                    points.add(startVec);
                    Vec3 offset = UP.m_82537_(normalizedDifference);
                    double offsetX = offset.f_82479_;
                    double offsetZ = offset.f_82481_;
                    int iterations = 6;
                    for (int i = 0; i < iterations; ++i) {
                        points.add(startVec.m_82549_(difference.m_82490_((double)((float)i / (float)iterations))).m_82520_(offsetX * (random.m_188500_() - 0.5) * 5.0, (random.m_188500_() - 0.25) * 5.0, offsetZ * (random.m_188500_() - 0.5) * 5.0));
                    }
                    points.add(endVec);
                    points.add(anchorEnd);
                } else {
                    end = startPos.m_5484_(facing, 24 + random.m_188503_(9)).m_5484_(facing.m_122427_(), (int)MathUtil.makeNegativeRandomly((double)(random.m_188503_(7) + 6), (RandomSource)random)).m_5484_(Direction.UP, (int)MathUtil.makeNegativeRandomly((double)(random.m_188503_(7) + 6), (RandomSource)random));
                    Vec3 endVec = Vec3.m_82528_((Vec3i)end);
                    Vec3 difference = endVec.m_82546_(startVec);
                    Vec3 normalizedDifference = difference.m_82541_();
                    float xOffset = facing.m_122429_();
                    float zOffset = facing.m_122431_();
                    Vec3 anchorStart = startVec.m_82546_(normalizedDifference).m_82520_((double)(-6.0f * xOffset), 0.0, (double)(-6.0f * zOffset));
                    Vec3 anchorEnd = endVec.m_82549_(normalizedDifference).m_82520_((double)(-6.0f * xOffset), 0.0, (double)(-6.0f * zOffset));
                    points.add(anchorStart);
                    points.add(startVec);
                    Vec3 offset = UP.m_82537_(normalizedDifference);
                    double offsetX = offset.f_82479_;
                    double offsetZ = offset.f_82481_;
                    int iterations = 6;
                    for (int i = 0; i < iterations; ++i) {
                        points.add(startVec.m_82549_(difference.m_82490_((double)((float)i / (float)iterations))).m_82520_(offsetX * (random.m_188500_() - 0.5) * 4.0, (random.m_188500_() - 0.25) * 4.0, offsetZ * (random.m_188500_() - 0.5) * 4.0));
                    }
                    points.add(endVec);
                    points.add(anchorEnd);
                    NestCave nestCave = this.nestCave;
                    if (nestCave != null) {
                        nestCave.setup(end, random, chunkGenerator, heightAccessor, randomState, noiseGenerator);
                    }
                }
                MathUtil.CatmullRomSpline spline = new MathUtil.CatmullRomSpline(points.toArray(new Vec3[0]), MathUtil.CatmullRomSpline.SplineType.CHORDAL);
                int steps = (int)(10.0 + Math.sqrt(startPos.m_123331_((Vec3i)end)) * 3.0);
                BlockPos prevPos = null;
                List<BlockPos> airPositions = this.airPositions;
                List<BlockPos> corrockPositions = this.corrockPositions;
                ArrayList<EumusPatch> eumusPatches = new ArrayList<EumusPatch>();
                ArrayList<TunnelDecoration> eggsAndCorrock = new ArrayList<TunnelDecoration>();
                for (int i = 0; i < steps; ++i) {
                    float progress = (float)i / (float)steps;
                    BlockPos interpolatedPos = spline.interpolate(progress);
                    if (interpolatedPos.equals(prevPos)) continue;
                    prevPos = interpolatedPos;
                    int originX = interpolatedPos.m_123341_();
                    int originY = interpolatedPos.m_123342_();
                    int originZ = interpolatedPos.m_123343_();
                    int radius = 6 + random.m_188503_(3);
                    for (int x = -radius; x <= radius; ++x) {
                        for (int y = -radius; y <= radius; ++y) {
                            for (int z = -radius; z <= radius; ++z) {
                                int distanceSq = x * x + y * y + z * z;
                                if (distanceSq > radius) continue;
                                BlockPos spherePos = new BlockPos(originX + x, originY + y, originZ + z);
                                airPositions.add(spherePos);
                                if (distanceSq >= radius - 2) {
                                    corrockPositions.add(spherePos);
                                }
                                if (random.m_188501_() < 5.0E-4f && eumusPatches.size() < 3) {
                                    eumusPatches.add(new EumusPatch(spherePos, random.m_188503_(2) + 3));
                                }
                                if (!(random.m_188501_() < 0.01f) || eggsAndCorrock.size() >= 48) continue;
                                if (random.m_188501_() < 0.25f) {
                                    eggsAndCorrock.add(new EetleEggPatch(spherePos));
                                    continue;
                                }
                                eggsAndCorrock.add(new CorrockPatch(spherePos));
                            }
                        }
                    }
                }
                List<TunnelDecoration> decorations = this.decorations;
                decorations.addAll(eumusPatches);
                decorations.addAll(eggsAndCorrock);
            }

            private void generateCave(WorldGenLevel world, PerlinNoise noiseGenerator, RandomSource random, BoundingBox bounds) {
                NestCave nestCave = this.nestCave;
                if (nestCave != null) {
                    nestCave.generate(world, noiseGenerator, random, bounds);
                }
            }

            private void generate(WorldGenLevel world, RandomSource random, BoundingBox bounds) {
                for (BlockPos pos : this.airPositions) {
                    if (!bounds.m_71051_((Vec3i)pos) || !CARVABLE_BLOCKS.contains(world.m_8055_(pos).m_60734_())) continue;
                    world.m_7731_(pos, f_73382_, 2);
                }
                int radius = 1;
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                for (BlockPos corrockPos : this.corrockPositions) {
                    int originX = corrockPos.m_123341_();
                    int originY = corrockPos.m_123342_();
                    int originZ = corrockPos.m_123343_();
                    for (int x = -radius; x <= radius; ++x) {
                        for (int y = -radius; y <= radius; ++y) {
                            for (int z = -radius; z <= radius; ++z) {
                                mutable.m_122178_(originX + x, originY + y, originZ + z);
                                if (!bounds.m_71051_((Vec3i)mutable) || !CORROCK_REPLACEABLE.contains(world.m_8055_((BlockPos)mutable).m_60734_())) continue;
                                world.m_7731_((BlockPos)mutable, CORROCK_BLOCK_STATE, 2);
                                if (!random.m_188499_()) continue;
                                mutable.m_122173_(Direction.m_235672_((RandomSource)random));
                                if (!bounds.m_71051_((Vec3i)mutable) || !CORROCK_REPLACEABLE.contains(world.m_8055_((BlockPos)mutable).m_60734_())) continue;
                                world.m_7731_((BlockPos)mutable, CORROCK_BLOCK_STATE, 2);
                            }
                        }
                    }
                }
            }

            private void generateDecorations(WorldGenLevel world, PerlinNoise noiseGenerator, RandomSource random, BoundingBox bounds) {
                for (TunnelDecoration decoration : this.decorations) {
                    if (decoration.isNotSetup()) {
                        decoration.setup(random);
                    }
                    decoration.generate(world, noiseGenerator, random, bounds);
                }
            }

            static class NestCave {
                private final StateMap cave = new StateMap();
                private final NestCaveType type;
                private final List<com.teamabnormals.endergetic.common.levelgen.structure.structures.EetleNestPieces$EetleNestPiece$EumusPatch> eumusPatches = new ArrayList<com.teamabnormals.endergetic.common.levelgen.structure.structures.EetleNestPieces$EetleNestPiece$EumusPatch>();
                private final List<EetleEggPatch> eetleEggPatches = new ArrayList<EetleEggPatch>();
                private final List<CorrockPatch> corrockPatches = new ArrayList<CorrockPatch>();
                private BlockPos center;

                private NestCave(RandomSource random) {
                    this.type = NestCaveType.random(random);
                }

                private void setup(BlockPos end, RandomSource random, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState, PerlinNoise noiseGenerator) {
                    this.center = end;
                    NestCaveType type = this.type;
                    int horizontalRadius = type.horizontalRadius;
                    int verticalRadius = type.verticalRadius;
                    if (NestCave.isAreaCarvable(end, horizontalRadius, verticalRadius, chunkGenerator, heightAccessor, randomState)) {
                        int endX = end.m_123341_();
                        int endY = end.m_123342_();
                        int endZ = end.m_123343_();
                        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                        StateMap cave = this.cave;
                        for (int x = endX - horizontalRadius; x <= endX + horizontalRadius; ++x) {
                            for (int z = endZ - horizontalRadius; z <= endZ + horizontalRadius; ++z) {
                                for (int y = endY - verticalRadius; y <= endY + verticalRadius; ++y) {
                                    mutable.m_122178_(x, y, z);
                                    double localX = (float)(x - endX) / (float)horizontalRadius;
                                    double localY = (float)(y - endY) / (float)verticalRadius;
                                    double localZ = (float)(z - endZ) / (float)horizontalRadius;
                                    double distanceSq = localX * localX + localY * localY + localZ * localZ;
                                    double frequency = 0.65f;
                                    double shapeNoise = noiseGenerator.m_75408_((double)x * frequency, (double)y * frequency, (double)z * frequency) * 0.5;
                                    if (distanceSq >= (double)0.7f + shapeNoise && distanceSq <= (double)1.2f + shapeNoise) {
                                        cave.setBlockState((BlockPos)mutable, CORROCK_BLOCK_STATE);
                                        continue;
                                    }
                                    if (!(distanceSq <= (double)0.9f + shapeNoise)) continue;
                                    cave.setBlockState((BlockPos)mutable, Blocks.f_50627_.m_49966_());
                                }
                            }
                        }
                        List<com.teamabnormals.endergetic.common.levelgen.structure.structures.EetleNestPieces$EetleNestPiece$EumusPatch> eumusPatches = this.eumusPatches;
                        int eumusPatchCount = random.m_188503_(2) + 2;
                        EumusPatch.PatchType patchType = type.patchType;
                        for (int i = 0; i < eumusPatchCount; ++i) {
                            eumusPatches.add(new com.teamabnormals.endergetic.common.levelgen.structure.structures.EetleNestPieces$EetleNestPiece$EumusPatch(patchType, random));
                        }
                        List<EetleEggPatch> eetleEggPatches = this.eetleEggPatches;
                        for (int i = 0; i < type.eetleEggPatches; ++i) {
                            eetleEggPatches.add(new EetleEggPatch(end.m_7918_(random.m_188503_(horizontalRadius) - random.m_188503_(horizontalRadius), random.m_188503_(verticalRadius) - random.m_188503_(verticalRadius), random.m_188503_(horizontalRadius) - random.m_188503_(horizontalRadius)), random));
                        }
                        List<CorrockPatch> corrockPatches = this.corrockPatches;
                        for (int i = 0; i < type.corrockPatches; ++i) {
                            corrockPatches.add(new CorrockPatch(end.m_7918_(random.m_188503_(horizontalRadius) - random.m_188503_(horizontalRadius), -random.m_188503_(verticalRadius), random.m_188503_(horizontalRadius) - random.m_188503_(horizontalRadius)), random));
                        }
                    }
                }

                private void generate(WorldGenLevel world, PerlinNoise noiseGenerator, RandomSource random, BoundingBox bounds) {
                    this.cave.generate(world, bounds);
                    BlockPos center = this.center;
                    for (com.teamabnormals.endergetic.common.levelgen.structure.structures.EetleNestPieces$EetleNestPiece$EumusPatch eumusPatch : this.eumusPatches) {
                        eumusPatch.generate(world, center, noiseGenerator, bounds);
                    }
                    for (EetleEggPatch eetleEggPatch : this.eetleEggPatches) {
                        eetleEggPatch.generate(world, random, bounds);
                    }
                    for (CorrockPatch corrockPatch : this.corrockPatches) {
                        corrockPatch.generate(world, bounds);
                    }
                }

                private static boolean isAreaCarvable(BlockPos center, int horizontalRadius, int verticalRadius, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor, RandomState randomState) {
                    int foundAirBlocks = 0;
                    int centerX = center.m_123341_();
                    int centerY = center.m_123342_();
                    int centerZ = center.m_123343_();
                    int maxAirBlocks = (int)((float)(horizontalRadius * 2 * horizontalRadius * 2) * 0.25f);
                    for (int x = centerX - horizontalRadius; x <= centerX + horizontalRadius; ++x) {
                        for (int z = centerZ - horizontalRadius; z <= centerZ + horizontalRadius; ++z) {
                            NoiseColumn column = chunkGenerator.m_214184_(x, z, heightAccessor, randomState);
                            for (int y = centerY - verticalRadius; y <= centerY + verticalRadius; ++y) {
                                Block block = column.m_183556_(y).m_60734_();
                                if (CARVABLE_BLOCKS.contains(block)) continue;
                                if (block == Blocks.f_50016_) {
                                    if (foundAirBlocks++ < maxAirBlocks) continue;
                                    return false;
                                }
                                return false;
                            }
                        }
                    }
                    return true;
                }

                static enum NestCaveType {
                    SMALL(9, 6, 27, 20, EumusPatch.PatchType.SMALL),
                    MEDIUM(12, 9, 48, 36, EumusPatch.PatchType.MEDIUM),
                    LARGE(14, 11, 64, 49, EumusPatch.PatchType.LARGE);

                    private static final NestCaveType[] VALUES;
                    private final int horizontalRadius;
                    private final int verticalRadius;
                    private final int eetleEggPatches;
                    private final int corrockPatches;
                    private final EumusPatch.PatchType patchType;

                    private NestCaveType(int horizontalRadius, int verticalRadius, int eetleEggPatches, int corrockPatches, EumusPatch.PatchType patchType) {
                        this.horizontalRadius = horizontalRadius;
                        this.verticalRadius = verticalRadius;
                        this.eetleEggPatches = eetleEggPatches;
                        this.corrockPatches = corrockPatches;
                        this.patchType = patchType;
                    }

                    private static NestCaveType random(RandomSource random) {
                        return VALUES[random.m_188503_(VALUES.length)];
                    }

                    static {
                        VALUES = NestCaveType.values();
                    }
                }

                static class EetleEggPatch {
                    private final StateMap stateMap = new StateMap();

                    EetleEggPatch(BlockPos origin, RandomSource random) {
                        EetleEggBlock.shuffleDirections(EGG_DIRECTIONS, random);
                        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                        StateMap stateMap = this.stateMap;
                        for (int j = 0; j < 48; ++j) {
                            Direction[] directionArray;
                            int n;
                            int n2;
                            mutable.m_122154_((Vec3i)origin, random.m_188503_(9) - random.m_188503_(9), random.m_188503_(9) - random.m_188503_(9), random.m_188503_(9) - random.m_188503_(9));
                            if (!(random.m_188501_() < 0.4f) || (n2 = 0) >= (n = (directionArray = EGG_DIRECTIONS).length)) continue;
                            Direction direction = directionArray[n2];
                            BlockState state = (BlockState)EETLE_EGGS_STATE.m_61124_((Property)EetleEggBlock.FACING, (Comparable)direction.m_122424_());
                            stateMap.setBlockState((BlockPos)mutable, (BlockState)state.m_61124_((Property)EetleEggBlock.SIZE, (Comparable)Integer.valueOf(random.m_188501_() < 0.75f ? 0 : (random.m_188501_() < 0.6f ? 1 : 2))));
                        }
                    }

                    private void generate(WorldGenLevel world, RandomSource random, BoundingBox bounds) {
                        this.stateMap.stateMap.forEach((pos, state) -> {
                            Block opposite;
                            BlockPos offset;
                            if (bounds.m_71051_((Vec3i)pos) && world.m_46859_(pos) && bounds.m_71051_((Vec3i)(offset = pos.m_121945_(((Direction)state.m_61143_((Property)EetleEggBlock.FACING)).m_122424_()))) && ((opposite = world.m_8055_(offset).m_60734_()) == CORROCK_BLOCK || opposite == EUMUS)) {
                                world.m_7731_(pos, state, 2);
                                EetleEggPatch.spreadInfestedCorrockAtPos(world, offset, random, bounds);
                            }
                        });
                    }

                    private static void spreadInfestedCorrockAtPos(WorldGenLevel world, BlockPos pos, RandomSource random, BoundingBox bounds) {
                        int radius = 1;
                        if (bounds.m_71051_((Vec3i)pos)) {
                            world.m_7731_(pos, INFESTED_STATE, 2);
                        }
                        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                        for (int x = -radius; x <= radius; ++x) {
                            for (int y = -radius; y <= radius; ++y) {
                                for (int z = -radius; z <= radius; ++z) {
                                    if (!bounds.m_71051_((Vec3i)mutable.m_122154_((Vec3i)pos, x, y, z)) || world.m_8055_((BlockPos)mutable).m_60734_() != CORROCK_BLOCK || !(random.m_188501_() <= 0.25f)) continue;
                                    world.m_7731_((BlockPos)mutable, INFESTED_STATE, 2);
                                }
                            }
                        }
                    }
                }

                static class CorrockPatch {
                    private final StateMap stateMap;

                    CorrockPatch(BlockPos origin, RandomSource random) {
                        StateMap stateMap = this.stateMap = new StateMap();
                        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                        for (int i = 0; i < 32; ++i) {
                            mutable.m_122154_((Vec3i)origin, random.m_188503_(8) - random.m_188503_(8), random.m_188503_(4) - random.m_188503_(4), random.m_188503_(8) - random.m_188503_(8));
                            if (!random.m_188499_()) continue;
                            stateMap.setBlockState((BlockPos)mutable, CORROCK_STATE);
                        }
                    }

                    private void generate(WorldGenLevel world, BoundingBox bounds) {
                        this.stateMap.stateMap.forEach((pos, state) -> {
                            Block below;
                            if (bounds.m_71051_((Vec3i)pos) && world.m_46859_(pos) && ((below = world.m_8055_(pos.m_7495_()).m_60734_()) == CORROCK_BLOCK || below == EUMUS)) {
                                world.m_7731_(pos, state, 2);
                            }
                        });
                    }
                }
            }

            static class EumusPatch
            implements TunnelDecoration {
                private final BlockPos origin;
                private final int radius;

                EumusPatch(BlockPos origin, int radius) {
                    this.origin = origin;
                    this.radius = radius;
                }

                @Override
                public void setup(RandomSource random) {
                }

                @Override
                public void generate(WorldGenLevel world, PerlinNoise noiseGenerator, RandomSource random, BoundingBox bounds) {
                    EetleNestPiece.createEumusPatch(world, this.origin, noiseGenerator, this.radius, bounds);
                }

                @Override
                public boolean isNotSetup() {
                    return false;
                }
            }

            static class EetleEggPatch
            implements TunnelDecoration {
                private final StateMap stateMap = new StateMap();
                private final BlockPos origin;

                EetleEggPatch(BlockPos origin) {
                    this.origin = origin;
                }

                @Override
                public void setup(RandomSource random) {
                    StateMap stateMap = this.stateMap;
                    BlockPos origin = this.origin;
                    BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                    EetleEggBlock.shuffleDirections(EGG_DIRECTIONS, random);
                    for (int j = 0; j < 48; ++j) {
                        Direction[] directionArray;
                        int n;
                        int n2;
                        mutable.m_122154_((Vec3i)origin, random.m_188503_(9) - random.m_188503_(9), random.m_188503_(9) - random.m_188503_(9), random.m_188503_(9) - random.m_188503_(9));
                        if (!(random.m_188501_() < 0.4f) || (n2 = 0) >= (n = (directionArray = EGG_DIRECTIONS).length)) continue;
                        Direction direction = directionArray[n2];
                        BlockState state = (BlockState)EETLE_EGGS_STATE.m_61124_((Property)EetleEggBlock.FACING, (Comparable)direction.m_122424_());
                        stateMap.setBlockState((BlockPos)mutable, (BlockState)state.m_61124_((Property)EetleEggBlock.SIZE, (Comparable)Integer.valueOf(random.m_188501_() < 0.75f ? 0 : (random.m_188501_() < 0.6f ? 1 : 2))));
                    }
                    stateMap.setup = true;
                }

                @Override
                public void generate(WorldGenLevel world, PerlinNoise noiseGenerator, RandomSource random, BoundingBox bounds) {
                    StateMap stateMap = this.stateMap;
                    stateMap.stateMap.forEach((pos, state) -> {
                        Block opposite;
                        BlockPos offset;
                        if (bounds.m_71051_((Vec3i)pos) && world.m_46859_(pos) && bounds.m_71051_((Vec3i)(offset = pos.m_121945_(((Direction)state.m_61143_((Property)EetleEggBlock.FACING)).m_122424_()))) && ((opposite = world.m_8055_(offset).m_60734_()) == CORROCK_BLOCK || opposite == EUMUS)) {
                            world.m_7731_(pos, state, 2);
                            NestCave.EetleEggPatch.spreadInfestedCorrockAtPos(world, offset, random, bounds);
                        }
                    });
                }

                @Override
                public boolean isNotSetup() {
                    return !this.stateMap.setup;
                }
            }

            static class CorrockPatch
            implements TunnelDecoration {
                private final StateMap stateMap = new StateMap();
                private final BlockPos origin;

                CorrockPatch(BlockPos origin) {
                    this.origin = origin;
                }

                @Override
                public void setup(RandomSource random) {
                    StateMap stateMap = this.stateMap;
                    BlockPos origin = this.origin;
                    BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                    for (int i = 0; i < 32; ++i) {
                        mutable.m_122154_((Vec3i)origin, random.m_188503_(8) - random.m_188503_(8), random.m_188503_(4) - random.m_188503_(4), random.m_188503_(8) - random.m_188503_(8));
                        if (!random.m_188499_()) continue;
                        stateMap.setBlockState((BlockPos)mutable, CORROCK_STATE);
                    }
                    stateMap.setup = true;
                }

                @Override
                public void generate(WorldGenLevel world, PerlinNoise noiseGenerator, RandomSource random, BoundingBox bounds) {
                    StateMap stateMap = this.stateMap;
                    stateMap.stateMap.forEach((pos, state) -> {
                        Block below;
                        if (bounds.m_71051_((Vec3i)pos) && world.m_46859_(pos) && ((below = world.m_8055_(pos.m_7495_()).m_60734_()) == CORROCK_BLOCK || below == EUMUS)) {
                            world.m_7731_(pos, state, 2);
                        }
                    });
                }

                @Override
                public boolean isNotSetup() {
                    return !this.stateMap.setup;
                }
            }

            static interface TunnelDecoration {
                public void setup(RandomSource var1);

                public void generate(WorldGenLevel var1, PerlinNoise var2, RandomSource var3, BoundingBox var4);

                public boolean isNotSetup();
            }
        }

        static class CorrockShelf {
            private static final Direction[] HORIZONTALS = (Direction[])Direction.Plane.HORIZONTAL.m_122557_().toArray(Direction[]::new);
            private final BlockPos pos;
            private final StateMap corrock = new StateMap();
            private final StateMap decorations = new StateMap();

            CorrockShelf(BlockPos pos, RandomSource random) {
                this.pos = pos;
                int size = random.m_188499_() ? 3 : 4;
                int edgeBias = 10;
                int min = -size;
                int originX = pos.m_123341_();
                int originY = pos.m_123342_();
                int originZ = pos.m_123343_();
                int underXDistance = random.m_188503_(2) + 2;
                int underZDistance = random.m_188503_(2) + 2;
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
                StateMap corrock = this.corrock;
                StateMap decorations = this.decorations;
                ArrayList<BlockPos> wallCrowns = new ArrayList<BlockPos>();
                for (int x = min; x <= size; ++x) {
                    for (int z = min; z <= size; ++z) {
                        double radiusMinusOne;
                        mutable.m_122178_(originX + x, originY, originZ + z);
                        double radius = (Math.cos(4.0 * Math.atan2(z, x)) / (double)edgeBias + 1.0) * (double)size;
                        int distance = x * x + z * z;
                        if (!((double)distance < radius * radius)) continue;
                        corrock.setBlockState((BlockPos)mutable, CORROCK_BLOCK_STATE);
                        if ((double)(x * x) < (radius - (double)underXDistance) * (radius - (double)underXDistance) && (double)(z * z) < (radius - (double)underZDistance) * (radius - (double)underZDistance)) {
                            BlockPos down = mutable.m_7495_();
                            corrock.setBlockState(down, CORROCK_BLOCK_STATE);
                        }
                        if (!(random.m_188501_() < 0.75f) || !((double)distance > (radiusMinusOne = radius - 1.0) * radiusMinusOne)) continue;
                        if (random.m_188501_() < 0.25f) {
                            decorations.setBlockState(mutable.m_7494_(), (BlockState)CROWN_STANDING_STATE.m_61124_((Property)CorrockCrownStandingBlock.ROTATION, (Comparable)Integer.valueOf(random.m_188503_(16))));
                            continue;
                        }
                        wallCrowns.add(mutable.m_7949_());
                    }
                }
                Map<BlockPos, BlockState> corrockStateMap = corrock.stateMap;
                block2: for (BlockPos crownPos : wallCrowns) {
                    int crownsPlaced = 0;
                    EetleEggBlock.shuffleDirections(HORIZONTALS, random);
                    for (Direction direction : HORIZONTALS) {
                        BlockPos offset = crownPos.m_121945_(direction);
                        if (corrockStateMap.containsKey(offset)) continue;
                        decorations.setBlockState(offset, (BlockState)CROWN_WALL_STATE.m_61124_((Property)CorrockCrownWallBlock.FACING, (Comparable)direction));
                        if (random.m_188501_() > 0.75f || crownsPlaced++ == 1) continue block2;
                    }
                }
            }

            private void generate(WorldGenLevel world, BoundingBox bounds) {
                this.corrock.stateMap.forEach((pos, state) -> {
                    if (bounds.m_71051_((Vec3i)pos) && world.m_46859_(pos)) {
                        world.m_7731_(pos, state, 2);
                    }
                });
            }

            private void generateDecorations(WorldGenLevel world, BoundingBox bounds) {
                this.decorations.stateMap.forEach((pos, state) -> {
                    if (bounds.m_71051_((Vec3i)pos) && world.m_46859_(pos)) {
                        if (state.m_60734_() instanceof CorrockCrownStandingBlock) {
                            if (world.m_8055_(pos.m_7495_()).m_60734_() == CORROCK_BLOCK) {
                                world.m_7731_(pos, state, 2);
                            }
                        } else {
                            BlockPos offset = pos.m_121945_(((Direction)state.m_61143_((Property)CorrockCrownWallBlock.FACING)).m_122424_());
                            if (bounds.m_71051_((Vec3i)offset) && world.m_8055_(offset).m_60734_() == CORROCK_BLOCK) {
                                world.m_7731_(pos, state, 2);
                            }
                        }
                    }
                });
            }
        }
    }
}

