/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.endergetic.common.levelgen.feature;

import com.mojang.serialization.Codec;
import com.teamabnormals.endergetic.common.block.EetleEggBlock;
import com.teamabnormals.endergetic.common.levelgen.configs.EndergeticPatchConfig;
import com.teamabnormals.endergetic.core.registry.EEBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class EetleEggPatchFeature
extends Feature<EndergeticPatchConfig> {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final BlockState BASE_STATE = ((Block)EEBlocks.EETLE_EGG.get()).m_49966_();
    private static final BlockState INFESTED_STATE = ((Block)EEBlocks.INFESTED_CORROCK.get()).m_49966_();

    public EetleEggPatchFeature(Codec<EndergeticPatchConfig> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<EndergeticPatchConfig> context) {
        int i = 0;
        WorldGenLevel world = context.m_159774_();
        EndergeticPatchConfig config = (EndergeticPatchConfig)context.m_159778_();
        BlockPos pos = EndergeticPatchConfig.getPos(world, context.m_159777_(), config.shouldSearchDown());
        RandomSource rand = context.m_225041_();
        EetleEggBlock.shuffleDirections(DIRECTIONS, rand);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        float chance = config.getFrequency();
        Block corrockBlock = (Block)EEBlocks.END_CORROCK_BLOCK.get();
        Block eumus = (Block)EEBlocks.EUMUS.get();
        block0: for (int j = 0; j < 45; ++j) {
            mutable.m_122154_((Vec3i)pos, rand.m_188503_(9) - rand.m_188503_(9), rand.m_188503_(9) - rand.m_188503_(9), rand.m_188503_(9) - rand.m_188503_(9));
            if (!world.m_46859_((BlockPos)mutable) || !(rand.m_188501_() < chance)) continue;
            for (Direction direction : DIRECTIONS) {
                BlockState state;
                BlockPos offsetPos = mutable.m_121945_(direction);
                Block offsetBlock = world.m_8055_(offsetPos).m_60734_();
                if (offsetBlock != corrockBlock && offsetBlock != eumus || !(state = (BlockState)BASE_STATE.m_61124_((Property)EetleEggBlock.FACING, (Comparable)direction.m_122424_())).m_60710_((LevelReader)world, (BlockPos)mutable)) continue;
                world.m_7731_((BlockPos)mutable, (BlockState)state.m_61124_((Property)EetleEggBlock.SIZE, (Comparable)Integer.valueOf(rand.m_188501_() < 0.75f ? 0 : (rand.m_188501_() < 0.6f ? 1 : 2))), 2);
                EetleEggPatchFeature.spreadInfestedCorrockAtPos(world, offsetPos, rand, corrockBlock);
                ++i;
                continue block0;
            }
        }
        return i > 0;
    }

    private static void spreadInfestedCorrockAtPos(WorldGenLevel level, BlockPos pos, RandomSource random, Block corrockBlock) {
        int radius = 1;
        level.m_7731_(pos, INFESTED_STATE, 2);
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    if (level.m_8055_((BlockPos)mutable.m_122154_((Vec3i)pos, x, y, z)).m_60734_() != corrockBlock || !(random.m_188501_() <= 0.25f)) continue;
                    level.m_7731_((BlockPos)mutable, INFESTED_STATE, 2);
                }
            }
        }
    }
}

